/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.cli.ProcessResultConverter;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.git.GitCommand;
import com.telenav.cactus.maven.PrintMessageMojo;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.trigger.RunPolicies;
import com.telenav.cactus.util.PathUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="clone")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="clone", threadSafe=true)
public class CloneMojo
extends BaseMojo {
    @Parameter(property="cactus.clone.dest")
    private String cloneDest;
    @Parameter(property="cactus.delete.clone.dest.if.exists")
    private boolean deleteIfExists;
    @Parameter(property="cactus.base-branch", defaultValue="develop")
    private String developmentBranch;
    @Parameter(property="cactus..assets-branch", defaultValue="publish")
    private String assetsBranch;

    public CloneMojo() {
        super(RunPolicies.LAST_CONTAINING_GOAL);
    }

    private Path globalTempIfPossible() {
        Path result = Paths.get("/tmp", new String[0]);
        return PathUtils.ifExists((Path)result).orElse(PathUtils.temp());
    }

    private Path cloneDest() {
        if (this.cloneDest != null) {
            return Paths.get(this.cloneDest, new String[0]);
        }
        return this.globalTempIfPossible().resolve("cactus-clone-" + Long.toString(System.currentTimeMillis(), 36) + "-" + Integer.toString(Math.abs(ThreadLocalRandom.current().nextInt()), 36));
    }

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        GitCheckout.checkout((File)project.getBasedir()).flatMap(co -> co.submoduleRoot().toOptional()).flatMap(root -> root.defaultRemote()).ifPresentOrElse(remote -> CloneMojo.quietly(() -> {
            Path dest = this.cloneDest();
            log.info("Clone dest is " + dest);
            log.info("Clone URL is " + remote.fetchUrl);
            if (this.deleteIfExists && Files.exists(dest, new LinkOption[0])) {
                PathUtils.deleteFolderTree((Path)dest);
            }
            if (!Files.exists(dest.getParent(), new LinkOption[0])) {
                Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            }
            GitCommand clo = new GitCommand((ProcessResultConverter)ProcessResultConverter.strings(), dest.getParent(), new String[]{"clone", remote.fetchUrl, dest.getFileName().toString()});
            String output = (String)clo.run().awaitQuietly();
            log.info(output);
            log.info("Initializing submodules");
            log.info((String)new GitCommand((ProcessResultConverter)ProcessResultConverter.strings(), dest, new String[]{"submodule", "init"}).run().awaitQuietly());
            log.info("Updating submodules");
            log.info((String)new GitCommand((ProcessResultConverter)ProcessResultConverter.strings(), dest, new String[]{"submodule", "update"}).run().awaitQuietly());
            log.warn("Cloned " + remote.fetchUrl + " into " + dest + ". Getting all submodules on development branches.");
            GitCheckout co = (GitCheckout)GitCheckout.checkout((Path)dest).get();
            co.switchToBranch(this.developmentBranch);
            co.submodules().ifPresent(subs -> subs.forEach(s -> s.checkout().ifPresent(submodule -> {
                if (submodule.hasPomInRoot()) {
                    log.info("Move submodule " + submodule.name() + " to branch '" + this.developmentBranch + "'");
                    submodule.switchToBranch(this.developmentBranch);
                } else {
                    log.info("Move submodule " + submodule.name() + " to branch '" + this.assetsBranch + "'");
                    submodule.switchToBranch(this.assetsBranch);
                }
                submodule.pull();
            })));
            PrintMessageMojo.publishMessage("Cloned " + remote.fetchUrl + " into\ncheckout-root: " + dest, this.session(), false);
            this.emitMessage(dest);
        }), this.failingWith("No git repository, or missing remote for submodule root of " + project.getBasedir()));
    }
}

