/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.analysis.MavenProjectsScanner;
import com.telenav.cactus.analysis.ProjectScanConsumer;
import com.telenav.cactus.analysis.SourceScorer;
import com.telenav.cactus.analysis.WordCount;
import com.telenav.cactus.analysis.codeflowers.CodeflowersJsonGenerator;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.ScopedCheckoutsMojo;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.maven.trigger.RunPolicies;
import com.telenav.cactus.scope.ProjectFamily;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="codeflowers")
@Mojo(defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="codeflowers", threadSafe=true)
public class CodeFlowersMojo
extends ScopedCheckoutsMojo {
    @Parameter(property="cactus.indent", defaultValue="false")
    private boolean indent;
    @Parameter(property="cactus.tolerate.version.inconsistencies.families")
    private String tolerateVersionInconsistenciesIn;
    @Parameter(property="cactus.codeflowers.skip")
    private boolean skipped;

    public CodeFlowersMojo() {
        super(RunPolicies.FAMILY_ROOTS);
    }

    private Set<ProjectFamily> tolerateVersionInconsistenciesIn() {
        return this.tolerateVersionInconsistenciesIn == null ? Collections.emptySet() : ProjectFamily.fromCommaDelimited((String)this.tolerateVersionInconsistenciesIn, () -> null);
    }

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        if (this.skipped) {
            log.info("Codeflowers is skipped");
            return;
        }
        this.ifVerbose(() -> log.info("Codeflowers on " + project.getArtifactId() + " with " + this.scope() + " and " + this.families()));
        Map<ProjectFamily, Set<Pom>> all = this.allPoms(tree, checkouts);
        for (Map.Entry<ProjectFamily, Set<Pom>> e : all.entrySet()) {
            if (e.getValue().isEmpty()) continue;
            String version = this.checkConsistentVersion(e.getKey(), e.getValue(), tree);
            if (version == null) {
                log.warn("Got no versions at all in " + e.getKey());
                continue;
            }
            ProjectFamily fam = e.getKey();
            fam.assetsPath(myCheckout.submoduleRoot().map(GitCheckout::checkoutRoot)).ifPresentOrElse(assetsRoot -> {
                Path codeflowersPath = assetsRoot.resolve("docs").resolve(version).resolve("codeflowers").resolve("site").resolve("data");
                log.info("Will generate codeflowers for '" + fam + "' into " + codeflowersPath);
                MavenProjectsScanner scanner = new MavenProjectsScanner(log.child("scanProjects"), (SourceScorer)new WordCount(), (Collection)e.getValue(), this.isVerbose());
                CodeflowersJsonGenerator gen = new CodeflowersJsonGenerator(fam.toString(), codeflowersPath, this.indent, this.isPretend());
                scanner.scan((ProjectScanConsumer)gen);
            }, () -> log.warn("Could not find an assets root for family " + fam));
        }
    }

    private Map<ProjectFamily, Set<Pom>> allPoms(ProjectTree tree, Collection<? extends GitCheckout> checkouts) {
        HashMap<ProjectFamily, Set<Pom>> result = new HashMap<ProjectFamily, Set<Pom>>();
        for (GitCheckout gitCheckout : checkouts) {
            for (Pom pom : tree.projectsWithin(gitCheckout)) {
                if (pom.isPomProject()) continue;
                Set poms = result.computeIfAbsent(ProjectFamily.fromGroupId((String)pom.coordinates().groupId().text()), f -> new HashSet());
                poms.add(pom);
            }
        }
        return result;
    }

    private String checkConsistentVersion(ProjectFamily fam, Set<Pom> poms, ProjectTree tree) throws Exception {
        HashSet versions = new HashSet();
        poms.forEach(pom -> versions.add(pom.coordinates().version.text()));
        if (versions.size() > 1) {
            if (this.tolerateVersionInconsistenciesIn().contains(fam)) {
                fam.probableFamilyVersion(poms).ifPresent(ver -> {
                    versions.clear();
                    versions.add(ver.text());
                });
            } else {
                throw new MojoExecutionException("Not all projects in family '" + fam + "' have the same version: " + versions);
            }
        }
        return versions.isEmpty() ? null : (String)versions.iterator().next();
    }
}

