/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.function.throwing.ThrowingConsumer;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.commit.CommitMessage;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.SharedProjectTreeMojo;
import com.telenav.cactus.maven.shared.SharedDataKey;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.maven.trigger.RunPolicies;
import com.telenav.cactus.util.SectionedMessage;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="commit-assets")
@Mojo(defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.KEEP_ALIVE, name="commit-assets", threadSafe=true)
public class CommitAssetsMojo
extends SharedProjectTreeMojo {
    @Parameter(property="cactus.push", defaultValue="false")
    boolean push;
    @Parameter(property="cactus.gc", defaultValue="true")
    boolean gc;
    static SharedDataKey<Boolean> DONE = SharedDataKey.of("CommitAssetsMojo", Boolean.class);

    public CommitAssetsMojo() {
        super(RunPolicies.EVERY);
    }

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        Optional<Boolean> opt = this.sharedData().get(DONE);
        if (opt.isPresent() && opt.get().booleanValue()) {
            return;
        }
        this.withProjectTree((ThrowingConsumer<ProjectTree>)((ThrowingConsumer)tree -> {
            this.sharedData().put(DONE, true);
            Set<GitCheckout> assetsCheckouts = tree.nonMavenCheckouts();
            CommitMessage msg = new CommitMessage(CommitAssetsMojo.class, "Update assets");
            HashSet<GitCheckout> toReallyCommit = new HashSet<GitCheckout>();
            try (SectionedMessage.MessageSection sect = msg.section("Assets Repositories");){
                for (GitCheckout co : assetsCheckouts) {
                    boolean dirty = tree.isDirty(co) || co.hasUntrackedFiles();
                    if (!dirty) continue;
                    toReallyCommit.add(co);
                    log.info("Have dirty assets checkout " + co.loggingName());
                    sect.bulletPoint(co.loggingName());
                }
            }
            if (!toReallyCommit.isEmpty()) {
                String cm = msg.toString();
                for (GitCheckout co : toReallyCommit) {
                    log.info("Commit " + co.loggingName());
                    this.ifNotPretending(() -> {
                        co.addAll();
                        co.commit(cm);
                    });
                    if (this.gc) {
                        log.info("git gc --aggresive to improve push performance");
                        this.ifNotPretending(() -> ((GitCheckout)co).gc());
                    }
                    if (this.push) {
                        log.info("Push " + co.loggingName());
                        this.ifNotPretending(() -> ((GitCheckout)co).push());
                    }
                    this.ifNotPretending(tree::invalidateCache);
                }
            }
        }));
    }
}

