/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.git.Branches;
import com.telenav.cactus.git.Conflicts;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.git.NeedPushResult;
import com.telenav.cactus.maven.AutomergeTagMojo;
import com.telenav.cactus.maven.PrintMessageMojo;
import com.telenav.cactus.maven.commit.CommitMessage;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.ScopedCheckoutsMojo;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.maven.trigger.RunPolicies;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="commit")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="commit", threadSafe=true)
public class CommitMojo
extends ScopedCheckoutsMojo {
    @Parameter(property="cactus.commit-message", required=true)
    private String commitMessage;
    @Parameter(property="cactus.commit.skip.add", defaultValue="false")
    private boolean skipAdd;
    @Parameter(property="cactus.push", defaultValue="false")
    private boolean push;
    @Parameter(property="cactus.skip-conflicts", defaultValue="false")
    private boolean skipConflicts;
    @Parameter(property="cactus.stable-branch", defaultValue="stable")
    private String stableBranch;
    @Parameter(property="cactus.create-automerge-tag", defaultValue="false")
    private boolean createAutomergeTag;

    public CommitMojo() {
        super(RunPolicies.INITIAL);
    }

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        if (checkouts.isEmpty()) {
            log.warn("No matched checkouts contain local modifications.");
            return;
        }
        GitCheckout root = tree.root();
        if (this.isIncludeRoot() && !checkouts.contains(root)) {
            checkouts.add(root);
        }
        for (GitCheckout checkout : checkouts) {
            if (!checkout.isDetachedHead()) continue;
            this.fail("Checkout is in detached-head state but has local changes. Switch to a branch before committing or you risk losing track of your commits.");
        }
        boolean rootIsReallySubmoduleRoot = root.isSubmoduleRoot();
        HashSet<GitCheckout> needingPull = new HashSet<GitCheckout>();
        this.examineCheckoutsForConflicts(checkouts, log, needingPull, true, (GitCheckout)(rootIsReallySubmoduleRoot ? root : null));
        this.performPulls(needingPull, log);
        CommitMessage msg = new CommitMessage(CommitMojo.class, this.commitMessage);
        LinkedHashSet<GitCheckout> toCommit = new LinkedHashSet<GitCheckout>();
        StringBuilder nameList = this.nameList(checkouts, toCommit);
        if (toCommit.isEmpty()) {
            log.warn("Nothing to commit among " + nameList);
            return;
        }
        this.addCommitMessageDetail(msg, toCommit);
        if (this.isVerbose()) {
            log.info("Begin commit with message '" + this.commitMessage + "'");
        }
        for (GitCheckout gitCheckout : toCommit) {
            log.info("add/commit " + gitCheckout.loggingName());
            if (this.isPretend()) continue;
            if (!this.skipAdd) {
                gitCheckout.addAll();
            }
            gitCheckout.commit(msg.toString());
            this.emitMessage("Committed " + gitCheckout.loggingName());
        }
        Set<Object> tagged = Collections.emptySet();
        if (this.createAutomergeTag) {
            tagged = AutomergeTagMojo.automergeTag(null, this.stableBranch, tree, log, this.isPretend(), toCommit, false, () -> this.automergeTag());
        }
        if (this.push) {
            this.examineCheckoutsForConflicts(toCommit, log, needingPull, false, (GitCheckout)(rootIsReallySubmoduleRoot ? root : null));
            this.performPulls(needingPull, log);
            for (GitCheckout co : toCommit) {
                NeedPushResult needPushResult = co.needsPush();
                switch (needPushResult) {
                    case YES: {
                        log.info("Push: " + co.loggingName());
                        this.ifNotPretending(() -> ((GitCheckout)co).push());
                        this.emitMessage("Pushed " + co.loggingName());
                        break;
                    }
                    case REMOTE_BRANCH_DOES_NOT_EXIST: {
                        log.info("Push creating branch: " + co.loggingName());
                        this.ifNotPretending(() -> ((GitCheckout)co).pushCreatingBranch());
                        this.emitMessage("Pushed " + co.loggingName() + " creating remote branch " + (String)co.branch().get());
                        break;
                    }
                }
            }
            String string = this.automergeTag().toString();
            for (GitCheckout gitCheckout : tagged) {
                if (root.equals((Object)gitCheckout) && !this.isIncludeRoot()) continue;
                log.info("Push tag " + string);
                this.ifNotPretending(() -> co.pushTag(tag));
            }
        }
    }

    private StringBuilder nameList(List<GitCheckout> checkouts, Set<GitCheckout> toCommit) {
        StringBuilder nameList = new StringBuilder();
        for (GitCheckout co : checkouts) {
            if (co.hasUncommitedChanges()) {
                toCommit.add(co);
            }
            if (nameList.length() > 0) {
                nameList.append(", ");
            }
            nameList.append(co.loggingName());
        }
        return nameList;
    }

    public void performPulls(Set<GitCheckout> needingPull, BuildLog log1) {
        for (GitCheckout co : needingPull) {
            if (this.safeToPullWithRebase(co)) {
                log1.info("Pull with rebase: " + co.loggingName());
                this.ifNotPretending(() -> ((GitCheckout)co).pullWithRebase());
                continue;
            }
            log1.info("Pull " + co.loggingName());
            this.ifNotPretending(() -> ((GitCheckout)co).pull());
        }
        needingPull.clear();
    }

    private boolean safeToPullWithRebase(GitCheckout co) {
        String head = co.head();
        Branches containingCommit = co.branchesContainingCommit(head);
        return containingCommit.remoteBranches().isEmpty();
    }

    private Map<GitCheckout, Conflicts> checkForConflicts(Collection<? extends GitCheckout> checkouts, boolean useWorkingTree) {
        TreeMap<GitCheckout, Conflicts> result = new TreeMap<GitCheckout, Conflicts>();
        for (GitCheckout gitCheckout : checkouts) {
            Conflicts cf = useWorkingTree ? gitCheckout.canMergeWorkingTree() : gitCheckout.checkForConflicts();
            result.put(gitCheckout, cf);
        }
        return result;
    }

    public void examineCheckoutsForConflicts(Collection<GitCheckout> checkouts, BuildLog log1, Set<GitCheckout> needingPull, boolean useWorkingTree, GitCheckout rootCheckoutOrNull) {
        TreeMap<GitCheckout, Conflicts> conflicts = new TreeMap<GitCheckout, Conflicts>();
        if (this.push) {
            LinkedHashSet<GitCheckout> notUpToDate = new LinkedHashSet<GitCheckout>();
            for (GitCheckout checkout2 : checkouts) {
                log1.info("Fetch all in " + checkout2);
                this.ifNotPretending(() -> ((GitCheckout)checkout2).fetchAll());
                if (!checkout2.needsPull()) continue;
                log1.info("Needs pull - will check for conflicts: " + checkout2.loggingName());
                if (checkout2.equals((Object)rootCheckoutOrNull)) continue;
                notUpToDate.add(checkout2);
            }
            Map<GitCheckout, Conflicts> cfs = this.checkForConflicts(notUpToDate, useWorkingTree);
            cfs.forEach((checkout, cflict) -> {
                if (cflict.hasHardConflicts()) {
                    conflicts.put((GitCheckout)checkout, cflict.filterHard());
                } else {
                    needingPull.add((GitCheckout)checkout);
                    for (Conflicts.Conflict flict : cflict) {
                        log1.info("Will need to pull remote changes for " + checkout.loggingName() + " to resolve\n" + flict);
                    }
                }
            });
        }
        if (!conflicts.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            conflicts.forEach((checkout, flicts) -> sb.append('\n').append(checkout.loggingName()).append('\n').append(flicts));
            if (this.skipConflicts) {
                sb.insert(0, "Skipping " + conflicts.size() + " checkouts due to remote conflicts.");
                Set toRemove = conflicts.keySet();
                checkouts.removeAll(toRemove);
                needingPull.removeAll(toRemove);
                PrintMessageMojo.publishMessage(sb, this.session(), false);
            } else {
                sb.insert(0, "Cannot proceed with push - remote has conflicting changes in " + conflicts.size() + " checkouts. \nRe-run with -D.cactus.push=false (or unset) to generate a commit, and then manually pull and resolve conflicts.");
                this.fail(sb.toString());
            }
        }
    }
}

