/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.function.optional.ThrowingOptional;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.trigger.RunPolicies;
import com.telenav.cactus.maven.trigger.RunPolicy;
import com.telenav.cactus.scope.ProjectFamily;
import com.telenav.cactus.util.PathUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="copy-javadoc")
@Mojo(defaultPhase=LifecyclePhase.POST_SITE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.PER_LOOKUP, name="copy-javadoc", threadSafe=true)
public class CopyJavadocMojo
extends BaseMojo {
    private static final String PROP_DO_NOT_DEPLOY = "do.not.publish";
    private static final String PROP_JAVADOC_SKIP = "maven.javadoc.skip";
    @Parameter(property="cactus.javadoc-relative-path", defaultValue="target/site/apidocs")
    private final String javadocRelativePath = "target/site/apidocs";
    @Parameter(property="cactus.delete-existing", defaultValue="false")
    private boolean deleteExisting;
    @Parameter(property="cactus.javadoc-skip", defaultValue="false")
    private boolean javadocSkip;
    @Parameter(property="cactus.do-not-deploy", defaultValue="false")
    private boolean doNotDeploy;
    @Parameter(property="cactus.copy.javadoc.skip")
    private boolean skip;

    public CopyJavadocMojo(RunPolicy policy) {
        super(policy);
    }

    public CopyJavadocMojo() {
    }

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        if (this.skip) {
            log.info("Copy javadoc is skipped");
            return;
        }
        if ("true".equals(project.getProperties().get(PROP_JAVADOC_SKIP))) {
            log.info("Copy javadoc is skipped via maven.javadoc.skip");
            return;
        }
        if (this.isSkipped(project)) {
            log.info("do.not.deploy or javadoc.skip set on " + project + " - skipping.");
            return;
        }
        Path javadocPath = project.getBasedir().toPath().resolve("target/site/apidocs");
        boolean isPom = "pom".equals(project.getPackaging());
        if (!isPom) {
            javadocPath = javadocPath.resolve("src");
        }
        boolean javadocExists = Files.exists(javadocPath, new LinkOption[0]);
        if (isPom && !javadocExists && !RunPolicies.LAST.shouldRun(this, project)) {
            log.info("No javadoc, but " + project.getArtifactId() + " is an intermediate pom project. Skipping");
            return;
        }
        if (!javadocExists) {
            log.warn("No javadoc to copy for " + project.getArtifactId());
            return;
        }
        this.copyJavadoc(javadocPath, project, log);
    }

    @Override
    protected void validateParameters(BuildLog log, MavenProject project) throws Exception {
        Path path = Paths.get("target/site/apidocs", new String[0]);
        if (path.isAbsolute()) {
            this.fail("Javadoc relative path cannot be an absolute path: " + path);
        }
    }

    private void copyJavadoc(Path javadocOrigin, MavenProject project, BuildLog log) {
        ProjectFamily family = ProjectFamily.fromGroupId((String)project.getGroupId());
        ThrowingOptional.from((Optional)GitCheckout.checkout((File)project.getBasedir())).flatMapThrowing(checkout -> family.assetsPath(checkout.submoduleRoot().map(GitCheckout::checkoutRoot)).map(assetsPath -> this.deriveJavadocDestination((Path)assetsPath, project, (GitCheckout)checkout))).ifPresentOrElse(dest -> {
            int deleted;
            if (dest.equals(javadocOrigin) || dest.startsWith(javadocOrigin) || javadocOrigin.startsWith((Path)dest)) {
                this.fail("Will not copy javadoc recursively into itself: " + javadocOrigin + " vs " + dest);
            }
            if (this.deleteExisting && !this.isPretend() && (deleted = PathUtils.deleteFolderTree((Path)dest)) > 0) {
                log.info("Deleted " + deleted + " files in " + dest);
            }
            log.warn("Copying javadoc for " + project + " in family " + family + " into " + dest + " from " + javadocOrigin);
            if (!this.isPretend()) {
                int[] filesAndDirs = PathUtils.copyFolderTree((BuildLog)log, (Path)javadocOrigin, (Path)dest);
                log.info("Copied " + filesAndDirs[0] + " files and created " + filesAndDirs[1] + " folders under " + dest);
            }
        }, () -> log.warn("Could not find git checkout or assets path to move javadoc for " + project));
    }

    private Path deriveJavadocDestination(Path assetsPath, MavenProject project, GitCheckout checkout) {
        if (checkout.name().isEmpty()) {
            throw new IllegalArgumentException("Attempt to copy javadoc for the root project.");
        }
        if ("pom".equals(project.getPackaging())) {
            return assetsPath.resolve("docs").resolve(project.getVersion()).resolve("javadoc").resolve(checkout.name());
        }
        return assetsPath.resolve("docs").resolve(project.getVersion()).resolve("javadoc").resolve(checkout.name()).resolve(project.getArtifactId());
    }

    private boolean isSkipped(MavenProject project) {
        boolean result;
        if (this.javadocSkip || this.doNotDeploy) {
            return true;
        }
        Properties props = project.getProperties();
        String propValue = props.getProperty(PROP_DO_NOT_DEPLOY, props.getProperty(PROP_JAVADOC_SKIP, "false")).trim();
        boolean bl = result = "true".equals(propValue) || "yes".equals(propValue) || "on".equals(propValue);
        if (!result) {
            result = GitCheckout.checkout((File)project.getBasedir()).map(GitCheckout::isSubmoduleRoot).orElse(false);
        }
        return result;
    }
}

