/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.function.throwing.ThrowingSupplier;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.model.MavenArtifactCoordinates;
import com.telenav.cactus.maven.model.published.PublishChecker;
import com.telenav.cactus.maven.model.published.PublishedState;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.shared.SharedDataKey;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="filter-published")
@Mojo(defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.KEEP_ALIVE, name="filter-published", threadSafe=true)
public class FilterDeployingAlreadyPublishedMojo
extends BaseMojo {
    private static final SharedDataKey<Map<MavenArtifactCoordinates, PublishedState>> CACHE_KEY = SharedDataKey.of("published", Map.class);
    private static final PublishChecker CHECKER = new PublishChecker();
    @Parameter(property="cactus.properties")
    private String properties;
    @Parameter(property="cactus.filter.pom.projects.only")
    private boolean pomProjectsOnly;

    private PublishedState publishedStateOf(MavenProject project) {
        return (PublishedState)FilterDeployingAlreadyPublishedMojo.quietly(() -> {
            Map cache = this.sharedData().computeIfAbsent(CACHE_KEY, ConcurrentHashMap::new);
            ThrowingSupplier ts = () -> CHECKER.check((MavenArtifactCoordinates)this.toPom(project));
            return cache.computeIfAbsent(this.coordinatesOf(project), key -> (PublishedState)ts.asSupplier().get());
        });
    }

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        if (this.pomProjectsOnly && !"pom".equals(project.getPackaging())) {
            return;
        }
        PublishedState state = this.publishedStateOf(project);
        switch (state) {
            case NOT_PUBLISHED: {
                break;
            }
            case PUBLISHED_IDENTICAL: {
                this.applyProperties(project, log);
                break;
            }
            case PUBLISHED_DIFFERENT: {
                this.fail("You are attempting to re-publish " + this.coordinatesOf(project) + ". Its pom.xml locally differs from that already published.  You need to bump its version and any usages of it before it can be published.");
            }
        }
    }

    private void applyProperties(MavenProject project, BuildLog log) {
        Properties props = project.getProperties();
        Set<String> apply = this.propertiesToApply();
        if (this.isVerbose()) {
            log.info("Set the following properties to 'true' for " + this.coordinatesOf(project) + ": " + String.join((CharSequence)", ", apply));
        }
        for (String prop : apply) {
            props.setProperty(prop, "true");
        }
    }

    private Set<String> propertiesToApply() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("maven.deploy.skip");
        result.add("gpg.skip");
        result.add("skipNexusStagingDeployMojo");
        result.add("do.not.publish");
        if (this.properties != null) {
            for (String prop : this.properties.split("[, ]")) {
                if ((prop = prop.trim()).isEmpty()) continue;
                result.add(prop);
            }
        }
        return result;
    }
}

