/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.FamilyAwareMojo;
import com.telenav.cactus.scope.ProjectFamily;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="filter-families")
@Mojo(defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.PER_LOOKUP, name="filter-families", threadSafe=true)
public class FilterFamiliesMojo
extends FamilyAwareMojo {
    @Parameter(property="cactus.properties", required=true)
    private String properties;
    @Parameter(property="cactus.filter.skip.superpoms", defaultValue="true")
    private boolean skipSuperpoms;
    @Parameter(property="cactus.families.required", defaultValue="false")
    private boolean familiesRequired;

    @Override
    protected void validateParameters(BuildLog log, MavenProject project) throws Exception {
        if (this.familiesRequired && !this.hasExplicitFamilies()) {
            this.fail("cactus.families.required is set. -Dcactus.families or -Dcactus.family must be set");
        }
    }

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        if (this.properties == null || this.properties.isBlank() || !this.hasExplicitFamilies()) {
            return;
        }
        Set<ProjectFamily> families = this.families();
        if (families.isEmpty()) {
            return;
        }
        List projectsToSetPropertiesFor = new HashSet(this.session().getAllProjects()).stream().filter(x -> {
            if (this.skipSuperpoms && "pom".equals(x.getPackaging()) && x.getModules().isEmpty()) {
                return false;
            }
            ProjectFamily fam = ProjectFamily.fromGroupId((String)x.getGroupId());
            return !families.contains(fam);
        }).collect(Collectors.toCollection(ArrayList::new));
        this.propertiesToApply().forEach(prop -> {
            for (MavenProject prj : projectsToSetPropertiesFor) {
                prj.getProperties().setProperty((String)prop, "true");
                boolean changed = FilterFamiliesMojo.logicalCombineProperties(prop, true, prj.getProperties(), false);
                if (!changed || !this.isVerbose()) continue;
                log.info("Inject " + prop + "=true into " + prj.getArtifactId() + " for " + this.families());
            }
        });
    }

    private Set<String> propertiesToApply() {
        TreeSet<String> result = new TreeSet<String>();
        for (String prop : this.properties.split("[, ]")) {
            if ((prop = prop.trim()).isEmpty()) continue;
            result.add(prop);
        }
        return result;
    }

    private static boolean logicalCombineProperties(String prop, boolean defaultValue, Properties props, boolean or) {
        String val = props.getProperty(prop);
        if (val == null) {
            props.put(prop, Boolean.toString(defaultValue));
            return true;
        }
        boolean eval = Boolean.parseBoolean(val);
        boolean newValue = or ? eval || defaultValue : eval && defaultValue;
        props.put(prop, Boolean.toString(newValue));
        return newValue != eval;
    }
}

