/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.git.Branches;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.ScopedCheckoutsMojo;
import com.telenav.cactus.maven.shared.SharedData;
import com.telenav.cactus.maven.shared.SharedDataKey;
import com.telenav.cactus.maven.tree.ProjectTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="attempt-merge")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.KEEP_ALIVE, name="attempt-merge", threadSafe=true)
public class ForkBuildMojo
extends ScopedCheckoutsMojo {
    static final SharedDataKey<String> TEMP_BRANCH_KEY = SharedDataKey.of("tempBranch", String.class);
    static final SharedDataKey<GitCheckout[]> BRANCHED_REPOS_KEY = SharedDataKey.of(GitCheckout[].class);
    static final SharedDataKey<String> TARGET_BRANCH_KEY = SharedDataKey.of("mergeTo", String.class);
    @Inject
    SharedData sharedData;
    @Parameter(property="cactus.stable-branch", defaultValue="develop")
    private String stableBranch;
    @Parameter(property="cactus.merge-branch", required=true)
    private String mergeBranch;
    @Parameter(property="cactus.push", defaultValue="false")
    private boolean push;
    @Parameter(property="cactus.ignore-no-stable-branch", defaultValue="true")
    private boolean ignoreNoStableBranch;
    @Parameter(property="cactus.fetch-first", defaultValue="false")
    private boolean fetchFirst;
    private String tempBranch;

    public ForkBuildMojo() {
        super(true);
        new Exception("Create fork build mojo").printStackTrace(System.out);
    }

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        if (this.fetchFirst) {
            this.fetchAll(checkouts, log.child("fetch"));
        }
        LinkedHashMap branchesToCreateFrom = new LinkedHashMap();
        LinkedHashMap branchesToMerge = new LinkedHashMap();
        for (GitCheckout gitCheckout : checkouts) {
            Branches branches = tree.branches(gitCheckout);
            branches.find(this.stableBranch, false).ifPresent(br -> branchesToCreateFrom.put(checkout, br));
            branches.find(this.mergeBranch, true).ifPresentOrElse(br -> branchesToMerge.put(checkout, br), () -> branches.find(this.mergeBranch, false).ifPresent(remoteBranch -> branchesToMerge.put(checkout, remoteBranch)));
        }
        if (!this.ignoreNoStableBranch && !branchesToCreateFrom.keySet().equals(new HashSet<GitCheckout>(checkouts))) {
            HashSet<GitCheckout> absent = new HashSet<GitCheckout>(checkouts);
            absent.removeAll(branchesToCreateFrom.keySet());
            this.fail("Not all checkouts have a stable branch named '" + this.stableBranch + "': " + (Set)absent);
        }
        if (branchesToMerge.isEmpty()) {
            this.fail("Did not find any branches named '" + this.mergeBranch + "' in " + checkouts);
        }
        this.ifVerbose(() -> {
            log.warn("Workflow for " + this.scope() + ":");
            branchesToCreateFrom.forEach((co, br) -> {
                Branches.Branch merge = (Branches.Branch)branchesToMerge.get(co);
                if (merge != null) {
                    log.warn(co.name() + ":\tcreate " + this.tempBranch + " merging " + this.mergeBranch + " into " + this.stableBranch);
                }
            });
        });
        for (Map.Entry entry : branchesToCreateFrom.entrySet()) {
            Branches.Branch base = (Branches.Branch)entry.getValue();
            GitCheckout checkout = (GitCheckout)entry.getKey();
            log.info("Create and switch to " + this.tempBranch + " in " + checkout.name());
            boolean success = checkout.createAndSwitchToBranch(this.tempBranch, Optional.of(base.trackingName()), this.isPretend());
            if (success) continue;
            this.fail("Failed to create and switch to " + this.tempBranch + " using " + base);
        }
        ArrayList<GitCheckout> successfullyMerged = new ArrayList<GitCheckout>();
        for (Map.Entry e : branchesToMerge.entrySet()) {
            Branches.Branch target = (Branches.Branch)e.getValue();
            GitCheckout checkout = (GitCheckout)e.getKey();
            log.info("Merge " + target + " into " + this.tempBranch + " for " + checkout.name());
            if (this.isPretend()) continue;
            if (checkout.merge(target.trackingName())) {
                successfullyMerged.add(checkout);
                continue;
            }
            log.warn("Failed to merge " + target + " into " + this.tempBranch);
        }
        this.sharedData.put(BRANCHED_REPOS_KEY, (GitCheckout[])successfullyMerged.toArray(GitCheckout[]::new));
    }

    @Override
    protected void onValidateParameters(BuildLog log, MavenProject project) throws Exception {
        this.validateBranchName(this.mergeBranch, false);
        this.validateBranchName(this.stableBranch, false);
        this.tempBranch = this.mergeBranch + "_" + this.stableBranch + "_" + Long.toString(System.currentTimeMillis(), 36) + "_" + Long.toString(ThreadLocalRandom.current().nextLong(), 36);
        this.sharedData.put(TEMP_BRANCH_KEY, this.tempBranch);
        this.sharedData.put(TARGET_BRANCH_KEY, this.stableBranch);
        log.info("Temporary branch name " + this.tempBranch);
    }

    private void fetchAll(List<GitCheckout> checkouts, BuildLog log) {
        for (GitCheckout checkout : checkouts) {
            log.info("Fetch all in " + checkout.loggingName());
            if (this.isPretend()) continue;
            checkout.fetchAll();
        }
    }
}

