/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.util.strings.AlignedText;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.trigger.RunPolicies;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="lexakai-generate")
@Mojo(defaultPhase=LifecyclePhase.PRE_SITE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="lexakai-generate", threadSafe=true)
public final class GenerateLexakaiProjectPropertiesMojo
extends BaseMojo {
    private static final String HEAD = "#\n# Lexakai Project Configuration\n#\n# See https://lexakai.org for details\n#\n\n#\n# Project\n#\n";
    @Parameter(property="cactus.overwrite", defaultValue="false")
    private boolean overwrite;
    @Parameter(property="cactus.cleanup", defaultValue="false")
    private boolean cleanup;
    @Parameter(property="cactus.generate.lexakai.skip", defaultValue="false")
    private boolean skip;

    public GenerateLexakaiProjectPropertiesMojo() {
        super(RunPolicies.LAST);
    }

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        if (this.skip) {
            log.info("Cactus lexakai properties generation is skipped.");
            return;
        }
        if (!"pom".equals(project.getPackaging())) {
            log.info("Skip lexakai project properties generation for non-pom project");
            return;
        }
        Path dir = project.getBasedir().toPath();
        Path docsDir = dir.resolve("documentation").resolve("lexakai").resolve("projects");
        if (!Files.exists(docsDir, new LinkOption[0])) {
            this.fail("No lexakai config dir at " + docsDir);
        }
        Map<Pom, Path> maybeGenerate = this.findDocsFilesForModules(project, docsDir);
        for (Map.Entry<Pom, Path> e : maybeGenerate.entrySet()) {
            if (!this.overwrite && Files.exists(e.getValue(), new LinkOption[0])) continue;
            String text = this.generateLexakaiInfoStub(e.getKey());
            log.info("Write " + e.getValue());
            if (this.isVerbose()) {
                log.info(text);
            }
            if (this.isPretend()) continue;
            Files.write(e.getValue(), text.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        if (this.cleanup) {
            Set toDelete = Files.list(docsDir).filter(file -> !Files.isDirectory(file, new LinkOption[0]) && file.getFileName().toString().endsWith(".properties")).collect(Collectors.toCollection(HashSet::new));
            toDelete.removeAll(maybeGenerate.values());
            for (Path del : toDelete) {
                log.info("Delete obsolete " + del);
                if (this.isPretend()) continue;
                Files.delete(del);
            }
        }
    }

    private String generateLexakaiInfoStub(Pom pom) {
        StringBuilder sb = new StringBuilder(HEAD);
        sb.append("project-title").append("\t=\t").append(pom.name()).append("\n");
        sb.append("project-description").append("\t=\t").append(GenerateLexakaiProjectPropertiesMojo.formatDescription(pom.description())).append("\n");
        sb.append("project-icon\t=\ticons/diagram-32\n");
        return AlignedText.formatTabbed((CharSequence)sb.toString());
    }

    private static String formatDescription(String desc) {
        String[] parts = desc.split("\n");
        if (parts.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (String part : parts) {
                if ((part = part.trim()).isEmpty()) continue;
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(part);
            }
            return sb.toString();
        }
        return desc;
    }

    private Map<Pom, Path> findDocsFilesForModules(MavenProject prj, Path docsDir) {
        HashMap<Pom, Path> result = new HashMap<Pom, Path>();
        Pom.from((Path)prj.getFile().toPath()).ifPresent(pom -> result.put((Pom)pom, docsDir.resolve(prj.getArtifactId() + ".properties")));
        for (String m : prj.getModules()) {
            Path pomFile = prj.getBasedir().toPath().resolve(m).resolve("pom.xml");
            if (!Files.exists(pomFile, new LinkOption[0])) continue;
            Pom.from((Path)pomFile).ifPresent(pom -> {
                Path docFile = docsDir.resolve(pom.artifactId() + ".properties");
                result.put((Pom)pom, docFile);
            });
        }
        return result;
    }
}

