/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.function.throwing.io.IOSupplier;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.github.MinimalPRItem;
import com.telenav.cactus.maven.AbstractGithubMojo;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.maven.trigger.RunPolicies;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="git-approve-pull-request")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="git-approve-pull-request", threadSafe=true)
public class GitHubApprovePullRequestMojo
extends AbstractGithubMojo {
    @Parameter(property="cactus.pr.body")
    private String body;
    @Parameter(property="cactus.pr.branch-to-approve")
    private String branchToApprove;

    public GitHubApprovePullRequestMojo() {
        super(RunPolicies.LAST);
    }

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        if (checkouts.isEmpty()) {
            log.info("No checkouts matched.");
            return;
        }
        Map<GitCheckout, MinimalPRItem> pullRequests = this.findInitialPullRequest(log, this.branchToApprove, myCheckout, checkouts);
        if (pullRequests.isEmpty()) {
            this.fail("No approve-able pull requests found with the head branch '" + this.branchToApprove + "'");
        }
        this.collectPullRequestsToApprove(log, this.branchToApprove, checkouts, pullRequests);
        String logPrefix = this.isPretend() ? "(pretend) " : "";
        log.info("Have " + pullRequests.size() + " pull requests to approve");
        pullRequests.forEach((checkout, pullRequest) -> {
            log.info(logPrefix + "Approve pull request " + pullRequest.number + " for " + checkout.loggingName() + " on branch " + this.branchToApprove + " to " + pullRequest.baseRefName + ": '" + pullRequest.title + "'");
            if (!this.isPretend()) {
                checkout.approvePullRequest((IOSupplier)this, pullRequest.headRefName, Optional.of(this.body));
            }
        });
    }

    @Override
    protected void onValidateGithubParameters(BuildLog log, MavenProject project) {
        this.validateBranchName(this.branchToApprove, true);
    }

    private void collectPullRequestsToApprove(BuildLog log, String branchName, List<GitCheckout> checkouts, Map<? super GitCheckout, ? super MinimalPRItem> into) {
        for (GitCheckout checkout : checkouts) {
            if (into.containsKey(checkout)) continue;
            this.leadPullRequestForBranch(branchName, checkout).ifPresent(item -> into.put((GitCheckout)checkout, (MinimalPRItem)item));
        }
    }

    private Map<GitCheckout, MinimalPRItem> findInitialPullRequest(BuildLog log, String branchName, GitCheckout myCheckout, List<GitCheckout> checkouts) {
        Optional<MinimalPRItem> item = this.leadPullRequestForBranch(branchName, myCheckout);
        if (item.isEmpty()) {
            for (GitCheckout test : checkouts) {
                if (test.equals((Object)myCheckout) || !(item = this.leadPullRequestForBranch(branchName, test)).isPresent()) continue;
                LinkedHashMap<GitCheckout, MinimalPRItem> result = new LinkedHashMap<GitCheckout, MinimalPRItem>(1);
                result.put(test, item.get());
                return result;
            }
        }
        return Collections.emptyMap();
    }

    private Optional<MinimalPRItem> leadPullRequestForBranch(String branchName, GitCheckout forCheckout) {
        return this.leadPullRequestForBranch(null, branchName, forCheckout);
    }
}

