/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.function.throwing.io.IOSupplier;
import com.telenav.cactus.git.Branches;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.github.MergePullRequestOptions;
import com.telenav.cactus.github.MinimalPRItem;
import com.telenav.cactus.maven.AbstractGithubMojo;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.maven.trigger.RunPolicies;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="git-merge-pull-request")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="git-merge-pull-request", threadSafe=true)
public class GitHubMergePullRequestMojo
extends AbstractGithubMojo {
    @Parameter(property="cactus.target-branch")
    private String targetBranch;
    @Parameter(property="cactus.pr.auto", defaultValue="false")
    private boolean auto;
    @Parameter(property="cactus.pr.delete-branch", defaultValue="false")
    private boolean deleteBranch;
    @Parameter(property="cactus.pr.merge", defaultValue="true")
    private boolean merge;
    @Parameter(property="cactus.pr.squash", defaultValue="false")
    private boolean squash;
    @Parameter(property="cactus.pr.rebase", defaultValue="false")
    private boolean rebase;
    @Parameter(property="cactus.pr.admin", defaultValue="false")
    private boolean admin;
    @Parameter(property="cactus.base-branch", defaultValue="develop")
    private final String baseBranch = "develop";

    public GitHubMergePullRequestMojo() {
        super(RunPolicies.LAST);
    }

    @Override
    protected void onValidateGithubParameters(BuildLog log, MavenProject project) {
        this.validateBranchName(this.targetBranch, true);
        this.validateBranchName("develop", false);
        Set<MergePullRequestOptions> opts = this.options();
        EnumSet<MergePullRequestOptions> cannotBeCombined = EnumSet.of(MergePullRequestOptions.MERGE, MergePullRequestOptions.SQUASH, MergePullRequestOptions.REBASE);
        cannotBeCombined.retainAll(opts);
        if (cannotBeCombined.size() > 1) {
            this.fail("Only one of MERGE, REBASE and SQUASH may be set to true, but have the options " + opts);
        }
    }

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        Map<GitCheckout, MinimalPRItem> prForCheckout;
        if (checkouts.isEmpty()) {
            log.info("No checkouts matched.");
            return;
        }
        String branch = this.targetBranch(myCheckout, tree);
        if (branch.equals("develop")) {
            this.fail("The target branch and the base branch are both '" + branch + "'.  There will not be any PRs from a branch to itself.");
        }
        if ((prForCheckout = this.findInitialPR(log, branch, myCheckout, checkouts)).isEmpty()) {
            this.fail("No open and merge-able PRs found with the head branch '" + branch + "'");
        }
        this.collectPrsToMerge(log, branch, checkouts, prForCheckout);
        Set<MergePullRequestOptions> options = this.options();
        String logPrefix = this.isPretend() ? "(pretend) " : "";
        log.info("Have " + prForCheckout.size() + " PRs to merge");
        prForCheckout.forEach((checkout, pr) -> {
            log.info(logPrefix + "Merge PR " + pr.number + " for " + checkout.loggingName() + " on branch " + branch + " to " + pr.baseRefName + ": '" + pr.title + "'");
            if (!this.isPretend()) {
                checkout.mergePullRequest((IOSupplier)this, pr.headRefName, options);
            }
        });
    }

    private void collectPrsToMerge(BuildLog log, String branchName, List<GitCheckout> checkouts, Map<? super GitCheckout, ? super MinimalPRItem> into) {
        for (GitCheckout co : checkouts) {
            if (into.containsKey(co)) continue;
            this.leadPullRequestForBranch(branchName, co).ifPresent(item -> into.put((GitCheckout)co, (MinimalPRItem)item));
        }
    }

    private Map<GitCheckout, MinimalPRItem> findInitialPR(BuildLog log, String branchName, GitCheckout myCheckout, List<GitCheckout> checkouts) {
        if (this.targetBranch == null) {
            LinkedHashMap<GitCheckout, MinimalPRItem> result = new LinkedHashMap<GitCheckout, MinimalPRItem>(1);
            this.leadPullRequestForBranch(branchName, myCheckout).ifPresent(pr -> result.put(myCheckout, (MinimalPRItem)pr));
            return result;
        }
        Optional<MinimalPRItem> item = this.leadPullRequestForBranch(branchName, myCheckout);
        if (item.isEmpty()) {
            for (GitCheckout test : checkouts) {
                if (test.equals((Object)myCheckout) || !(item = this.leadPullRequestForBranch(branchName, test)).isPresent()) continue;
                LinkedHashMap<GitCheckout, MinimalPRItem> result = new LinkedHashMap<GitCheckout, MinimalPRItem>(1);
                result.put(test, item.get());
                return result;
            }
        }
        return Collections.emptyMap();
    }

    private String targetBranch(GitCheckout myCheckout, ProjectTree tree) throws MojoFailureException {
        if (this.targetBranch != null && !this.targetBranch.isBlank()) {
            return this.targetBranch;
        }
        Branches myBranches = tree.branches(myCheckout);
        return ((Branches.Branch)myBranches.currentBranch().orElseThrow(() -> new MojoFailureException(myCheckout.loggingName() + " is not on a branch - pass cactus.target-branch or check out a branch and retry."))).name();
    }

    private Optional<MinimalPRItem> leadPullRequestForBranch(String branchName, GitCheckout forCheckout) {
        return this.leadPullRequestForBranch("develop", branchName, forCheckout);
    }

    List<MinimalPRItem> pullRequestsForBranch(String branchName, GitCheckout forCheckout) {
        return this.pullRequestsForBranch("develop", branchName, forCheckout);
    }

    List<MinimalPRItem> openAndMergeablePullRequestsForBranch(String branchName, GitCheckout forCheckout) {
        return this.openAndMergeablePullRequestsForBranch("develop", branchName, forCheckout);
    }

    private Set<MergePullRequestOptions> options() {
        EnumSet<MergePullRequestOptions> result = EnumSet.noneOf(MergePullRequestOptions.class);
        boolean[] items = new boolean[]{this.auto, this.deleteBranch, this.merge, this.squash, this.rebase, this.admin};
        MergePullRequestOptions[] all = MergePullRequestOptions.values();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i]) continue;
            result.add(all[i]);
        }
        return result;
    }
}

