/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.function.throwing.io.IOSupplier;
import com.mastfrog.util.strings.RandomStrings;
import com.mastfrog.util.strings.Strings;
import com.telenav.cactus.git.Branches;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.git.NeedPushResult;
import com.telenav.cactus.github.MinimalPRItem;
import com.telenav.cactus.maven.AbstractGithubMojo;
import com.telenav.cactus.maven.ClassloaderLog;
import com.telenav.cactus.maven.commit.CommitMessage;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.tasks.TaskSet;
import com.telenav.cactus.util.SectionedMessage;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="git-pull-request")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresOnline=true, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="git-pull-request", threadSafe=true)
public class GitHubPullCreateRequestMojo
extends AbstractGithubMojo {
    @Parameter(property="cactus.title")
    private String title;
    @Parameter(property="cactus.body")
    private String body;
    @Parameter(property="cactus.reviewers")
    private String reviewers;
    @Parameter(property="cactus.commit-changes", defaultValue="true")
    private boolean commit;
    @Parameter(property="cactus.base-branch", defaultValue="develop")
    String baseBranch;
    @Parameter(property="cactus.target-branch")
    String targetBranch;
    @Parameter(property="cactus.open", defaultValue="true")
    boolean open;
    private String searchNonce;
    private final Set<GitCheckout> fetched = ConcurrentHashMap.newKeySet();
    private final Set<String> uris = ConcurrentHashMap.newKeySet();
    private volatile boolean titleLogged;
    private volatile boolean bodyLogged;

    @Override
    protected void onValidateGithubParameters(BuildLog log, MavenProject project) throws Exception {
        ClassloaderLog._log(project, this);
        if (Objects.equals(this.baseBranch, this.targetBranch)) {
            this.fail("Base branch and target branch are the same: " + this.targetBranch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        Map<GitCheckout, Branches.Branch> sourceBranchForCheckout;
        if (checkouts.isEmpty()) {
            log.info("No checkouts matched.");
            return;
        }
        if (this.targetBranch == null) {
            tree.branches(myCheckout).currentBranch().ifPresent(br -> {
                if (br.name().equals(this.baseBranch)) {
                    this.fail("Attempting to create a pull request targeting the branch " + this.baseBranch + ", but " + this.coordinatesOf(project) + "'s checkout is already on that branch.  Either switch to the branch you want to create a pull request from, or run this mojo against a project in the right project family which is in a checkout that is on the branch you want to create the pull request from.");
                }
            });
        }
        if ((sourceBranchForCheckout = this.filterToCheckoutsOnTargetBranch(log, myCheckout, tree, checkouts)).isEmpty()) {
            log.error("Nothing to do.");
            return;
        }
        try {
            BuildLog pretendLog = this.isPretend() ? log.child("(pretend)") : log;
            this.createPullRequests(pretendLog, project, myCheckout, tree, sourceBranchForCheckout);
        }
        finally {
            tree.invalidateCache();
            this.clearPRCache();
            this.fetched.clear();
            GitHubPullCreateRequestMojo gitHubPullCreateRequestMojo = this;
            synchronized (gitHubPullCreateRequestMojo) {
                this.searchNonce = null;
            }
            this.uris.clear();
        }
    }

    protected void createPullRequests(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, Map<GitCheckout, Branches.Branch> sourceBranchForCheckout) throws Exception {
        TaskSet tasks = TaskSet.newTaskSet((Consumer)log);
        Set<GitCheckout> alreadyHavePRs = this.checkoutsWithExistingPrs(sourceBranchForCheckout, log);
        if (alreadyHavePRs.equals(sourceBranchForCheckout.keySet())) {
            log.warn("Every checkout matched already has an open, merge-able PR.  Nothing to do.");
            return;
        }
        alreadyHavePRs.forEach(sourceBranchForCheckout::remove);
        log.info("Pruned " + alreadyHavePRs);
        tasks.group("Ensure base branch '" + this.baseBranch + "' exists in all targets", grp -> sourceBranchForCheckout.forEach((co, branch) -> grp.add("Ensure '" + this.baseBranch + "' exists in " + co.loggingName(), () -> {
            log.info("Fetch all in " + co.loggingName());
            this.ensureUpToDateRemoteHeads((GitCheckout)co, tree);
            Branches br = tree.branches((GitCheckout)co);
            if (br.find(this.baseBranch, false).isEmpty()) {
                this.fail("No branch named '" + this.baseBranch + "' in default remote of " + co.loggingName());
            }
        })));
        LinkedHashSet<GitCheckout> toPush = new LinkedHashSet<GitCheckout>();
        HashSet<GitCheckout> dirtyCheckouts = new HashSet<GitCheckout>();
        this.collectDirtyCheckoutsAndCreateCommitTasks(sourceBranchForCheckout, toPush, dirtyCheckouts, tasks);
        if (!this.commit && dirtyCheckouts.isEmpty()) {
            this.fail("Commit is false and no repositories have  local modifications.  Running `gh pr create` in such a situation will trigger interactive questions and cannot be automated: " + dirtyCheckouts);
        }
        tasks.group("Push Changes", pushTasks -> {
            HashSet needingBranchCreation = new HashSet();
            sourceBranchForCheckout.forEach((checkout, branch) -> {
                if (!toPush.contains(checkout) && this.containsPullRequestReadyCommitsPendingPush(myCheckout, (GitCheckout)checkout, (Branches.Branch)branch)) {
                    toPush.add((GitCheckout)checkout);
                } else {
                    this.ensureUpToDateRemoteHeads((GitCheckout)checkout, tree);
                    Branches branches = tree.branches((GitCheckout)checkout);
                    if (branches.find(branch.name(), false).isEmpty()) {
                        toPush.add((GitCheckout)checkout);
                        needingBranchCreation.add(checkout);
                    } else {
                        NeedPushResult np = checkout.needsPush();
                        if (np.canBePushed()) {
                            toPush.add((GitCheckout)checkout);
                            if (np.needCreateBranch()) {
                                needingBranchCreation.add(checkout);
                            }
                        }
                    }
                }
            });
            for (GitCheckout checkout2 : toPush) {
                if (needingBranchCreation.contains(checkout2)) {
                    pushTasks.add("Push " + checkout2.loggingName() + " creating remote branch " + sourceBranchForCheckout.get(checkout2), () -> this.ifNotPretending(() -> ((GitCheckout)checkout2).pushCreatingBranch()));
                    continue;
                }
                pushTasks.add("Push branch " + sourceBranchForCheckout.get(checkout2) + " of " + checkout2.loggingName(), () -> this.ifNotPretending(() -> {
                    checkout2.push();
                    tree.invalidateBranches(checkout2);
                }));
            }
        });
        HashSet pruned = new HashSet();
        tasks.group("Prune checkouts with no head difference", grp -> sourceBranchForCheckout.forEach((checkout, sourceBranch) -> grp.add("Check branch difference in " + checkout.loggingName(), () -> {
            String head = checkout.headOf(sourceBranch.name());
            Branches branches = tree.branches((GitCheckout)checkout);
            branches.find(this.baseBranch, false).ifPresent(branch -> {
                String remoteHead = checkout.headOf(branch.trackingName());
                if (remoteHead != null && (remoteHead.equals(head) || checkout.isAncestor(head, remoteHead))) {
                    log.info("Will skip " + checkout.loggingName() + " -  the local head " + head + " is or is an ancestor of  the remote head " + remoteHead);
                    pruned.add(checkout);
                }
            });
        })));
        tasks.group("Create pull requests", prTasks -> {
            prTasks.add("Check all pruned", () -> {
                if (pruned.equals(sourceBranchForCheckout.keySet())) {
                    String msg = "All checkouts were pruned because their heads match or  are ancestors of the remote head: " + Strings.join((char)',', (Iterable)pruned, GitCheckout::loggingName);
                    System.out.println("All checkouts were pruned because their heads");
                    log.warn(msg);
                }
            });
            sourceBranchForCheckout.forEach((checkout, sourceBranch) -> {
                if (pruned.contains(checkout)) {
                    log.info("Not generating PR for " + checkout.loggingName() + " because it has no new commits.");
                    return;
                }
                String logMsg = "Create pull request for " + checkout.loggingName() + " from " + sourceBranch.name() + " to " + this.baseBranch;
                prTasks.add(logMsg, () -> {
                    URI uri;
                    if (!this.isPretend() && (uri = checkout.createPullRequest((IOSupplier)this, this.reviewers, this.titleOrSyntheticTitle(sourceBranchForCheckout), this.bodyOrSyntheticBody(sourceBranchForCheckout), sourceBranch.name(), this.baseBranch)) != null) {
                        this.uris.add(uri.toURL().toString());
                        log.info("Created " + uri);
                        this.emitMessage(uri);
                        if (this.open) {
                            this.open(uri);
                        }
                    }
                });
            });
        });
        log.warn("Execution Plan:\n" + tasks);
        tasks.execute();
    }

    private void collectDirtyCheckoutsAndCreateCommitTasks(Map<GitCheckout, Branches.Branch> sourceBranchForCheckout, Set<GitCheckout> toPush, Set<GitCheckout> dirtyCheckouts, TaskSet tasks) {
        CommitMessage msg = new CommitMessage(this.getClass(), this.titleOrSyntheticTitle(sourceBranchForCheckout)).paragraph(this.bodyOrSyntheticBody(sourceBranchForCheckout));
        try (SectionedMessage.MessageSection sect = msg.section("Committing In");){
            for (Map.Entry<GitCheckout, Branches.Branch> e : sourceBranchForCheckout.entrySet()) {
                if (!e.getKey().isDirty() && !e.getKey().hasUntrackedFiles()) continue;
                toPush.add(e.getKey());
                dirtyCheckouts.add(e.getKey());
                sect.bulletPoint(e.getKey().loggingName() + " - " + e.getValue().name());
            }
        }
        if (this.commit) {
            tasks.group("Commit any pending changes", grp -> dirtyCheckouts.forEach(checkout -> grp.add("Commit changes in " + checkout.loggingName(), () -> this.ifNotPretending(() -> {
                checkout.addAll();
                checkout.commit(msg.toString());
            }))));
        }
    }

    private Map<GitCheckout, Branches.Branch> filterToCheckoutsOnTargetBranch(BuildLog log, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) {
        LinkedHashMap<GitCheckout, Branches.Branch> result = new LinkedHashMap<GitCheckout, Branches.Branch>(checkouts.size());
        checkouts.forEach(co -> this.prSourceBranchFor(log, myCheckout, (GitCheckout)co, tree).ifPresent(sourceBranch -> result.put((GitCheckout)co, (Branches.Branch)sourceBranch)));
        return result;
    }

    private boolean containsPullRequestReadyCommitsPendingPush(GitCheckout myCheckout, GitCheckout co, Branches.Branch sourceBranchForThisCheckout) {
        if (co.isNotAtSameHeadAsBranch(this.baseBranch)) {
            Branches containingCommit = co.branchesContainingCommit(co.head());
            return containingCommit.find(sourceBranchForThisCheckout.name(), false).isEmpty();
        }
        return false;
    }

    private Optional<Branches.Branch> prSourceBranchFor(BuildLog log, GitCheckout myCheckout, GitCheckout checkout, ProjectTree tree) {
        return this.prBranchFor(log, myCheckout, checkout, tree, this.targetBranch, true);
    }

    private synchronized String searchNonce() {
        return this.searchNonce == null ? (this.searchNonce = new RandomStrings().randomChars(10) + "-" + Long.toString(System.currentTimeMillis() / 1000L, 36)) : this.searchNonce;
    }

    void ensureUpToDateRemoteHeads(GitCheckout co, ProjectTree tree) {
        if (this.fetched.add(co)) {
            this.ifNotPretending(() -> {
                co.fetchAll();
                tree.invalidateBranches(co);
            });
        }
    }

    private Set<GitCheckout> checkoutsWithExistingPrs(Map<GitCheckout, Branches.Branch> in, BuildLog log) {
        HashSet<GitCheckout> result = new HashSet<GitCheckout>(in.size());
        in.forEach((checkout, branch) -> {
            List<MinimalPRItem> existingPrs = this.openPullRequestsForBranch(this.baseBranch, branch.name(), (GitCheckout)checkout);
            if (!existingPrs.isEmpty()) {
                result.add((GitCheckout)checkout);
            }
        });
        return result;
    }

    private String titleOrSyntheticTitle(Map<GitCheckout, Branches.Branch> sourceBranchForCheckout) {
        String result;
        if (this.title == null) {
            assert (!sourceBranchForCheckout.isEmpty());
            GitCheckout co = sourceBranchForCheckout.entrySet().iterator().next().getKey();
            result = this.title = co.commitMessage(sourceBranchForCheckout.get(co).trackingName());
        } else {
            result = this.title;
        }
        if (this.isPretend() && !this.titleLogged) {
            this.titleLogged = true;
            this.emitMessage("TITLE: " + this.title);
        }
        return result;
    }

    private String bodyOrSyntheticBody(Map<GitCheckout, Branches.Branch> sourceBranchForCheckout) {
        SectionedMessage.MessageSection sect;
        CommitMessage msg = new CommitMessage(this.getClass(), this.titleOrSyntheticTitle(sourceBranchForCheckout));
        if (this.body != null) {
            msg.paragraph(this.body);
        }
        if (!this.uris.isEmpty()) {
            sect = msg.section("Related Pull Requests");
            try {
                for (String u : this.uris) {
                    sect.bulletPoint(u);
                }
            }
            finally {
                if (sect != null) {
                    sect.close();
                }
            }
        }
        sect = msg.section("Creating Pull Requests In");
        try {
            sourceBranchForCheckout.forEach((arg_0, arg_1) -> this.lambda$bodyOrSyntheticBody$25((CommitMessage.Section)sect, arg_0, arg_1));
        }
        finally {
            if (sect != null) {
                sect.close();
            }
        }
        sect = msg.section("Metadata");
        try {
            sect.bulletPoint("Invoked on " + this.project().getGroupId() + ":" + this.project().getArtifactId() + ":" + this.project().getVersion());
            sect.bulletPoint("SearchNonce: " + this.searchNonce());
        }
        finally {
            if (sect != null) {
                sect.close();
            }
        }
        if (this.isPretend() && !this.bodyLogged) {
            this.bodyLogged = true;
            this.emitMessage("BODY:\n" + msg);
        }
        return msg.toString();
    }

    private /* synthetic */ void lambda$bodyOrSyntheticBody$25(CommitMessage.Section sect, GitCheckout checkout, Branches.Branch branch) {
        sect.bulletPoint(checkout.loggingName() + " " + branch + " -> " + this.baseBranch);
    }
}

