/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.function.throwing.ThrowingConsumer;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.commit.CommitMessage;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.model.ArtifactIdentifiers;
import com.telenav.cactus.maven.model.ParentMavenCoordinates;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.internal.PomFile;
import com.telenav.cactus.maven.model.resolver.Poms;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.SharedProjectTreeMojo;
import com.telenav.cactus.maven.refactoring.PropertyHomogenizer;
import com.telenav.cactus.maven.topologize.Topologizer;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.maven.trigger.RunPolicies;
import com.telenav.cactus.maven.xml.AbstractXMLUpdater;
import com.telenav.cactus.maven.xml.XMLFile;
import com.telenav.cactus.maven.xml.XMLTextContentReplacement;
import com.telenav.cactus.util.SectionedMessage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@BaseMojoGoal(value="homogenize-versions")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="homogenize-versions", threadSafe=true)
public class HomogenizeVersionsMojo
extends SharedProjectTreeMojo {
    @Parameter(property="cactus.topologically-sort-modules", defaultValue="false")
    private boolean topoSortModules;
    @Parameter(property="cactus.commit-changes", defaultValue="false")
    private boolean commit;

    public HomogenizeVersionsMojo() {
        super(RunPolicies.FIRST);
    }

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        this.withProjectTree((ThrowingConsumer<ProjectTree>)((ThrowingConsumer)tree -> {
            if (this.commit) {
                this.checkDirty((ProjectTree)tree);
            }
            PropertyHomogenizer ph = new PropertyHomogenizer(new Poms(tree.allProjects()));
            if (this.isPretend()) {
                ph.pretend();
            }
            HashSet<Path> updated = new HashSet<Path>(ph.go(arg_0 -> ((BuildLog)log).info(arg_0)));
            this.fixParentVersions((ProjectTree)tree, log, (Set<Path>)updated);
            if (updated.isEmpty()) {
                log.info("No inconsistent properties found.");
            } else {
                log.info("Updated " + updated.size() + " pom files.");
                if (this.commit) {
                    this.commit((ProjectTree)tree, (Set<Path>)updated, log);
                }
            }
            tree.invalidateCache();
        }));
    }

    private void commit(ProjectTree tree, Set<Path> updated, BuildLog log) {
        HashSet modifiedCheckouts = new HashSet();
        for (Path p : updated) {
            GitCheckout.checkout((Path)p).ifPresent(checkout -> {
                boolean dirty;
                boolean bl = dirty = tree.isSubmoduleRoot((GitCheckout)checkout) ? tree.isDirtyIgnoringSubmoduleCommits((GitCheckout)checkout) : tree.isDirty((GitCheckout)checkout);
                if (dirty) {
                    modifiedCheckouts.add(checkout);
                }
            });
        }
        ArrayList traverse = new ArrayList(modifiedCheckouts);
        GitCheckout.depthFirstSort(traverse);
        if (!modifiedCheckouts.isEmpty()) {
            CommitMessage msg = new CommitMessage(((Object)((Object)this)).getClass(), "Updated " + updated.size() + " in homogenize-versions pass.");
            SectionedMessage.MessageSection sect = msg.section("Checkouts");
            traverse.forEach(arg_0 -> HomogenizeVersionsMojo.lambda$commit$2((CommitMessage.Section)sect, arg_0));
            SectionedMessage.MessageSection files = msg.section("Files");
            Path rootPath = tree.root().checkoutRoot();
            updated.forEach(arg_0 -> HomogenizeVersionsMojo.lambda$commit$3((CommitMessage.Section)files, rootPath, arg_0));
            String message = msg.toString();
            if (this.isVerbose()) {
                System.out.println(message);
            }
            for (GitCheckout co : traverse) {
                this.ifNotPretending(() -> {
                    co.addAll();
                    co.commit(message);
                });
                log.info("Committed " + co.loggingName());
                this.emitMessage("Committed " + co.loggingName());
            }
        }
    }

    private void checkDirty(ProjectTree tree) {
        StringBuilder dirtyMessage = new StringBuilder();
        tree.allCheckouts().forEach(checkout -> {
            boolean dirty;
            boolean bl = dirty = tree.isSubmoduleRoot((GitCheckout)checkout) ? tree.isDirtyIgnoringSubmoduleCommits((GitCheckout)checkout) : tree.isDirty((GitCheckout)checkout);
            if (dirty) {
                if (dirtyMessage.length() > 0) {
                    dirtyMessage.append(", ");
                }
                dirtyMessage.append(checkout.loggingName());
            }
        });
        if (dirtyMessage.length() > 0) {
            dirtyMessage.insert(0, "Some checkouts contain modifications. Will not generate a commit if it could include unrelated changes. The following checkouts are dirty: ");
        }
    }

    private void fixParentVersions(ProjectTree tree, BuildLog log, Set<Path> paths) throws Exception {
        HashMap pomForIds = new HashMap();
        HashMap<Pom, ArtifactIdentifiers> parentForPom = new HashMap<Pom, ArtifactIdentifiers>();
        HashMap fullParentForPom = new HashMap();
        tree.allProjects().forEach(pom -> {
            pomForIds.put(pom.toArtifactIdentifiers(), pom);
            pom.parent().ifPresent(par -> {
                ArtifactIdentifiers parentIds = par.toArtifactIdentifiers();
                parentForPom.put((Pom)pom, parentIds);
                fullParentForPom.put(pom, par);
            });
        });
        HashMap newVersionForPom = new HashMap();
        LinkedHashSet<ModuleListReplacer> replacers = new LinkedHashSet<ModuleListReplacer>();
        parentForPom.forEach((pom, parentId) -> {
            Pom parentPom = (Pom)pomForIds.get(parentId);
            ParentMavenCoordinates parent = (ParentMavenCoordinates)fullParentForPom.get(pom);
            if (!parentPom.version().equals((Object)parent.version())) {
                log.info("Inconsistent parent version in " + pom.artifactId() + " should be " + parentPom.version() + " but is " + parent.version());
                newVersionForPom.put(pom, parent.version());
                PomFile file = PomFile.of((Pom)pom);
                XMLTextContentReplacement replacement = new XMLTextContentReplacement((XMLFile)file, "/project/parent/version", parentPom.version().text());
                replacers.add((ModuleListReplacer)replacement);
            }
        });
        if (replacers.isEmpty()) {
            log.info("No parent version updates needed.");
        }
        if (this.topoSortModules) {
            Topologizer topo = new Topologizer(tree.root(), log);
            for (Pom pom2 : topo.poms()) {
                if (!pom2.isAggregator()) continue;
                List<String> sortedModuleNames = topo.topologicallySortedModules(pom2);
                log.info("Will replace module list in " + pom2.artifactId());
                replacers.add(new ModuleListReplacer((XMLFile)PomFile.of((Pom)pom2), sortedModuleNames));
            }
        }
        AbstractXMLUpdater.applyAll(replacers, (boolean)this.isPretend(), x$0 -> this.emitMessage(x$0));
        for (AbstractXMLUpdater abstractXMLUpdater : replacers) {
            paths.add(abstractXMLUpdater.path());
        }
    }

    private static /* synthetic */ void lambda$commit$3(CommitMessage.Section files, Path rootPath, Path path) {
        files.bulletPoint(rootPath.relativize(path));
    }

    private static /* synthetic */ void lambda$commit$2(CommitMessage.Section sect, GitCheckout checkout) {
        sect.bulletPoint(checkout.loggingName());
    }

    private static final class ModuleListReplacer
    extends AbstractXMLUpdater {
        private final List<String> newModuleList;

        ModuleListReplacer(XMLFile in, List<String> newModuleList) {
            super(in);
            this.newModuleList = newModuleList;
        }

        public Document replace() throws Exception {
            return (Document)this.in.inContext(doc -> {
                ThrowingOptional list = this.in.nodesQuery("/project/modules/module");
                if (!list.isPresent()) {
                    return null;
                }
                NodeList nl = (NodeList)list.get();
                for (int i = 0; i < nl.getLength(); ++i) {
                    String newText = this.newModuleList.get(i);
                    Node n = nl.item(i);
                    n.setTextContent(newText);
                }
                return doc;
            });
        }
    }
}

