/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.util.streams.Streams;
import com.mastfrog.util.strings.Strings;
import com.telenav.cactus.maven.PrintMessageMojo;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.trigger.RunPolicies;
import com.telenav.cactus.metadata.BuildMetadata;
import com.telenav.cactus.util.PathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="install-scripts")
@Mojo(defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="install-scripts", threadSafe=true)
public class InstallScriptsMojo
extends BaseMojo {
    private static final String FUNCTION_FRAGMENT_FILE_NAME = "run-maven-function-fragment.txt";
    private static String runMavenFunctionFragment;
    @Parameter(property="cactus.script.destination")
    private String destination;
    @Parameter(property="cactus.create.aliases", defaultValue="true")
    private boolean createAliases = true;

    InstallScriptsMojo() {
        super(RunPolicies.LAST);
    }

    private Path destination() throws MojoExecutionException {
        if (this.destination != null && !this.destination.isBlank()) {
            return Paths.get(this.destination.trim(), new String[0]);
        }
        Path home = PathUtils.home();
        return (Path)PathUtils.ifExists((Path)home.resolve("bin")).or(() -> PathUtils.ifExists((Path)home.resolve("local").resolve("bin"))).orElseThrow(() -> new MojoExecutionException("No ~/bin or ~/.local/bin directory to install into.  Pass -Dcactus.script.destination for a path to some directory you have write access to which is on your path"));
    }

    @Override
    protected void validateParameters(BuildLog log, MavenProject project) throws Exception {
        this.destination();
    }

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        BuildMetadata meta;
        String ver;
        Path dest = this.destination();
        if (!Files.exists(dest, new LinkOption[0])) {
            Files.createDirectories(dest, new FileAttribute[0]);
        }
        if ((ver = (String)(meta = BuildMetadata.buildMetaData(InstallScriptsMojo.class)).projectProperties().get("project-version")) == null) {
            this.fail("No version found in " + meta.projectProperties());
        }
        StringBuilder msg = new StringBuilder();
        PrintMessageMojo.publishMessage(msg, this.session(), false);
        for (Scripts script : Scripts.values()) {
            Path scriptFile = script.install(dest, this.createAliases, ver, log, this.isPretend());
            script.describe(scriptFile, msg, this.createAliases);
        }
        msg.insert(0, "Cactus Scripts Have Been Installed\n==================================\n\n");
    }

    static String runMavenFunctionFragment() throws IOException {
        if (runMavenFunctionFragment != null) {
            return runMavenFunctionFragment;
        }
        runMavenFunctionFragment = Streams.readResourceAsUTF8(InstallScriptsMojo.class, (String)FUNCTION_FRAGMENT_FILE_NAME);
        String result = runMavenFunctionFragment;
        if (result == null) {
            throw new Error("run-maven-function-fragment.txt is not adjacent to " + InstallScriptsMojo.class);
        }
        return result;
    }

    private static enum Scripts {
        COMMIT_ALL_SUBMODULES("ccm"),
        PUSH_ALL_SUBMODULES("cpush"),
        PULL_ALL_SUBMODULES("cpull"),
        DEVELOPMENT_PREPARATION("cdev"),
        CHANGE_BRANCH("cbranch"),
        SIMPLE_BUMP_VERSION("cbump"),
        LAST_CHANGE_BY_PROJECT("cch"),
        FAMILY_VERSIONS("cver"),
        RELEASE_ONE_PROJECT("crel"),
        CREATE_PULL_REQUEST("cpr"),
        LIST_PULL_REQUESTS("clpr"),
        UPDATE_SCRIPTS("cactus-script-update");

        private final String filename;

        private Scripts(String filename) {
            this.filename = filename;
        }

        public String toString() {
            return Strings.capitalize((CharSequence)this.name().toLowerCase().replace('_', ' ')) + " (" + this.filename + ")";
        }

        boolean usesLoggingWrapper() {
            switch (this) {
                case COMMIT_ALL_SUBMODULES: 
                case CREATE_PULL_REQUEST: 
                case RELEASE_ONE_PROJECT: 
                case FAMILY_VERSIONS: {
                    return false;
                }
            }
            return true;
        }

        private String description() {
            switch (this) {
                case COMMIT_ALL_SUBMODULES: {
                    return "\\tCommit all changes in all git submodules in one\n\\tshot, with one commit message.\n\n\\tIf `-p` or `--push` is the first argument, also push any committed checkouts\n\\t(creating a new remote branch if there is no corresponding one).";
                }
                case PUSH_ALL_SUBMODULES: {
                    return "\\tPush all changes in all submodules in one shot, after\n\\tensuring that your local checkouts are all up-to-date.";
                }
                case PULL_ALL_SUBMODULES: {
                    return "\\tPull changes in all submodules";
                }
                case DEVELOPMENT_PREPARATION: {
                    return "\\tSwitch to the 'develop' branch in all java project checkouts.";
                }
                case LIST_PULL_REQUESTS: {
                    return "\\tList pull requests.  Pass `-m` as the first argument to omit non-mergeable\\n\\tpull requests.\\n\\n\\tIf a branch name is passed as the first (or second, with `-m`), use that branch name instead\\n\\tof the branch the current project is on.";
                }
                case CHANGE_BRANCH: {
                    return "\\tThe multi-repository branching swiss-army-knife.\\n\\n\\tChange branches or create a new branch across a matched set of repositories.  To simply check out an existing feature branch\\n\\tin all projects that have it, run `cbranch feature/some-branch`.\\n\\n\\tTo *create* a new branch, run `cbranch --new feature/some-branch`. (`-n` or `--new` will work).\\n\\t\\n\\tIf a local branch with the requested name exists for one checkout, that checkout \\n\\twill simply be switched to it.  If a remote branch with the requeted name exists for a checkout,\\n\\tbut a local one does not, a local tracking branch will be created and switched to for that checkout.\\n\\tIf no local or remote branch exists for a checkout, the default development branch\\n\\t(develop) will be switched to.\\n\\n\\tBy default, the scope of checkouts affected will be the project family of whatever pom.xml you are running\\n\\tagainst, and any child project families of it (if run in the root of a checkout, that may be everything).\\n\\n\\tPass `--all` or `-a` to apply to *every* project family in your tree.\\n\\n\\tIf not passing `--new`, any checkouts that do not have the named branch will be\\n\\tswitched to the default development branch.\\n\\n\\tBy default, branching will abort if there are local changes.  You can pass `-p`\\n\\tor `--permissive` to attempt to create branches ignoring local changes.  Note that this can\\n\\tand *does* fail if the current branch is not the base branch, and creating a new branch from\\n\\t the base would mean clobbering your changes.  In that case, commit or stash your changes and retry.";
                }
                case UPDATE_SCRIPTS: {
                    return "\\tFinds the latest version of cactus you have installed, and runs\n\\tits install-scripts target to update/refresh the scripts\n\\tyou are installing right now.";
                }
                case SIMPLE_BUMP_VERSION: {
                    return "\\tBump the version of the Maven project family it is invoked against,\\n\\tupdating superpom properties with the new version but NOT UPDATING\n\\tTHE VERSIONS OF THOSE SUPERPOMS.\n\n\\tThis is suitable for the simple case of updating the version\n\\tof one thing during active development, not for doing a full\n\\tproduct release.";
                }
                case RELEASE_ONE_PROJECT: {
                    return "\\tRelease a single project - whatever pom you run it against - to ossrh or wherever it is configured to send it.";
                }
                case LAST_CHANGE_BY_PROJECT: {
                    return "\\tPrints git commit info about the last change that altered a java \n\\tsource file in a project, or with --all, the entire tree.";
                }
                case FAMILY_VERSIONS: {
                    return "\\tPrints the inferred version of each project family in the current\n\\tproject tree.  These versions are what will be the basis used by \n\\tBumpVersionMojo when computing a new revision.";
                }
                case CREATE_PULL_REQUEST: {
                    return "\\tCreate a pull request.  Any arguments that are passed will be combined\n\\tto create the title for the pull request.\\n\\n\\tTypically this is run against a project which is on a feature branch; the\n\\ttool will scan for other git submodules on a same-named branch, committing or pushing\n\\tas needed, and create pull requests for each if none already exists.";
                }
            }
            throw new AssertionError((Object)this);
        }

        String longName() {
            return "cactus-" + this.name().toLowerCase().replace('_', '-');
        }

        public void describe(Path path, StringBuilder into, boolean aliased) {
            if (into.length() > 0) {
                into.append("\n\n\n");
            }
            String info = this.toString();
            into.append(info).append('\n');
            char[] cc = new char[info.length() + 2];
            Arrays.fill(cc, '-');
            cc[cc.length - 1] = 10;
            cc[cc.length - 2] = 10;
            into.append(cc);
            into.append("\\t").append(path).append('\n');
            if (aliased) {
                into.append("\\t").append(path.getParent().resolve(this.filename)).append('\n');
            }
            into.append("\n");
            into.append(this.description());
        }

        private InputStream script() {
            InputStream result = InstallScriptsMojo.class.getResourceAsStream(this.filename);
            if (result == null) {
                throw new IllegalStateException("No file named " + this.filename + " on classpath adjacent to " + InstallScriptsMojo.class.getName());
            }
            return result;
        }

        private String insertHelpStanza(String script, String pluginVersion) throws IOException {
            String desc = this.description();
            if (desc != null && !desc.isEmpty()) {
                StringBuilder sb = new StringBuilder("\n\nif [ -n \"$1\" ]; then\n").append("    if [ '--help' = $1 ]; then\n");
                desc = desc.replaceAll("\\\\n", "\n").replaceAll("\\\\t", "\t").replaceAll("\"", "\\\"");
                sb.append("        echo '").append(this.longName()).append(" ").append(pluginVersion).append("' 1>&2\n");
                sb.append("        echo 1>&2\n");
                for (String line : desc.split("\n")) {
                    sb.append("        echo '").append(line).append("' 1>&2\n");
                }
                sb.append("         exit 0");
                sb.append("\n    fi");
                sb.append("\nfi\n");
                StringBuilder txt = new StringBuilder(script);
                int ix = script.indexOf(10);
                if (this.usesLoggingWrapper()) {
                    sb.append(InstallScriptsMojo.runMavenFunctionFragment());
                }
                txt.insert(ix + 1, sb);
                return txt.toString();
            }
            if (this.usesLoggingWrapper()) {
                StringBuilder sb = new StringBuilder(script);
                int ix = script.indexOf(10);
                sb.insert(ix + 1, InstallScriptsMojo.runMavenFunctionFragment());
                return sb.toString();
            }
            return script;
        }

        private Path install(Path toDir, boolean createAliases, String pluginVersion, BuildLog log, boolean pretend) throws IOException {
            try (InputStream in = this.script();){
                String body = new String(in.readAllBytes(), StandardCharsets.US_ASCII).replaceAll("__PLUGIN_VERSION_PLACEHOLDER__", pluginVersion);
                body = this.insertHelpStanza(body, pluginVersion);
                Path script = toDir.resolve(this.longName());
                Path shorthand = toDir.resolve("./" + this.filename);
                if (!pretend) {
                    Files.write(script, body.getBytes(StandardCharsets.US_ASCII), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                    Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwxr--r--");
                    Files.setPosixFilePermissions(script, perms);
                }
                String head = pretend ? "(pretend) Copied " : "Copied ";
                log.info(this + ": " + head + this.toString() + " to " + script);
                log.debug(body);
                if (createAliases && this != UPDATE_SCRIPTS) {
                    if (Files.exists(shorthand, LinkOption.NOFOLLOW_LINKS)) {
                        Files.delete(shorthand);
                    }
                    Files.createSymbolicLink(shorthand, script, new FileAttribute[0]);
                }
                Path path = script;
                return path;
            }
        }
    }
}

