/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.ScopedCheckoutsMojo;
import com.telenav.cactus.maven.tree.ProjectTree;
import java.util.List;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="is-dirty")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="is-dirty", threadSafe=true)
public class IsDirtyMojo
extends ScopedCheckoutsMojo {
    public IsDirtyMojo() {
        super(true);
    }

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        boolean dirty = false;
        for (GitCheckout checkout : checkouts) {
            if (!checkout.isDirty()) continue;
            if (!dirty) {
                this.emitMessage("Dirty projects:");
            }
            dirty = true;
            this.emitMessage(" * " + checkout.loggingName());
        }
        if (!dirty) {
            log.info("\nClean\n\n");
        }
    }
}

