/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.util.streams.stdio.ThreadMappedStdIO;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.MavenArtifactCoordinatesWrapper;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.model.DiskResident;
import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenArtifactCoordinates;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.maven.trigger.RunPolicies;
import com.telenav.cactus.scope.ProjectFamily;
import com.telenav.cactus.util.PathUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="lexakai")
@Mojo(defaultPhase=LifecyclePhase.SITE, requiresDependencyResolution=ResolutionScope.COMPILE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="lexakai", threadSafe=true)
public class LexakaiMojo
extends BaseMojo {
    private static final Pattern XML_COMMENT = Pattern.compile("<!--.*?-->", 40);
    private static final String SKIP_PROPERTY = "cactus.lexakai.skip";
    private static final String JAVADOC_SKIP_PROPERTY = "maven.javadoc.skip";
    private static final String DO_NOT_PUBLISH_PROPERTY = "do.not.publish";
    @Parameter(property="cactus.overwrite-resources", defaultValue="true")
    private boolean overwriteResources;
    @Parameter(property="cactus.update-readme", defaultValue="true")
    private boolean updateReadme;
    @Parameter(property="cactus.lexakai.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="cactus.output-folder")
    private String outputFolder;
    @Parameter(property="cactus.commit-changes", defaultValue="false")
    private boolean commitChanges;
    @Parameter(property="cactus.lexakai-version", defaultValue="1.0.13")
    private String lexakaiVersion = "1.0.13";
    @Parameter(property="cactus.flatten", defaultValue="false")
    private boolean flatten;
    @Parameter(property="cactus.no-minimize", defaultValue="false")
    private boolean noMinimize;
    @Parameter(property="cactus.show-lexakai-output", defaultValue="true")
    private boolean showLexakaiOutput;
    @Parameter(property="cactus.lexakai.also-skip")
    private String alsoSkip;

    public LexakaiMojo() {
        super(RunPolicies.FAMILY_ROOTS);
    }

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        Path outputDir = this.output(MavenArtifactCoordinatesWrapper.wrap(project));
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("-update-readme=" + this.updateReadme, "-overwrite-resources=" + this.overwriteResources, "-output-folder=" + outputDir));
        this.skippedProjects(project.getBasedir().toPath()).ifPresent(skips -> args.add("-exclude-projects=" + skips));
        args.add(project.getBasedir().toString());
        this.ifVerbose(() -> {
            log.info("Lexakai args:");
            log.info("lexakai " + args);
        });
        if (!this.skip) {
            this.ifNotPretending(() -> this.runLexakai(args, project, log));
        }
    }

    private static boolean anyTrueIn(Properties projectProperties, String ... propertyNames) {
        for (String prop : propertyNames) {
            if (!"true".equals(projectProperties.get(prop))) continue;
            return true;
        }
        return false;
    }

    <A extends MavenArtifactCoordinates & DiskResident> Path output(A project) {
        return GitCheckout.checkout((Path)((DiskResident)project).path()).map(co -> this.outputFolder(project, (GitCheckout)co)).orElseGet(() -> ((DiskResident)project).path().resolve("target").resolve("lexakai"));
    }

    <A extends MavenArtifactCoordinates & DiskResident> Path outputFolder(A project, GitCheckout checkout) {
        if (this.outputFolder != null) {
            this.appendProjectLexakaiDocPath(Paths.get(this.outputFolder, new String[0]), project, checkout);
        }
        return (Path)ProjectFamily.familyOf((GroupId)project.groupId()).assetsPath(checkout.submoduleRoot().map(GitCheckout::checkoutRoot)).map(assetsPath -> this.appendProjectLexakaiDocPath((Path)assetsPath, project, checkout)).orElseGet(() -> this.appendProjectLexakaiDocPath(((DiskResident)project).path().resolve("target").resolve("lexakai"), project, checkout));
    }

    private <A extends MavenArtifactCoordinates & DiskResident> Path appendProjectLexakaiDocPath(Path path, A prj, GitCheckout checkout) {
        if (checkout.name().isEmpty()) {
            throw new IllegalArgumentException("Cannot use the root project " + checkout + " for a lexakai path for " + prj);
        }
        Path result = path.resolve("docs").resolve(prj.version().text()).resolve("lexakai").resolve(checkout.name());
        if (!this.flatten) {
            Path relPath = (Path)checkout.submoduleRelativePath().get();
            for (int i = 0; i < relPath.getNameCount() - 1; ++i) {
                result = result.resolve(relPath.getName(i));
            }
        }
        return result;
    }

    private Set<GitCheckout> collectModifiedCheckouts(ProjectTree tree) {
        tree.invalidateCache();
        HashSet<GitCheckout> needingCommit = new HashSet<GitCheckout>();
        if (tree.isDirty(tree.root())) {
            needingCommit.add(tree.root());
        }
        for (GitCheckout gc : tree.nonMavenCheckouts()) {
            if (!gc.isDirty()) continue;
            needingCommit.add(gc);
        }
        for (GitCheckout gc : tree.allCheckouts()) {
            if (!gc.isDirty()) continue;
            needingCommit.add(gc);
        }
        return needingCommit;
    }

    private Set<String> collectSkippedProjects(BuildLog log, Path rootProjectDir, Consumer<MavenProject> skippedConsumer) {
        TreeSet<String> result = new TreeSet<String>();
        this.session().getAllProjects().forEach(childProject -> {
            if (LexakaiMojo.anyTrueIn(childProject.getProperties(), SKIP_PROPERTY, JAVADOC_SKIP_PROPERTY, DO_NOT_PUBLISH_PROPERTY)) {
                skippedConsumer.accept((MavenProject)childProject);
                if (this.isVerbose()) {
                    log.warn(childProject.getArtifactId() + " marks itself as skipped for lexakai");
                }
            }
        });
        if (this.alsoSkip != null) {
            for (String skipped : this.alsoSkip.split(",")) {
                if ((skipped = skipped.trim()).isEmpty()) continue;
                result.add(skipped);
            }
        }
        return result;
    }

    private Set<GitCheckout> collectedChangedRepos(MavenProject project, ThrowingRunnable toRun) {
        return (Set)ProjectTree.from(project).map(tree -> {
            Set<GitCheckout> needingCommitBefore = this.collectModifiedCheckouts((ProjectTree)tree);
            toRun.run();
            Set<GitCheckout> needingCommitAfter = this.collectModifiedCheckouts((ProjectTree)tree);
            needingCommitAfter.removeAll(needingCommitBefore);
            return needingCommitAfter;
        }).orElseGet(() -> {
            toRun.run();
            return Collections.emptySet();
        });
    }

    private String commitMessage(MavenProject prj, Set<GitCheckout> checkouts) {
        StringBuilder sb = new StringBuilder("Generated commit ").append(prj.getGroupId()).append(":").append(prj.getArtifactId()).append(":").append(prj.getVersion()).append("\n\n");
        String user = System.getProperty("user.name");
        Path home = PathUtils.home();
        String host = System.getenv("HOST");
        sb.append("User:\t").append(user);
        sb.append("\nHome:\t").append(home);
        sb.append("\nHost:\t").append(host);
        sb.append("\nWhen:\t").append(Instant.now());
        sb.append("\n\n").append("Modified checkouts:\n");
        for (GitCheckout ch : checkouts) {
            sb.append("\n  * ").append(ch.name()).append(" (").append(ch.checkoutRoot()).append(")");
        }
        return sb.append("\n").toString();
    }

    private Path lexakaiJar() throws Exception {
        return this.downloadArtifact("com.telenav.lexakai", "lexakai-standalone", this.lexakaiVersion).get();
    }

    private ThrowingRunnable lexakaiRunner(List<String> arguments) throws Exception {
        LexakaiRunner result = new LexakaiRunner(this.lexakaiJar(), arguments);
        if (!this.showLexakaiOutput) {
            return () -> ThreadMappedStdIO.blackhole((ThrowingRunnable)result);
        }
        return result;
    }

    private void minimizeSVG(Path folderOrFile) throws IOException {
        if (this.noMinimize) {
            return;
        }
        if (Files.isDirectory(folderOrFile, new LinkOption[0])) {
            try (Stream<Path> str = Files.walk(folderOrFile, 512, new FileVisitOption[0]).filter(pth -> !Files.isDirectory(pth, new LinkOption[0]) && pth.getFileName().toString().endsWith(".svg"));){
                str.forEach(path -> LexakaiMojo.quietly(() -> this.minimizeSVG((Path)path)));
            }
        } else if (Files.exists(folderOrFile, new LinkOption[0])) {
            String text = Files.readString(folderOrFile);
            String revised = XML_COMMENT.matcher(text).replaceAll("") + "\n";
            Files.write(folderOrFile, revised.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }

    private void runLexakai(List<String> args, MavenProject project, BuildLog log1) throws Exception {
        ThrowingRunnable runner = this.lexakaiRunner(args);
        if (this.commitChanges) {
            Set<GitCheckout> modified = this.collectedChangedRepos(project, runner);
            if (!modified.isEmpty()) {
                String msg = this.commitMessage(project, modified);
                for (GitCheckout ch : GitCheckout.depthFirstSort(modified)) {
                    if (!ch.addAll()) {
                        log1.error("Add all failed in " + ch);
                        continue;
                    }
                    if (ch.commit(msg)) continue;
                    log1.error("Commit failed in " + ch);
                }
                GitCheckout.checkout((File)project.getBasedir()).flatMap(prjCheckout -> prjCheckout.submoduleRoot().toOptional()).ifPresent(root -> {
                    if (root.isDirty()) {
                        if (!root.addAll()) {
                            log1.error("Add all failed in " + root);
                        }
                        if (!root.commit(msg)) {
                            log1.error("Commit failed in " + root);
                        }
                    }
                });
            }
        } else {
            runner.run();
        }
    }

    private Optional<String> skippedProjects(Path familyParentBasedir) {
        StringBuilder sb = new StringBuilder();
        this.collectSkippedProjects(this.log().child("collectSkipped"), familyParentBasedir, prj -> {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(prj.getGroupId()).append(":").append(prj.getArtifactId());
        });
        return sb.length() == 0 ? Optional.empty() : Optional.of(sb.toString());
    }

    static {
        try {
            Class<?> clazz = LexakaiMojo.class.getClassLoader().loadClass("com.telenav.cactus.maven.MavenArtifactCoordinatesWrapper");
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace(System.out);
        }
    }

    class LexakaiRunner
    implements ThrowingRunnable {
        private final Path jarFile;
        private final List<String> args;
        private final BuildLog runLog = BuildLog.get().child("lexakai-runner");

        LexakaiRunner(Path jarFile, List<String> args) {
            this.jarFile = jarFile;
            this.args = args;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws Exception {
            ClassLoader ldr = Thread.currentThread().getContextClassLoader();
            try {
                URL[] url = new URL[]{new URL("jar:" + this.jarFile.toUri().toURL() + "!/")};
                this.runLog.warn("Invoke lexakai reflectively from " + url[0]);
                try (URLClassLoader jarLoader = new URLClassLoader("lexakai", url, ldr);){
                    Thread.currentThread().setContextClassLoader(jarLoader);
                    System.setProperty("KIVAKIT_LOG_SYNCHRONOUS", "true");
                    System.setProperty("KIVAKIT_LOG", "Console formatter=unformatted");
                    Class<?> what = jarLoader.loadClass("com.telenav.lexakai.Lexakai");
                    Method mth = what.getMethod("embeddedMain", String[].class);
                    this.runLog.info("Invoking lexakai " + mth + " on " + what.getName());
                    String problems = (String)mth.invoke(null, new Object[]{this.args.toArray(String[]::new)});
                    if (problems != null) {
                        this.runLog.error(problems);
                        LexakaiMojo.this.fail("Lexakai encountered problems:\n" + problems);
                    }
                    this.runLog.info("Lexakai done.");
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(ldr);
                Path dir = LexakaiMojo.this.output(MavenArtifactCoordinatesWrapper.wrap(LexakaiMojo.this.project()));
                if (Files.exists(dir, new LinkOption[0]) && Files.list(dir).findAny().isEmpty()) {
                    Files.delete(dir);
                } else {
                    LexakaiMojo.this.minimizeSVG(dir);
                }
            }
        }
    }
}

