/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.function.throwing.ThrowingTriConsumer;
import com.telenav.cactus.git.Branches;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.ScopedCheckoutsMojo;
import com.telenav.cactus.maven.tree.ProjectTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="merge")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="merge", threadSafe=true)
public class MergeBranchMojo
extends ScopedCheckoutsMojo {
    @Parameter(property="cactus.merge.from")
    String mergeFrom;
    @Parameter(property="cactus.merge.into", defaultValue="develop")
    String mergeInto;
    @Parameter(property="cactus.also.merge.into")
    String alsoMergeInto;
    @Parameter(property="cactus.delete.merged.branch", defaultValue="false")
    boolean deleteMergedBranch;
    @Parameter(property="cactus.tag", defaultValue="true")
    boolean tag;
    @Parameter(property="cactus.push", defaultValue="false")
    boolean push;

    @Override
    protected void onValidateParameters(BuildLog log, MavenProject project) throws Exception {
        this.validateBranchName(this.mergeFrom, true);
        this.validateBranchName(this.mergeInto, false);
        this.validateBranchName(this.alsoMergeInto, true);
        switch (this.scope()) {
            case FAMILY: {
                break;
            }
            default: {
                if (!this.families().isEmpty()) break;
                this.fail("Cannot use cactus.families exception cactus.scope=family");
            }
        }
    }

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        this.withBranches(tree, checkouts, (ThrowingTriConsumer<Map<GitCheckout, Branches.Branch>, Map<GitCheckout, Branches.Branch>, Map<GitCheckout, Branches.Branch>>)((ThrowingTriConsumer)(toMergeFrom, toMergeTo, alsoMergeTo) -> {
            if (toMergeFrom.isEmpty() || toMergeTo.isEmpty()) {
                log.warn("No checkouts found to merge");
                return;
            }
            log.info("Have " + toMergeFrom.size() + " checkouts to merge.");
            HashSet checkoutsToMerge = new HashSet(toMergeTo.keySet());
            checkoutsToMerge.retainAll(toMergeFrom.keySet());
            for (GitCheckout checkout : checkoutsToMerge) {
                Branches.Branch from = (Branches.Branch)toMergeFrom.get(checkout);
                Branches.Branch to = (Branches.Branch)toMergeTo.get(checkout);
                Branches.Branch also = (Branches.Branch)alsoMergeTo.get(checkout);
                if (also != null) {
                    log.info("First merge " + from + " into " + also + " in " + checkout.loggingName());
                    this.ifNotPretending(() -> {
                        if (also.isRemote()) {
                            log.info("Branch " + also.trackingName() + " does not exist locally.  Creating it.");
                            checkout.createAndSwitchToBranch(also.name(), Optional.of(also.trackingName()));
                        } else {
                            checkout.switchToBranch(also.name());
                        }
                        checkout.merge(from.name());
                    });
                    if (this.push) {
                        log.info("Push " + checkout.loggingName());
                        this.ifNotPretending(() -> ((GitCheckout)checkout).push());
                    }
                }
                log.info("Merge " + from + " into " + to + " in " + checkout.loggingName());
                this.ifNotPretending(() -> {
                    checkout.switchToBranch(to.name());
                    checkout.merge(from.name());
                });
                if (this.tag) {
                    String newTag = this.tagName(from);
                    log.info("Tag " + checkout.loggingName() + " with " + newTag);
                    this.ifNotPretending(() -> checkout.tag(newTag, true));
                }
                if (this.deleteMergedBranch) {
                    log.info("Delete branch " + from + " in " + checkout.loggingName());
                    this.ifNotPretending(() -> checkout.deleteBranch(from.name(), to.name(), false));
                }
                if (!this.push) continue;
                boolean remoteBranchExists = tree.branches(checkout).find(to.name(), false).isPresent();
                if (remoteBranchExists) {
                    checkout.push();
                    continue;
                }
                checkout.pushCreatingBranch();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withBranches(ProjectTree tree, List<GitCheckout> checkouts, ThrowingTriConsumer<Map<GitCheckout, Branches.Branch>, Map<GitCheckout, Branches.Branch>, Map<GitCheckout, Branches.Branch>> c) throws Exception {
        if (this.isIncludeRoot() && !checkouts.contains(tree.root())) {
            checkouts = new ArrayList<GitCheckout>(checkouts);
            checkouts.add(tree.root());
        }
        try {
            LinkedHashMap<GitCheckout, Branches.Branch> toMergeFrom = new LinkedHashMap<GitCheckout, Branches.Branch>();
            LinkedHashMap toMergeTo = new LinkedHashMap();
            LinkedHashMap additionalDestinations = new LinkedHashMap();
            for (GitCheckout checkout : checkouts) {
                Branches branches = tree.branches(checkout);
                Optional branchToMergeFrom = this.mergeFrom != null ? branches.find(this.mergeFrom, true) : branches.currentBranch();
                branchToMergeFrom.ifPresent(branch -> toMergeFrom.put(checkout, (Branches.Branch)branch));
                branches.find(this.mergeInto, true).ifPresent(branchToMergeTo -> toMergeTo.put(checkout, branchToMergeTo));
                if (this.alsoMergeInto == null) continue;
                branches.find(this.alsoMergeInto, true).or(() -> branches.find(this.alsoMergeInto, false)).ifPresent(also -> additionalDestinations.put(checkout, also));
            }
            HashSet common = new HashSet(toMergeTo.keySet());
            common.retainAll(toMergeFrom.keySet());
            HashSet toRemove = new HashSet(toMergeTo.keySet());
            toRemove.addAll(toMergeFrom.keySet());
            toRemove.removeAll(common);
            for (GitCheckout rem : toRemove) {
                toMergeFrom.remove(rem);
                toMergeTo.remove(rem);
            }
            toRemove.clear();
            toMergeFrom.forEach((repo, branch) -> {
                if (branch.equals(toMergeTo.get(repo))) {
                    toRemove.add(repo);
                }
            });
            for (GitCheckout rem : toRemove) {
                toMergeFrom.remove(rem);
                toMergeTo.remove(rem);
            }
            c.accept(toMergeFrom, toMergeTo, additionalDestinations);
        }
        finally {
            tree.invalidateCache();
        }
    }

    private String tagName(Branches.Branch fromBranch) {
        String nm = fromBranch.name();
        int ix = nm.lastIndexOf(47);
        if (ix > 0 && ix < nm.length() - 1) {
            return nm.substring(ix + 1);
        }
        return nm;
    }
}

