/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.ForkBuildMojo;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.ScopedCheckoutsMojo;
import com.telenav.cactus.maven.shared.SharedData;
import com.telenav.cactus.maven.tree.ProjectTree;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="finish-attempt-merge")
@Mojo(defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.KEEP_ALIVE, name="finish-attempt-merge", threadSafe=true)
public class MergeForkBuildMojo
extends ScopedCheckoutsMojo {
    private final String DID_NOT_RUN_MESSAGE = MergeForkBuildMojo.class.getSimpleName() + " requires that " + ForkBuildMojo.class.getSimpleName() + " was run at an earlier phase of the build, but no data provided by it was found to determine what needs to be merged.";
    @Inject
    SharedData sharedData;

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        Optional<String> tempBranch = this.sharedData.remove(ForkBuildMojo.TEMP_BRANCH_KEY);
        Optional<String> targetBranch = this.sharedData.remove(ForkBuildMojo.TARGET_BRANCH_KEY);
        Optional<GitCheckout[]> ourCheckouts = this.sharedData.remove(ForkBuildMojo.BRANCHED_REPOS_KEY);
        if (tempBranch.isPresent() && targetBranch.isPresent() && ourCheckouts.isPresent()) {
            this.performMerge(tempBranch.get(), ourCheckouts.get(), targetBranch.get(), log.child("merge"));
        }
    }

    @Override
    protected void onValidateParameters(BuildLog log, MavenProject project) throws Exception {
        if (this.sharedData == null) {
            this.fail("Shared data not injected");
        }
        String baseMessage = MergeForkBuildMojo.class.getSimpleName() + " requires that " + ForkBuildMojo.class.getSimpleName() + " was run at an earlier phase of the build, but no data provided by it was found to determine what needs to be merged.";
        this.sharedData.ensureHas(ForkBuildMojo.TEMP_BRANCH_KEY, baseMessage);
        this.sharedData.ensureHas(ForkBuildMojo.TARGET_BRANCH_KEY, baseMessage);
        this.sharedData.ensureHas(ForkBuildMojo.BRANCHED_REPOS_KEY, baseMessage);
    }

    private void performMerge(String tempBranch, GitCheckout[] checkouts, String targetBranch, BuildLog log) throws MojoExecutionException {
        LinkedHashSet<GitCheckout> toMerge = new LinkedHashSet<GitCheckout>(Arrays.asList(checkouts));
        for (GitCheckout co : checkouts) {
            Optional currBranch = co.branch();
            if (!currBranch.isPresent()) {
                log.warn(co.name() + " should be on " + tempBranch + " but is not on a branch with head " + co.head());
                toMerge.remove(co);
            } else if (!tempBranch.equals(currBranch.get())) {
                log.warn(co.name() + " should be on " + tempBranch + " but is not on a branch with head " + co.head());
                toMerge.remove(co);
            }
            log.info("Check out target branch '" + targetBranch + "' in " + co.name());
            if (this.isPretend()) continue;
            co.switchToBranch(targetBranch);
        }
        for (GitCheckout co : toMerge) {
            log.info("Merge " + tempBranch + " into " + targetBranch + " in " + co.name());
            if (this.isPretend()) continue;
            co.merge(tempBranch);
        }
    }
}

