/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.function.state.Int;
import com.telenav.cactus.git.Branches;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.github.MinimalPRItem;
import com.telenav.cactus.maven.AbstractGithubMojo;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.tree.ProjectTree;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="show-prs")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresOnline=true, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="show-prs", threadSafe=true)
public class OpenPRsForBranchMojo
extends AbstractGithubMojo {
    @Parameter(property="cactus.mergeable-only", defaultValue="false")
    private boolean mergeableOnly;
    @Parameter(property="cactus.base-branch", defaultValue="develop")
    String baseBranch;
    @Parameter(property="cactus.target-branch")
    String targetBranch;

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        Map<GitCheckout, Branches.Branch> branches = OpenPRsForBranchMojo.checkoutsThatHaveBranch(myCheckout, this.targetBranch, checkouts, log, tree);
        if (branches.isEmpty()) {
            log.warn("No branches found");
            return;
        }
        Int count = Int.create();
        branches.forEach((checkout, branch) -> this.pullRequests((GitCheckout)checkout, (Branches.Branch)branch).forEach(pr -> {
            this.emitMessage("PR " + pr.number + " of " + checkout.loggingName() + " at " + pr.url);
            this.ifNotPretending(() -> this.open(pr.toURI()));
            count.increment();
        }));
        count.ifEqual(0, () -> this.emitMessage("No PRs found to open."));
    }

    private Collection<? extends MinimalPRItem> pullRequests(GitCheckout checkout, Branches.Branch branch) {
        if (this.mergeableOnly) {
            return this.openAndMergeablePullRequestsForBranch(this.baseBranch, branch.name(), checkout);
        }
        return this.openPullRequestsForBranch(this.baseBranch, branch.name(), checkout);
    }

    @Override
    protected void onValidateGithubParameters(BuildLog log, MavenProject project) throws Exception {
        this.validateBranchName(this.baseBranch, false);
        this.validateBranchName(this.targetBranch, true);
    }
}

