/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.concurrent.ConcurrentLinkedList;
import com.mastfrog.util.strings.Strings;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;

final class ParallelismDiagnosticsLogger {
    private static final ParallelismDiagnosticsLogger LOG = new ParallelismDiagnosticsLogger();
    private static final String PREFIX = "\n\u255f";
    private final Thread thread = new Thread(this::diagnosticPrintingLoop);
    private final Thread shutdownThread = new Thread(this::onShutdown);
    private final ConcurrentLinkedList<Diagnostic> diagnostics = ConcurrentLinkedList.fifo();
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicInteger diagnosticsPrinted = new AtomicInteger();
    private volatile boolean shuttingDown;

    private ParallelismDiagnosticsLogger() {
        this.thread.setDaemon(true);
        this.thread.setPriority(4);
    }

    public static synchronized void logDiagnostic(BaseMojo mojo, boolean captureStackTrace) {
        MavenSession sess = mojo.session();
        if (sess == null) {
            System.err.println("NULL SESSION IN " + mojo);
            return;
        }
        MavenProject runningProject = sess.getCurrentProject();
        if (runningProject == null) {
            runningProject = mojo.project();
            if (runningProject == null) {
                System.err.println("SESSION AND MOJO HAVE NULL PROJECT: " + mojo + " sess " + sess);
                return;
            }
            System.err.println("SESSION SHOWS NULL CURRENT PROJECT BUT MOJO HAS " + runningProject);
        }
        LOG.add(new Diagnostic(mojo, sess, runningProject, captureStackTrace));
    }

    private void add(Diagnostic diag) {
        if (this.started.compareAndSet(false, true)) {
            this.thread.start();
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        }
        this.diagnostics.push((Object)diag);
        LockSupport.unpark(this.thread);
    }

    private void diagnosticPrintingLoop() {
        try {
            while (!Thread.interrupted() && !this.shuttingDown) {
                this.printDiagnostics();
                LockSupport.park(this);
            }
        }
        finally {
            this.printDiagnostics();
        }
    }

    private void printDiagnostics() {
        while (!this.diagnostics.isEmpty()) {
            this.diagnostics.drain(diagnostic -> {
                int item = this.diagnosticsPrinted.incrementAndGet();
                System.out.println(diagnostic.render(item));
            });
        }
    }

    private void onShutdown() {
        this.shuttingDown = true;
        try {
            if (this.thread.isAlive()) {
                LockSupport.unpark(this.thread);
                this.thread.interrupt();
            }
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            this.printDiagnostics();
        }
    }

    private static final class Diagnostic {
        private final boolean parallel;
        private final long threadId;
        private final String invokedAgainstProject;
        private final String stackTrace;
        private final String projectList;
        private final boolean duplicateIds;
        private final boolean duplicateProjects;
        private final String mojoClass;

        Diagnostic(BaseMojo mojo, MavenSession sess, MavenProject currentProject, boolean stack) {
            this.mojoClass = ((Object)((Object)mojo)).getClass().getSimpleName() + " @ " + System.identityHashCode((Object)mojo);
            this.threadId = Thread.currentThread().getId();
            this.parallel = sess.isParallel();
            this.invokedAgainstProject = sess.getTopLevelProject().getArtifactId();
            this.stackTrace = stack ? "\n" + Strings.toString((Throwable)new Exception(currentProject.getArtifactId() + " on " + this.mojoClass)) : "";
            MavenProject top = sess.getTopLevelProject();
            List all = sess.getAllProjects();
            HashSet<MavenProject> allMavenProjects = new HashSet<MavenProject>();
            HashSet<CallSite> allIdentifiers = new HashSet<CallSite>();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < all.size(); ++i) {
                MavenProject project = (MavenProject)all.get(i);
                allMavenProjects.add(project);
                allIdentifiers.add((CallSite)((Object)(project.getArtifactId() + ":" + project.getGroupId())));
                String prefix = "\n\u255f  " + (i + 1) + ". ";
                String suffix = "";
                if (project == top) {
                    prefix = "\n\u255f  *** " + (i + 1) + ". ";
                    suffix = " ***";
                }
                if (project == currentProject) {
                    prefix = "\n\u255f  >---> " + (i + 1) + ". ";
                    suffix = " <---<";
                }
                sb.append(prefix).append(project.getArtifactId()).append(suffix);
            }
            this.projectList = sb.toString();
            this.duplicateIds = allIdentifiers.size() < all.size();
            this.duplicateProjects = allMavenProjects.size() < all.size();
        }

        public String render(int index) {
            return "\n\u255f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501 " + index + " \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\n\u255f " + this.mojoClass + " for " + this.invokedAgainstProject + " on " + this.threadId + (this.parallel ? " parallel-build " : " single-threaded-build ") + (this.duplicateProjects ? " DUPLICATE_PROJECTS! " : "") + (this.duplicateIds ? " DUPLICATE_PROJECT_IDENTIFIERS! " : "") + this.projectList + this.stackTrace;
        }
    }
}

