/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.git.CommitInfo;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.ScopedCheckoutsMojo;
import com.telenav.cactus.maven.tree.ProjectTree;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="last-change")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.KEEP_ALIVE, name="last-change", threadSafe=true)
public class PrintHistoryMojo
extends ScopedCheckoutsMojo {
    private static final int PAGE_SIZE = 5;
    @Parameter(property="cactus.file.extension")
    String fileExtension;
    @Parameter(property="cactus.local")
    boolean local;

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        if (this.local) {
            checkouts = Arrays.asList(myCheckout);
        }
        checkouts.forEach(checkout -> {
            Set nonPomProjects = tree.projectsWithin((GitCheckout)checkout).stream().filter(pom -> !pom.isPomProject()).collect(Collectors.toCollection(HashSet::new));
            if (nonPomProjects.isEmpty()) {
                return;
            }
            this.emitCheckoutStart((GitCheckout)checkout);
            checkout.changeHistory(5, historyRecord -> {
                if (this.fileExtension != null) {
                    Optional optInfo = historyRecord.includeOnlyFileExtension(this.fileExtension);
                    if (!optInfo.isPresent()) {
                        return true;
                    }
                    historyRecord = (CommitInfo)optInfo.get();
                }
                HashSet<Pom> found = new HashSet<Pom>();
                for (Pom pom : nonPomProjects) {
                    Path relPath = checkout.checkoutRoot().relativize(pom.projectFolder());
                    if (!historyRecord.contains(relPath)) continue;
                    found.add(pom);
                    this.emit(pom, relPath, (CommitInfo)historyRecord);
                }
                nonPomProjects.removeAll(found);
                return !nonPomProjects.isEmpty();
            });
        });
    }

    private void emitCheckoutStart(GitCheckout checkout) {
        this.emitMessage("");
        String ln = checkout.loggingName();
        this.emitMessage(ln);
        char[] c = new char[ln.length() + 1];
        Arrays.fill(c, '=');
        c[c.length - 1] = 10;
        this.emitMessage(new String(c));
    }

    private void emit(Pom pom, Path relPath, CommitInfo historyRecord) {
        this.emitMessage(relPath + " " + pom.toArtifactIdentifiers() + "\n  " + historyRecord.info());
    }
}

