/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.concurrent.ConcurrentLinkedList;
import com.telenav.cactus.maven.PrintableMessage;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.trigger.RunPolicies;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="print-message")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.KEEP_ALIVE, name="print-message", threadSafe=true)
public class PrintMessageMojo
extends BaseMojo {
    @Parameter(property="cactus.message", required=true)
    private String message;
    @Parameter(property="cactus.message.on.failure")
    private Boolean onFailure;
    private static final AtomicBoolean HOOK_ADDED = new AtomicBoolean();
    private static final ConcurrentLinkedList<PrintableMessage> messages = ConcurrentLinkedList.fifo();

    public PrintMessageMojo() {
        super(RunPolicies.LAST_CONTAINING_GOAL);
    }

    @Override
    protected void performTasks(BuildLog log, MavenProject project) throws Exception {
        if (this.message != null) {
            this.addMessage(this.message);
        }
    }

    static void publishMessage(CharSequence msg, MavenSession session, boolean onFailure) {
        messages.push((Object)new PrintableMessage(msg, session, onFailure));
        if (HOOK_ADDED.compareAndSet(false, true)) {
            Thread t = new Thread(() -> PrintMessageMojo.emitMessages(), "shutdown-messages");
            Runtime.getRuntime().addShutdownHook(t);
        }
    }

    void addMessage(CharSequence msg) {
        messages.push((Object)new PrintableMessage(msg, this.session(), this.onFailure));
        if (HOOK_ADDED.compareAndSet(false, true)) {
            Thread t = new Thread(() -> PrintMessageMojo.emitMessages(), ((Object)((Object)this)).getClass().getName());
            Runtime.getRuntime().addShutdownHook(t);
        }
    }

    private static void emitMessages() {
        HashSet<PrintableMessage> seen = new HashSet<PrintableMessage>();
        LinkedList msgs = new LinkedList();
        messages.drain(msgs::add);
        boolean first = true;
        if (!msgs.isEmpty()) {
            for (PrintableMessage s : msgs) {
                if (!s.shouldPrint() || !seen.add(s)) continue;
                if (first) {
                    System.out.println("\n*********************************************************\n\n");
                    first = false;
                }
                PrintMessageMojo.emitMessage(s.toString());
            }
            System.out.println("\n\n*********************************************************\n");
        }
    }

    private static void emitMessage(String msg) {
        for (String s : msg.split("\n")) {
            s = s.trim().replaceAll("\\\\n", "\n").replaceAll("\\\\t", "\t");
            System.out.println(s);
        }
    }
}

