/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.shared.SharedDataKey;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.scope.ProjectFamily;
import com.telenav.cactus.scope.Scope;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="print-scopes")
@Mojo(defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, name="print-scopes", threadSafe=true)
public class PrintScopesMojo
extends BaseMojo {
    private static final SharedDataKey<ProjectTree> TREE_KEY = SharedDataKey.of(ProjectTree.class);
    private static final SharedDataKey<Set<FamilyAndScope>> SEEN_KEY = SharedDataKey.of(Set.class);
    @Parameter(property="detail", defaultValue="false")
    private boolean printProjects;

    @Override
    public void performTasks(BuildLog log, MavenProject project) throws Exception {
        ProjectTree tree = this.tree(project);
        GitCheckout co = (GitCheckout)GitCheckout.checkout((File)project.getBasedir()).get();
        ProjectFamily family = ProjectFamily.fromGroupId((String)project.getGroupId());
        for (Scope scope : Scope.values()) {
            if (this.seen(family, scope, co)) continue;
            this.emitMessage("\n----- scope '" + scope + "' for family '" + family + "' in " + co.loggingName() + " -----");
            List<GitCheckout> matched = tree.matchCheckouts(scope, co, true, Collections.singleton(family), project.getGroupId());
            for (GitCheckout gc : matched) {
                String nm = gc.name();
                if (nm.isEmpty()) {
                    nm = "(root)";
                }
                this.emitMessage("  * " + nm);
                if (!this.printProjects) continue;
                tree.projectsWithin(gc).forEach(prj -> {
                    if (ProjectFamily.fromGroupId((String)prj.groupId().text()).equals((Object)family)) {
                        this.emitMessage("    * " + prj.coordinates());
                    }
                });
            }
        }
    }

    private boolean seen(ProjectFamily family, Scope scope, GitCheckout co) {
        FamilyAndScope test = new FamilyAndScope(scope, family, co);
        Set set = this.sharedData().computeIfAbsent(SEEN_KEY, HashSet::new);
        return !set.add(test);
    }

    private ProjectTree tree(MavenProject prj) {
        return this.sharedData().computeIfAbsent(TREE_KEY, () -> (ProjectTree)ProjectTree.from(prj).get());
    }

    private static final class FamilyAndScope {
        private final Scope scope;
        private final ProjectFamily family;
        private final GitCheckout checkout;

        FamilyAndScope(Scope scope, ProjectFamily family, GitCheckout checkout) {
            this.scope = scope;
            this.family = family;
            this.checkout = checkout;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FamilyAndScope other = (FamilyAndScope)obj;
            if (this.scope != other.scope) {
                return false;
            }
            if (!Objects.equals(this.family, other.family)) {
                return false;
            }
            return Objects.equals(this.checkout, other.checkout);
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.scope);
            hash = 97 * hash + Objects.hashCode(this.family);
            hash = 97 * hash + Objects.hashCode(this.checkout);
            return hash;
        }
    }
}

