/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.util.preconditions.Checks;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;

public class PrintableMessage {
    private final CharSequence message;
    private final Reference<MavenSession> sess;
    private final Boolean onFailure;

    public PrintableMessage(CharSequence msg, MavenSession sess, Boolean printOnFailure) {
        this.sess = new WeakReference<MavenSession>(sess);
        this.message = (CharSequence)Checks.notNull((String)"msg", (Object)msg);
        this.onFailure = printOnFailure;
    }

    public boolean shouldPrint() {
        MavenExecutionResult result;
        if (this.onFailure == null) {
            return true;
        }
        boolean hasExceptions = false;
        MavenSession s = this.sess.get();
        if (s != null && (result = s.getResult()) != null && result.hasExceptions()) {
            hasExceptions = true;
        }
        if (!this.onFailure.booleanValue()) {
            return !hasExceptions;
        }
        return hasExceptions;
    }

    public String toString() {
        return this.message.toString();
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.message);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrintableMessage other = (PrintableMessage)obj;
        return Objects.equals(this.message, other.message);
    }
}

