/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.mastfrog.util.strings.Strings;
import com.telenav.cactus.maven.ParallelismDiagnosticsLogger;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.shared.SharedDataKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="project-information")
@Mojo(defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.PER_LOOKUP, name="project-information", threadSafe=true)
public class ProjectInformationMojo
extends BaseMojo {
    private static final String SYSTEM_PROPERTY_DIAGNOSTIC_ARTIFACT_IDS = "cactus.diag-artifact-ids";
    private static final String SYSTEM_PROPERTY_DIAGNOSTIC_ARTIFACT_IDS_STACKS = "cactus.diag-stacks-for-artifact-id";
    private static final Set<String> LOG_DIAGNOSTICS_FOR = ProjectInformationMojo.artifactIdSetFrom(System.getProperty("cactus.diag-artifact-ids"));
    private static final Set<String> PRINT_STACKS_FOR = ProjectInformationMojo.combine(LOG_DIAGNOSTICS_FOR, ProjectInformationMojo.artifactIdSetFrom(System.getProperty("cactus.diag-stacks-for-artifact-id")));
    private static final SharedDataKey<Set<String>> EMITTED_KEY = SharedDataKey.of("emitted", Set.class);
    private static final boolean PRINT_DEBUG_STACKS = Boolean.getBoolean("cactus.debug.stacks");
    @Parameter(property="cactus.verb")
    private String verb;

    private String verb() {
        return this.verb == null ? "Building" : Strings.capitalize((CharSequence)this.verb);
    }

    private void emit(MavenProject project) {
        String info;
        Set emitted = this.sharedData().computeIfAbsent(EMITTED_KEY, ConcurrentHashMap::newKeySet);
        if (emitted.add(info = this.generateInfo(project).toString())) {
            this.emitMessage(info);
        }
    }

    @Override
    protected void performTasks(BuildLog log, MavenProject project) {
        this.emit(project);
        if (PRINT_DEBUG_STACKS) {
            this.diagnostics(project);
        }
    }

    private CharSequence generateInfo(MavenProject project) {
        return "\u250b " + this.verb() + " " + project.getName();
    }

    private void diagnostics(MavenProject project) {
        if (ProjectInformationMojo.pertainsTo(project, LOG_DIAGNOSTICS_FOR)) {
            boolean stack = ProjectInformationMojo.pertainsTo(project, PRINT_STACKS_FOR);
            ParallelismDiagnosticsLogger.logDiagnostic(this, stack);
        }
    }

    private static boolean pertainsTo(MavenProject project, Set<String> set) {
        return set.isEmpty() || set.contains(project.getName()) || set.contains(project.getArtifactId());
    }

    private static Set<String> combine(Set<String> a, Set<String> b) {
        HashSet<String> result = new HashSet<String>(a);
        result.addAll(b);
        return result;
    }

    private static Set<String> artifactIdSetFrom(String systemPropertyOrNull) {
        if (systemPropertyOrNull == null) {
            return new HashSet<String>(Arrays.asList("kivakit-serialization-properties", "kivakit-testing"));
        }
        if ("all".equals(systemPropertyOrNull) || systemPropertyOrNull.isBlank()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(systemPropertyOrNull.split("[, ]+")));
    }
}

