/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.git.Conflicts;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.PrintMessageMojo;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.ScopedCheckoutsMojo;
import com.telenav.cactus.maven.tree.ProjectTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="pull")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="pull", threadSafe=true)
public class PullMojo
extends ScopedCheckoutsMojo {
    @Parameter(property="cactus.permit-local-changes", defaultValue="true")
    private boolean permitLocalModifications;
    @Parameter(property="cactus.skip-conflicts", defaultValue="false")
    private boolean skipConflicts;

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        List<GitCheckout> needingPull = this.needingPull(checkouts);
        if (needingPull.isEmpty()) {
            log.info("Nothing to pull. All projects are up to date with remote.");
        } else {
            String pfx = this.isPretend() ? "(pretend) " : "";
            GitCheckout root = tree.root();
            if (!root.isSubmoduleRoot()) {
                root = null;
            }
            TreeMap<GitCheckout, Conflicts> allConflicts = new TreeMap<GitCheckout, Conflicts>();
            for (GitCheckout checkout2 : needingPull) {
                log.info("Fetch to determine if merge can succeed.");
                this.ifNotPretending(() -> ((GitCheckout)checkout2).fetch());
                Conflicts conflicts2 = checkout2.checkForConflicts();
                if (conflicts2.isEmpty() || !conflicts2.hasHardConflicts()) continue;
                if (!checkout2.equals((Object)root)) {
                    allConflicts.put(checkout2, conflicts2);
                    continue;
                }
                log.info("Ignoring gitmodules conflict " + conflicts2 + " can be solved with a rebase.");
            }
            if (!allConflicts.isEmpty()) {
                StringBuilder sb = new StringBuilder("Pull will cause conflicts in " + allConflicts.size() + " git checkouts:");
                allConflicts.forEach((checkout, conflicts) -> {
                    sb.append("\n  * ").append(checkout.loggingName());
                    for (Conflicts.Conflict cflict : conflicts) {
                        sb.append("\n    * ").append(cflict);
                    }
                });
                if (this.skipConflicts) {
                    PrintMessageMojo.publishMessage(sb, this.session(), false);
                    needingPull.removeAll(allConflicts.keySet());
                    if (needingPull.isEmpty()) {
                        log.warn("All repos to pull have conflicts.  Nothing to do.");
                        return;
                    }
                } else {
                    this.fail(sb);
                }
            }
            needingPull.stream().map(checkout -> {
                log.info(pfx + "Pull " + checkout.loggingName());
                return checkout;
            }).map(checkout -> {
                this.emitMessage("Pull " + pfx + checkout.loggingName());
                return checkout;
            }).filter(checkout -> !this.isPretend()).forEachOrdered(checkout -> checkout.pull());
        }
    }

    @Override
    protected boolean forbidsLocalModifications() {
        return !this.permitLocalModifications;
    }

    private List<GitCheckout> needingPull(Collection<? extends GitCheckout> cos) {
        return cos.stream().filter(co -> this.isPretend() ? co.needsPull() : co.updateRemoteHeads().needsPull() || co.remoteHead().map(h -> !h.equals(co.head())).orElse(false) != false).collect(Collectors.toCollection(() -> new ArrayList(cos.size())));
    }
}

