/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.git.Conflicts;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.git.NeedPushResult;
import com.telenav.cactus.maven.AutomergeTagMojo;
import com.telenav.cactus.maven.PrintMessageMojo;
import com.telenav.cactus.maven.commit.CommitMessage;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.AutomergeTag;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.ScopedCheckoutsMojo;
import com.telenav.cactus.maven.tree.ProjectTree;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="push")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="push", threadSafe=true)
public class PushMojo
extends ScopedCheckoutsMojo {
    @Parameter(property="cactus.permit-local-changes", defaultValue="true")
    private boolean permitLocalModifications;
    @Parameter(property="cactus.push-all", defaultValue="false")
    private boolean pushAll;
    @Parameter(property="cactus.skip-conflicts", defaultValue="false")
    private boolean skipConflicts;
    @Parameter(property="cactus.stable-branch", defaultValue="stable")
    private String stableBranch;
    @Parameter(property="cactus.create-automerge-tag", defaultValue="false")
    private boolean createAutomergeTag;

    static Map<GitCheckout, NeedPushResult> collectPushKinds(Collection<? extends GitCheckout> checkouts) {
        HashMap<GitCheckout, NeedPushResult> result = new HashMap<GitCheckout, NeedPushResult>();
        for (GitCheckout gitCheckout : checkouts) {
            NeedPushResult res = gitCheckout.needsPush();
            if (!res.canBePushed()) continue;
            result.put(gitCheckout, res);
        }
        return result;
    }

    static boolean needPull(GitCheckout checkout) {
        return checkout.mergeBase().map(mergeBase -> checkout.remoteHead().map(remoteHead -> checkout.head().equals(mergeBase)).orElse(false)).orElse(false);
    }

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        List needingPush;
        GitCheckout root = tree.root();
        if (this.isIncludeRoot() && !checkouts.contains(tree.root())) {
            checkouts.add(tree.root());
        }
        if ((needingPush = GitCheckout.depthFirstSort(PushMojo.collectPushKinds(checkouts))).isEmpty()) {
            log.info("No projects needing push in " + needingPush);
        } else {
            this.pullIfNeededAndPush(log, project, needingPush, tree, root);
        }
        if (this.isIncludeRoot() && (root.hasUncommitedChanges() || root.hasUntrackedFiles() || root.needsPush().canBePushed())) {
            CommitMessage msg = new CommitMessage(PushMojo.class, "Updating heads for push of " + (checkouts.size() - 1) + " checkouts");
            msg.section("Submodules", section -> needingPush.forEach(entry -> section.bulletPoint(((GitCheckout)entry.getKey()).loggingName() + " " + entry.getValue() + " -> " + ((GitCheckout)entry.getKey()).head().substring(0, 7))));
            log.info("Create commit and push in root " + root.checkoutRoot().getFileName());
            this.ifNotPretending(() -> {
                root.addAll();
                root.commit(msg.toString());
            });
            this.ifNotPretending(() -> ((GitCheckout)root).push());
            if (this.createAutomergeTag) {
                AutomergeTagMojo.automergeTag(null, this.stableBranch, tree, log, this.isPretend(), Collections.singleton(root), true, () -> this.automergeTag());
            }
        }
    }

    @Override
    protected boolean forbidsLocalModifications() {
        return !this.permitLocalModifications;
    }

    private Set<GitCheckout> checkNeedPull(List<Map.Entry<GitCheckout, NeedPushResult>> needingPush, BuildLog log) {
        LinkedHashSet<GitCheckout> needingPull = new LinkedHashSet<GitCheckout>();
        for (Map.Entry<GitCheckout, NeedPushResult> co : needingPush) {
            GitCheckout checkout = co.getKey();
            log.debug("Update remote heads: " + checkout.name());
            if (!this.isPretend()) {
                checkout.updateRemoteHeads();
            }
            if (co.getValue().needCreateBranch() || !checkout.needsPull()) continue;
            log.debug("Needs pull: " + checkout.name());
            needingPull.add(checkout);
        }
        return needingPull;
    }

    private Set<GitCheckout> pull(Set<GitCheckout> needingPull, BuildLog log, GitCheckout submoduleRoot) {
        boolean rootIsRoot = submoduleRoot.isSubmoduleRoot();
        TreeMap<GitCheckout, Conflicts> allConflicts = new TreeMap<GitCheckout, Conflicts>();
        if (!needingPull.isEmpty()) {
            log.warn("Needing pull:");
            for (GitCheckout checkout : needingPull) {
                Conflicts cf2;
                if (rootIsRoot && submoduleRoot.equals((Object)checkout) || (cf2 = checkout.checkForConflicts()).isEmpty() || !cf2.hasHardConflicts()) continue;
                allConflicts.put(checkout, cf2.filterHard());
            }
            if (!allConflicts.isEmpty()) {
                StringBuilder sb = new StringBuilder("Conflicts - " + allConflicts.size() + " checkouts cannot be pushed");
                allConflicts.forEach((repo, cf) -> {
                    sb.append("\n  * ").append(repo.loggingName());
                    cf.forEach(c -> sb.append("\n    * ").append(c));
                });
                if (this.skipConflicts) {
                    needingPull.removeAll(allConflicts.keySet());
                    PrintMessageMojo.publishMessage(sb, this.session(), false);
                } else {
                    this.fail(sb);
                }
            }
            for (GitCheckout checkout : needingPull) {
                log.info("Pull " + checkout);
                if (this.isPretend()) continue;
                if (checkout.equals((Object)submoduleRoot) && rootIsRoot) {
                    checkout.pullWithRebase();
                    continue;
                }
                checkout.pull();
            }
        }
        return new HashSet<GitCheckout>(allConflicts.keySet());
    }

    private void pullIfNeededAndPush(BuildLog log, MavenProject project, List<Map.Entry<GitCheckout, NeedPushResult>> needingPush, ProjectTree tree, GitCheckout submoduleRoot) {
        Set<GitCheckout> needingPull = this.checkNeedPull(needingPush, log.child("checkNeedPull"));
        Set<GitCheckout> skipped = this.pull(needingPull, log.child("pull"), submoduleRoot);
        Set<Object> tagged = Collections.emptySet();
        if (this.createAutomergeTag) {
            LinkedHashSet toTag = new LinkedHashSet();
            needingPush.forEach(e -> {
                if (!submoduleRoot.equals(e.getKey()) && !skipped.contains(e.getKey())) {
                    toTag.add((GitCheckout)e.getKey());
                }
            });
            tagged = AutomergeTagMojo.automergeTag(null, this.stableBranch, tree, log.child("automerge-tag"), this.isPretend(), toTag, false, () -> this.automergeTag());
        }
        this.push(needingPush, log.child("push"));
        if (!this.pushAll && !tagged.isEmpty()) {
            AutomergeTag tag = this.automergeTag();
            for (GitCheckout taggedRepo : tagged) {
                log.info("Push tag " + tag + " to " + taggedRepo.loggingName());
                this.ifNotPretending(() -> taggedRepo.pushTag(tag.toString()));
            }
        }
    }

    private void push(List<Map.Entry<GitCheckout, NeedPushResult>> needingPush, BuildLog log) {
        log.warn("Begin push.");
        for (Map.Entry<GitCheckout, NeedPushResult> co : needingPush) {
            GitCheckout checkout = co.getKey();
            if (co.getValue().needCreateBranch()) {
                log.info("Push creating branch: " + checkout);
                if (this.isPretend()) continue;
                if (this.pushAll) {
                    checkout.pushAll();
                    continue;
                }
                checkout.pushCreatingBranch();
                continue;
            }
            log.info("Push: " + checkout);
            this.emitMessage(checkout);
            if (this.isPretend()) continue;
            if (this.pushAll) {
                checkout.pushAll();
                continue;
            }
            checkout.push();
        }
    }
}

