/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven;

import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.mojobase.ScopedCheckoutsMojo;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.maven.trigger.RunPolicy;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@BaseMojoGoal(value="replace")
@Mojo(defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.NONE, instantiationStrategy=InstantiationStrategy.SINGLETON, name="replace", threadSafe=true)
public class ReplaceMojo
extends ScopedCheckoutsMojo {
    private static final Pattern VARIABLE_EXPRESSION = Pattern.compile("<!--\\s*\\[(?<variable>[A-Za-z\\d.-]+)]\\s*-->");
    @Parameter(property="cactus.replacement-version")
    String newVersion;
    @Parameter(property="cactus.replacement-branch-name")
    String newBranchName;
    private final Map<String, Replacement> variables = new HashMap<String, Replacement>();

    public ReplaceMojo() {
    }

    public ReplaceMojo(boolean runFirst) {
        super(runFirst);
    }

    public ReplaceMojo(RunPolicy pol) {
        super(pol);
    }

    @Override
    protected void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts) throws Exception {
        this.executeCollectingChangedFiles(log, project, myCheckout, tree, checkouts, Collections.emptyMap(), _ignored -> {});
    }

    void executeCollectingChangedFiles(BuildLog log, MavenProject project, GitCheckout myCheckout, ProjectTree tree, List<GitCheckout> checkouts, Map<GitCheckout, String> releaseBranchNames, Consumer<Path> changed) throws Exception {
        for (GitCheckout checkout : checkouts) {
            String branchName = releaseBranchNames.getOrDefault(checkout, this.newBranchName == null && checkout.branch().isPresent() ? (String)checkout.branch().get() : this.newBranchName);
            if (this.newVersion == null) {
                throw new RuntimeException("No replacement version was specified for " + checkout);
            }
            if (branchName == null) {
                throw new RuntimeException("No replacement branch name was specified and there is no default branch for " + checkout);
            }
            this.variables.put("cactus.replacement-version", new Replacement("\\d+\\.\\d+(\\.\\d+)?(-SNAPSHOT)?", this.newVersion));
            this.variables.put("cactus.replacement-branch-name", new Replacement("(develop|((release|hotfix|feature)/[a-zA-Z\\d.-]+))", branchName));
            if (this.isPretend()) continue;
            Stream<Path> walk = Files.walk(checkout.checkoutRoot(), new FileVisitOption[0]);
            try {
                walk.filter(path -> path.toFile().isFile()).forEach(file -> {
                    String filename = file.getFileName().toString();
                    if (filename.endsWith(".md") || file.getFileName().equals(Paths.get("pom.xml", new String[0]))) {
                        this.replaceIn((Path)file);
                        changed.accept((Path)file);
                    }
                });
            }
            finally {
                if (walk == null) continue;
                walk.close();
            }
        }
    }

    private ReplaceResult replace(String text) {
        StringBuilder replaced = new StringBuilder();
        ReplaceResult result = new ReplaceResult();
        boolean count = false;
        text.lines().forEach(line -> {
            Matcher matcher = VARIABLE_EXPRESSION.matcher((CharSequence)line);
            if (matcher.find()) {
                String variable = matcher.group("variable");
                Replacement replacement = this.variables.get(variable);
                if (replacement == null) {
                    throw new RuntimeException("Cannot find replacement variable: " + variable);
                }
                ++result.count;
                replaced.append(line.replaceFirst(replacement.pattern, replacement.replacement));
            } else {
                replaced.append((String)line);
            }
            replaced.append('\n');
        });
        result.replaced = replaced.toString();
        return result;
    }

    private void replaceIn(Path file) {
        try {
            String originalContents = Files.readString(file, StandardCharsets.UTF_8);
            ReplaceResult replaced = this.replace(originalContents);
            if (!originalContents.equals(replaced.replaced)) {
                if (!this.isPretend()) {
                    Files.writeString(file, (CharSequence)replaced.replaced, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                this.log().info("Replaced " + replaced.count + " in " + file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Replacement {
        String pattern;
        String replacement;

        Replacement(String pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }
    }

    private static class ReplaceResult {
        String replaced;
        int count;

        private ReplaceResult() {
        }
    }
}

