/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.commit;

import com.telenav.cactus.metadata.BuildMetadata;
import com.telenav.cactus.util.SectionedMessage;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class CommitMessage
implements SectionedMessage<Section<CommitMessage>> {
    private final String provenanceIdentifier;
    private final String generatorClass;
    private final StringBuilder summary = new StringBuilder();
    private final StringBuilder detail = new StringBuilder();
    private final List<Section<CommitMessage>> sections = new ArrayList<Section<CommitMessage>>();

    public CommitMessage(Class<?> generator, String provenance, String initialSummary) {
        this.provenanceIdentifier = provenance;
        this.summary.append(initialSummary);
        this.generatorClass = generator.getSimpleName();
    }

    public CommitMessage(Class<?> generator, String summary) {
        this(generator, "cactus", summary);
    }

    public CommitMessage appendToSummary(CharSequence what) {
        this.summary.append(what);
        return this;
    }

    public CommitMessage append(CharSequence what) {
        this.detail.append(what).append('\n');
        return this;
    }

    public CommitMessage paragraph(CharSequence text) {
        return this.append(text);
    }

    public Section<CommitMessage> section(String title) {
        return new Section<CommitMessage>(title, 0, section -> {
            this.sections.add((Section<CommitMessage>)section);
            return this;
        });
    }

    public Function<? super String, Consumer<Object>> sectionFunction(List<? super Section<?>> sections) {
        return heading -> {
            SectionedMessage.MessageSection sect = this.section((String)heading);
            sections.add((Section<?>)sect);
            return ((Section)sect)::bulletPoint;
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.summary.length() == 0) {
            sb.append("(summary line not provided)");
        } else {
            sb.append((CharSequence)this.summary);
        }
        sb.append("\n\n");
        if (this.detail.length() > 0) {
            sb.append((CharSequence)this.detail);
        }
        if (sb.charAt(sb.length() - 1) != '\n') {
            sb.append('\n');
        }
        for (Object sec : this.sections()) {
            sb.append(sec);
        }
        return sb.toString();
    }

    private List<Object> sections() {
        ArrayList<Object> result = new ArrayList<Object>(this.sections);
        result.add(this.provenanceInfo());
        return result;
    }

    private Section<?> provenanceInfo() {
        Section<Void> result = new Section<Void>("Provenance", 4, sec -> null);
        BuildMetadata meta = BuildMetadata.buildMetaData(CommitMessage.class);
        result.paragraph("Generated by " + this.provenanceIdentifier + ": *" + (String)meta.projectProperties().get("project-artifact-id") + "* version _" + (String)meta.projectProperties().get("project-version") + "_.\n");
        result.bulletPoint("Mojo:\t\t" + this.generatorClass);
        result.bulletPoint("Generation-Time:\t" + Instant.now().with(ChronoField.NANO_OF_SECOND, 0L));
        result.bulletPoint("Plugin-Build:\t" + (String)meta.buildProperties().get("build-name"));
        result.bulletPoint("Plugin-Date:\t" + (String)meta.buildProperties().get("build-date"));
        result.bulletPoint("Plugin-Commit:\t" + (String)meta.buildProperties().get("commit-long-hash"));
        result.bulletPoint("Plugin-Repo-Clean:\t" + (String)meta.buildProperties().get("no-local-modifications"));
        return result;
    }

    public static final class Section<P>
    implements AutoCloseable,
    SectionedMessage.MessageSection<Section<P>> {
        private final List<Object> items = new ArrayList<Object>();
        private final String title;
        private final StringBuilder description = new StringBuilder();
        private final int depth;
        private final Function<Section<P>, P> onClose;

        public Section(String title, int depth, Function<Section<P>, P> onClose) {
            this.title = title;
            this.depth = depth;
            this.onClose = onClose;
        }

        @Override
        public void close() {
            this.finish();
        }

        public P finish() {
            return this.onClose.apply(this);
        }

        public Section<P> bulletPoint(Object text) {
            this.items.add("  * " + text);
            return this;
        }

        public Section<P> bulletPoint(int depth, Object text) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < depth; ++i) {
                sb.append("  ");
            }
            sb.append("* ");
            sb.append(text);
            this.items.add(sb.toString());
            return this;
        }

        public Section<P> paragraph(String text) {
            this.items.add(text);
            return this;
        }

        public Section<Section<P>> subsection(String title) {
            return new Section<Section<P>>(title, this.depth + 1, subSection -> {
                this.items.add(subSection);
                return this;
            });
        }

        public String toString() {
            if (this.items.isEmpty() && this.description.length() == 0) {
                return "";
            }
            StringBuilder result = new StringBuilder("\n");
            if (!this.title.isEmpty()) {
                if (this.depth == 0) {
                    result.append('\n').append(this.title).append('\n');
                    for (int i = 0; i < this.title.length(); ++i) {
                        result.append('-');
                    }
                    result.append("\n\n");
                } else {
                    int count = Math.min(this.depth, 5) + 1;
                    for (int i = 0; i < count; ++i) {
                        result.append('#');
                    }
                    result.append(' ').append(this.title).append("\n\n");
                }
            }
            if (this.description.length() > 0) {
                result.append((CharSequence)this.description).append("\n\n");
            }
            for (Object item : this.items) {
                result.append(item).append('\n');
            }
            return result.toString();
        }

        public Section<P> paragraph(CharSequence text) {
            return this.paragraph(Objects.toString(text));
        }
    }
}

