/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.mojobase;

import com.mastfrog.util.strings.Strings;
import com.telenav.cactus.cli.CliCommand;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.maven.execution.MavenSession;

public final class AutomergeTag {
    public static final String AUTOMERGE_TAG_PREFIX = "automerge-";
    private final long timestamp;
    private final String project;
    private String host;

    AutomergeTag(MavenSession sess) {
        this.timestamp = sess.getStartTime().getTime();
        this.project = sess.getTopLevelProject().getArtifactId();
    }

    AutomergeTag() {
        this.timestamp = System.currentTimeMillis();
        this.project = "-none-";
    }

    public String toString() {
        return AUTOMERGE_TAG_PREFIX + Long.toString(this.timestamp, 36) + "-" + this.host();
    }

    private String host() {
        return this.host == null ? (this.host = this.hostString()) : this.host;
    }

    private String hostString() {
        String result = System.getenv("HOST");
        if (result == null) {
            result = System.getenv("HOSTNAME");
        }
        if (result == null) {
            try {
                result = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                ex.printStackTrace();
            }
        }
        if (result == null) {
            try {
                result = (String)CliCommand.fixed((String)"hostname", (Path)Paths.get(".", new String[0]), (String[])new String[0]).run().awaitQuietly();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result != null) {
            result = Strings.sha1((String)(result + this.project)).replaceAll("=", "").replaceAll("/", "_");
        }
        if (result == null) {
            result = Long.toString(ThreadLocalRandom.current().nextLong(), 36);
        }
        return result;
    }
}

