/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.mojobase;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.function.throwing.ThrowingBiConsumer;
import com.mastfrog.function.throwing.ThrowingConsumer;
import com.mastfrog.function.throwing.ThrowingFunction;
import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.function.throwing.ThrowingSupplier;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.model.MavenCoordinates;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.resolver.ArtifactFinder;
import com.telenav.cactus.maven.mojobase.AutomergeTag;
import com.telenav.cactus.maven.mojobase.BaseMojoGoal;
import com.telenav.cactus.maven.shared.SharedData;
import com.telenav.cactus.maven.shared.SharedDataKey;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.maven.trigger.RunPolicies;
import com.telenav.cactus.maven.trigger.RunPolicy;
import java.awt.Desktop;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.RemoteRepository;

public abstract class BaseMojo
extends AbstractMojo {
    protected static final String MAVEN_CENTRAL_REPO = "https://repo1.maven.org/maven2";
    private static final SharedDataKey<AutomergeTag> AUTOMERGE_TAG_KEY = SharedDataKey.of(AutomergeTag.class);
    private final ThreadLocal<Boolean> running = ThreadLocal.withInitial(() -> false);
    private final SharedDataKey<AtomicBoolean> thisMojoWasRunKey = SharedDataKey.of(((Object)((Object)this)).getClass().getName(), AtomicBoolean.class);
    @Inject
    SharedData sharedData;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private volatile MavenSession mavenSession;
    @Parameter(property="cactus.verbose", defaultValue="false", alias="verbose")
    private boolean verbose;
    @Parameter(property="cactus.pretend", defaultValue="false", alias="pretend")
    private boolean pretend;
    protected BuildLog log;
    ThrowingOptional<ProjectTree> tree;
    private final RunPolicy policy;

    public final SharedData sharedData() {
        return this.sharedData;
    }

    boolean isRunning() {
        return this.running.get();
    }

    protected AutomergeTag automergeTag() {
        return this.sharedData().computeIfAbsent(AUTOMERGE_TAG_KEY, () -> new AutomergeTag(this.session()));
    }

    public final boolean isFirstRunInThisSession() {
        if (this.isRunning()) {
            Optional<AtomicBoolean> opt = this.sharedData().get(this.thisMojoWasRunKey);
            return !opt.isPresent() || !opt.get().get();
        }
        return false;
    }

    public final boolean wasRunInThisSession() {
        Optional<AtomicBoolean> opt = this.sharedData().get(this.thisMojoWasRunKey);
        return opt.isPresent() && opt.get().get();
    }

    protected static void quietly(ThrowingRunnable code) {
        code.toNonThrowing().run();
    }

    protected static <T> T quietly(ThrowingSupplier<T> code) {
        return code.asSupplier().get();
    }

    protected BaseMojo(RunPolicy policy) {
        this.policy = (RunPolicy)Checks.notNull((String)"policy", (Object)policy);
    }

    protected BaseMojo() {
        this(RunPolicies.EVERY);
    }

    protected BaseMojo(boolean oncePerSession) {
        this(oncePerSession ? RunPolicies.LAST_CONTAINING_GOAL : RunPolicies.FIRST);
    }

    protected boolean isPretend() {
        return this.pretend;
    }

    protected void ifNotPretending(ThrowingRunnable code) {
        if (!this.pretend) {
            code.toNonThrowing().run();
        }
    }

    public final String goal() {
        BaseMojoGoal bmg = ((Object)((Object)this)).getClass().getAnnotation(BaseMojoGoal.class);
        if (bmg != null) {
            return bmg.value();
        }
        this.log().error("Could not find a goal name in annotations on " + ((Object)((Object)this)).getClass().getName());
        return "";
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        AtomicBoolean run = this.sharedData().computeIfAbsent(this.thisMojoWasRunKey, AtomicBoolean::new);
        boolean old = this.running.get();
        try {
            this.running.set(true);
            if (this.policy.shouldRun(this, this.project)) {
                run.set(true);
                this.run((ThrowingBiConsumer<BuildLog, MavenProject>)((ThrowingBiConsumer)this::performTasks));
            } else {
                new BuildLog(((Object)((Object)this)).getClass()).info("Skipping " + ((Object)((Object)this)).getClass().getSimpleName() + " mojo per policy " + this.policy);
            }
        }
        finally {
            this.running.set(old);
        }
    }

    public <T> T fail(Object message) {
        String s = Objects.toString(message);
        return (T)Exceptions.chuck((Throwable)new MojoExecutionException((Object)this, s, s));
    }

    protected Runnable failingWith(String msg) {
        return () -> this.fail(msg);
    }

    protected ArtifactFetcher downloadArtifact(String groupId, String artifactId, String version) {
        return new ArtifactFetcher(groupId, artifactId, version, this.mavenSession);
    }

    protected ArtifactFetcher downloadArtifact(String groupId, String artifactId, String version, String classifier) {
        return new ArtifactFetcher(groupId, artifactId, version, this.mavenSession).withClassifier(classifier);
    }

    protected final BuildLog log() {
        if (this.log == null) {
            this.log = new BuildLog(((Object)((Object)this)).getClass());
        }
        return this.log;
    }

    protected abstract void performTasks(BuildLog var1, MavenProject var2) throws Exception;

    public final MavenProject project() {
        return this.project;
    }

    protected final ThrowingOptional<ProjectTree> projectTree(boolean invalidateCache) {
        return this.projectTreeInternal(invalidateCache);
    }

    protected final ThrowingOptional<ProjectTree> projectTree() {
        return this.projectTree(true);
    }

    protected RunPolicy runPolicy() {
        return this.policy;
    }

    public final MavenSession session() {
        return this.mavenSession;
    }

    protected void validateBranchName(String branchName, boolean nullOk) {
        if (branchName == null) {
            if (nullOk) {
                return;
            }
            this.fail("Branch name unset");
        } else if (branchName.isBlank() || branchName.contains(":") || branchName.startsWith("-") || branchName.contains(" ") || branchName.contains("\"") || branchName.contains("'")) {
            this.fail("Illegal branch name format: '" + branchName + "'");
        }
    }

    protected final boolean isVerbose() {
        return this.verbose;
    }

    protected final void ifVerbose(ThrowingRunnable run) throws Exception {
        if (this.isVerbose()) {
            run.run();
        }
    }

    protected void validateParameters(BuildLog log, MavenProject project) throws Exception {
    }

    protected final <T> ThrowingOptional<T> withProjectTree(ThrowingFunction<ProjectTree, T> func) {
        return this.projectTree().map(func);
    }

    protected final boolean withProjectTree(ThrowingConsumer<ProjectTree> cons) {
        return this.projectTree().ifPresent(cons);
    }

    protected final <T> ThrowingOptional<T> withProjectTree(boolean invalidateCache, ThrowingFunction<ProjectTree, T> func) {
        return this.projectTree(invalidateCache).map(func);
    }

    protected final boolean withProjectTree(boolean invalidateCache, ThrowingConsumer<ProjectTree> cons) {
        return this.projectTree(invalidateCache).ifPresent(cons);
    }

    void internalSubclassValidateParameters(BuildLog log, MavenProject project) throws Exception {
    }

    ThrowingOptional<ProjectTree> projectTreeInternal(boolean invalidateCache) {
        if (this.tree == null) {
            this.tree = ProjectTree.from(this.project());
        } else if (invalidateCache) {
            this.tree.ifPresent(ProjectTree::invalidateCache);
        }
        return this.tree;
    }

    private void internalValidateParameters(BuildLog log, MavenProject project) throws Exception {
        if (project == null) {
            throw new MojoFailureException("Project was not injected");
        }
        if (this.mavenSession == null) {
            throw new MojoFailureException("MavenSession was not injected");
        }
        if (this.sharedData == null) {
            this.fail("SharedData was not injected");
        }
        this.internalSubclassValidateParameters(log, project);
        this.validateParameters(log, project);
    }

    private void run(ThrowingBiConsumer<BuildLog, MavenProject> run) throws MojoExecutionException, MojoFailureException {
        try {
            BuildLog theLog = this.log();
            theLog.run(() -> {
                this.internalValidateParameters(theLog, this.project());
                run.accept((Object)theLog, (Object)this.project());
            });
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Error | Exception e) {
            Throwable t = e;
            if (e instanceof CompletionException && e.getCause() != null) {
                t = e.getCause();
            }
            if (e instanceof ExecutionException && e.getCause() != null) {
                t = e.getCause();
            }
            throw new MojoFailureException(t);
        }
    }

    protected boolean open(String uri) {
        try {
            URI u = new URI(uri);
            this.open(u);
            return true;
        }
        catch (URISyntaxException ex) {
            this.log().error("Invalid uri " + uri, (Throwable)ex);
            return false;
        }
    }

    protected void open(URI uri) {
        BuildLog log = this.log();
        if (Desktop.isDesktopSupported()) {
            log.info("Opening browser for " + uri);
            try {
                Desktop.getDesktop().browse(uri);
            }
            catch (IOException ex) {
                log.error("Exception thrown opening " + uri, (Throwable)ex);
            }
        } else {
            log.error("Desktop not supported in this JVM; cannot open " + uri);
        }
    }

    protected void usingArtifactFinder(ThrowingRunnable run) {
        new ArtifactFinderImpl().run(run.toNonThrowing());
    }

    protected final MavenCoordinates coordinatesOf(MavenProject project) {
        return new MavenCoordinates(((MavenProject)Checks.notNull((String)"project", (Object)project)).getGroupId(), project.getArtifactId(), project.getVersion());
    }

    protected final Pom toPom(MavenProject project) {
        return (Pom)Pom.from((Path)project.getFile().toPath()).get();
    }

    protected void emitMessage(Object message) {
        if (message != null) {
            for (String line : Objects.toString(message).split("\n")) {
                System.out.println("\u250b " + line);
            }
        }
    }

    protected static final class ArtifactFetcher {
        private String extension = "jar";
        private String repositoryUrl = "https://repo1.maven.org/maven2";
        private final String groupId;
        private final String artifactId;
        private final String version;
        private String classifier;
        private final BuildLog log;
        private final MavenSession session;

        private ArtifactFetcher(String groupId, String artifactId, String version, MavenSession session) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.log = BuildLog.get().child("fetch").child(groupId).child(artifactId).child(version);
            this.session = session;
        }

        public Path get() throws MojoFailureException {
            DefaultArtifact artifact = new DefaultArtifact((String)Checks.notNull((String)"groupId", (Object)this.groupId), (String)Checks.notNull((String)"artifactId", (Object)this.artifactId), this.classifier, (String)Checks.notNull((String)"type", (Object)this.extension), (String)Checks.notNull((String)"version", (Object)this.version));
            LocalArtifactRequest request = new LocalArtifactRequest();
            request.setArtifact((Artifact)artifact);
            RemoteRepository remoteRepo = new RemoteRepository.Builder("central", "x", this.repositoryUrl).build();
            request.setRepositories(Collections.singletonList(remoteRepo));
            RepositorySystemSession session = this.session.getRepositorySession();
            LocalArtifactResult result = session.getLocalRepositoryManager().find(session, request);
            this.log.info("Download result for " + (Artifact)artifact + ": " + result);
            if (result != null && result.getFile() != null) {
                this.log.info("Have local " + this.artifactId + " " + this.extension + " " + result.getFile());
                return result.getFile().toPath();
            }
            throw new MojoFailureException("Could not download " + (Artifact)artifact + " from " + remoteRepo.getUrl());
        }

        public ArtifactFetcher withRepositoryURL(String repositoryUrl) {
            try {
                new URL((String)Checks.notNull((String)"repoUrl", (Object)repositoryUrl));
            }
            catch (MalformedURLException ex) {
                this.log.error("Invalid repository URL '" + repositoryUrl);
                return (ArtifactFetcher)Exceptions.chuck((Throwable)new MojoExecutionException("Invalid repository URL '" + repositoryUrl + "'"));
            }
            this.repositoryUrl = repositoryUrl;
            return this;
        }

        public ArtifactFetcher withExtension(String extension) {
            this.extension = (String)Checks.notNull((String)"type", (Object)extension);
            return this;
        }

        public ArtifactFetcher withClassifier(String classifier) {
            this.classifier = (String)Checks.notNull((String)"type", (Object)classifier);
            return this;
        }
    }

    class ArtifactFinderImpl
    implements ArtifactFinder {
        ArtifactFinderImpl() {
        }

        public Optional<Path> find(String groupId, String artifactId, String version, String type) {
            ArtifactFetcher fetcher = new ArtifactFetcher(groupId, artifactId, version, BaseMojo.this.mavenSession);
            if (type != null) {
                fetcher.withExtension(type);
            }
            try {
                Path path = fetcher.get();
                return Optional.ofNullable(path);
            }
            catch (Error | Exception ex) {
                BaseMojo.this.log().error("Fetching " + groupId + ":" + artifactId + ":" + version, ex);
                return Optional.empty();
            }
        }
    }
}

