/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.mojobase;

import com.mastfrog.function.throwing.ThrowingConsumer;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.model.MavenIdentified;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.mojobase.FamilyAwareMojo;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.maven.trigger.RunPolicies;
import com.telenav.cactus.maven.trigger.RunPolicy;
import com.telenav.cactus.scope.ProjectFamily;
import com.telenav.cactus.scope.Scope;
import com.telenav.cactus.scope.Scoped;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class ScopeMojo
extends FamilyAwareMojo
implements Scoped {
    @Parameter(property="cactus.scope", defaultValue="family")
    private String scope;
    @Parameter(property="cactus.include-root", defaultValue="true")
    private boolean includeRoot;
    private Scope scopeValue;
    private GitCheckout myCheckout;

    protected ScopeMojo() {
        this(false);
    }

    public boolean isFamilyScope() {
        return this.scope().appliesFamily();
    }

    protected ScopeMojo(boolean runFirst) {
        super(runFirst ? RunPolicies.FIRST : RunPolicies.LAST_CONTAINING_GOAL);
    }

    protected ScopeMojo(RunPolicy policy) {
        super(policy);
    }

    protected abstract void execute(BuildLog var1, MavenProject var2, GitCheckout var3, Scope var4, Set<ProjectFamily> var5, boolean var6, boolean var7) throws Exception;

    protected final boolean isIncludeRoot() {
        return this.includeRoot;
    }

    protected void onValidateParameters(BuildLog log, MavenProject project) throws Exception {
    }

    @Override
    protected final void performTasks(BuildLog log, MavenProject project) throws Exception {
        this.execute(log, project, this.myCheckout, this.scopeValue, this.families(), this.includeRoot, this.isPretend());
    }

    public final Scope scope() {
        return this.scopeValue == null ? (this.scopeValue = Scope.find((String)this.scope)) : this.scopeValue;
    }

    @Override
    public Set<ProjectFamily> families() {
        switch (this.scope()) {
            case ALL: 
            case ALL_PROJECT_FAMILIES: {
                return (Set)this.withProjectTree(false, ProjectTree::allProjectFamilies).orElseGet(() -> super.families());
            }
            case JUST_THIS: 
            case SAME_GROUP_ID: {
                return Collections.singleton(ProjectFamily.fromGroupId((String)this.project().getGroupId()));
            }
            case FAMILY_OR_CHILD_FAMILY: {
                ProjectFamily mine = ProjectFamily.fromGroupId((String)this.project().getGroupId());
                HashSet<ProjectFamily> all = new HashSet<ProjectFamily>();
                this.withProjectTree(false, (ThrowingConsumer<ProjectTree>)((ThrowingConsumer)tree -> {
                    for (Pom pom : tree.allProjects()) {
                        mine.isParentFamilyOf((MavenIdentified)pom);
                        all.add(ProjectFamily.familyOf((MavenIdentified)pom));
                    }
                }));
                return all;
            }
        }
        return super.families();
    }

    @Override
    protected final void validateParameters(BuildLog log, MavenProject project) throws Exception {
        this.scopeValue = Scope.find((String)this.scope);
        Optional checkout = GitCheckout.checkout((File)project.getBasedir());
        if (checkout.isEmpty()) {
            throw new MojoExecutionException(project.getBasedir() + " does not seem to be part of a git checkout.");
        }
        this.myCheckout = (GitCheckout)checkout.get();
        this.onValidateParameters(log, project);
        if (!this.scopeValue.appliesFamily() && this.hasExplicitFamilies()) {
            log.warn("Useless assignment of telanav.family to '" + this.family + "' when using scope " + this.scopeValue + " which will not read it.  It is useful only with " + Scope.FAMILY + " and " + Scope.FAMILY_OR_CHILD_FAMILY);
        }
    }
}

