/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.mojobase;

import com.mastfrog.function.throwing.ThrowingConsumer;
import com.mastfrog.util.strings.Strings;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.commit.CommitMessage;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.mojobase.ScopeMojo;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.maven.trigger.RunPolicy;
import com.telenav.cactus.scope.ProjectFamily;
import com.telenav.cactus.scope.Scope;
import com.telenav.cactus.util.SectionedMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public abstract class ScopedCheckoutsMojo
extends ScopeMojo {
    protected ScopedCheckoutsMojo() {
    }

    protected ScopedCheckoutsMojo(boolean runFirst) {
        super(runFirst);
    }

    public ScopedCheckoutsMojo(RunPolicy policy) {
        super(policy);
    }

    protected abstract void execute(BuildLog var1, MavenProject var2, GitCheckout var3, ProjectTree var4, List<GitCheckout> var5) throws Exception;

    protected final CommitMessage addCommitMessageDetail(CommitMessage msg, Collection<? extends GitCheckout> checkouts) {
        return this.addCommitMessageDetail(msg, checkouts, Collections.emptySet());
    }

    protected final CommitMessage addCommitMessageDetail(CommitMessage msg, Collection<? extends GitCheckout> checkouts, Collection<? extends Pom> projects) {
        SectionedMessage.MessageSection sec;
        if (!projects.isEmpty()) {
            sec = msg.section("Affected Projects");
            try {
                projects.forEach(arg_0 -> ScopedCheckoutsMojo.lambda$addCommitMessageDetail$0((CommitMessage.Section)sec, arg_0));
            }
            finally {
                if (sec != null) {
                    sec.close();
                }
            }
        }
        if (!checkouts.isEmpty()) {
            sec = msg.section("Affected Checkouts");
            try {
                checkouts.forEach(arg_0 -> ScopedCheckoutsMojo.lambda$addCommitMessageDetail$1((CommitMessage.Section)sec, arg_0));
            }
            finally {
                if (sec != null) {
                    sec.close();
                }
            }
        }
        return msg;
    }

    protected boolean forbidsLocalModifications() {
        return false;
    }

    @Override
    protected final void execute(BuildLog log, MavenProject project, GitCheckout myCheckout, Scope scope, Set<ProjectFamily> families, boolean includeRoot, boolean pretend) throws Exception {
        this.withProjectTree(false, (ThrowingConsumer<ProjectTree>)((ThrowingConsumer)tree -> {
            List<GitCheckout> checkouts = tree.matchCheckouts(scope, myCheckout, includeRoot, families, project.getGroupId());
            log.ifDebug(() -> {
                log.debug("Operate on the following repositories for " + scope + ":");
                checkouts.forEach(co -> log.debug("  * " + co));
            });
            if (this.forbidsLocalModifications()) {
                this.checkLocallyModified(checkouts);
            }
            this.execute(log, project, myCheckout, (ProjectTree)tree, checkouts);
        }));
    }

    private void checkLocallyModified(Collection<? extends GitCheckout> coll) throws Exception {
        List modified = coll.stream().filter(GitCheckout::isDirty).collect(Collectors.toCollection(() -> new ArrayList(coll.size())));
        if (!modified.isEmpty()) {
            String message = "Some checkouts are locally modified:\n" + Strings.join((String)"\n  * ", (Iterable)modified);
            throw new MojoExecutionException((Object)this, message, message);
        }
    }

    private static /* synthetic */ void lambda$addCommitMessageDetail$1(CommitMessage.Section sec, GitCheckout checkout) {
        String nm = checkout.name().isEmpty() ? "(root)" : checkout.name();
        sec.bulletPoint(nm);
    }

    private static /* synthetic */ void lambda$addCommitMessageDetail$0(CommitMessage.Section sec, Pom pom) {
        sec.bulletPoint(pom.toArtifactIdentifiers().toString());
    }
}

