/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.mojobase;

import com.mastfrog.function.optional.ThrowingOptional;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import com.telenav.cactus.maven.shared.SharedDataKey;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.maven.trigger.RunPolicy;
import java.io.File;
import java.util.Optional;
import org.apache.maven.project.MavenProject;

public abstract class SharedProjectTreeMojo
extends BaseMojo {
    protected SharedProjectTreeMojo(RunPolicy policy) {
        super(policy);
    }

    protected SharedProjectTreeMojo() {
    }

    protected SharedProjectTreeMojo(boolean oncePerSession) {
        super(oncePerSession);
    }

    private SharedDataKey<TreeHolder> key() {
        if (this.session().getAllProjects().size() > 1) {
            MavenProject prj = this.project();
            Optional co = GitCheckout.checkout((File)prj.getBasedir());
            if (!co.isPresent()) {
                return TreeHolder.KEY;
            }
            ThrowingOptional subRoot = ((GitCheckout)co.get()).submoduleRoot();
            if (!subRoot.isPresent()) {
                return TreeHolder.KEY;
            }
            return SharedDataKey.of("tree_" + ((GitCheckout)subRoot.get()).checkoutRoot(), TreeHolder.class);
        }
        return TreeHolder.KEY;
    }

    @Override
    synchronized ThrowingOptional<ProjectTree> projectTreeInternal(boolean invalidateCache) {
        if (this.tree != null) {
            if (this.tree.isPresent() && invalidateCache) {
                ((ProjectTree)this.tree.get()).invalidateCache();
            }
            return this.tree;
        }
        TreeHolder holder = this.sharedData().computeIfAbsent(this.key(), () -> new TreeHolder(super.projectTreeInternal(false)));
        return holder.tree;
    }

    private static final class TreeHolder {
        private static final SharedDataKey<TreeHolder> KEY = SharedDataKey.of("///tree", TreeHolder.class);
        final ThrowingOptional<ProjectTree> tree;

        public TreeHolder(ThrowingOptional<ProjectTree> tree) {
            this.tree = tree;
        }
    }
}

