/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.shared;

import com.telenav.cactus.maven.shared.SharedDataKey;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.inject.Singleton;
import org.apache.maven.plugin.MojoFailureException;

@Singleton
public final class SharedData {
    private final Map<SharedDataKey<?>, Object> contents = new ConcurrentHashMap();

    public boolean has(SharedDataKey<?> key) {
        return this.contents.containsKey(key);
    }

    public void ensureHas(SharedDataKey<?> key, String message) throws MojoFailureException {
        if (!this.has(key)) {
            String msg = message + " Missing: " + key;
            throw new MojoFailureException((Object)this, msg, msg);
        }
    }

    public <T> SharedData put(SharedDataKey<T> key, T obj) {
        this.contents.put(key, obj);
        return this;
    }

    public <T> Optional<T> get(SharedDataKey<T> key) {
        return key.cast(this.contents.get(key));
    }

    public <T> Optional<T> remove(SharedDataKey<T> key) {
        return key.cast(this.contents.remove(key));
    }

    public <T> T computeIfAbsent(SharedDataKey<T> key, Supplier<T> supp) {
        Optional<T> result = this.get(key);
        if (!result.isPresent()) {
            T obj = supp.get();
            if (obj == null) {
                throw new IllegalArgumentException("Supplier returned null: " + supp);
            }
            this.put(key, obj);
            return obj;
        }
        return result.get();
    }
}

