/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.shared;

import com.mastfrog.util.preconditions.Checks;
import java.util.Optional;

public final class SharedDataKey<T> {
    private final Class<T> type;
    private final String name;

    SharedDataKey(Class<T> type, String name) {
        this.type = (Class)Checks.notNull((String)"type", type);
        this.name = (String)Checks.notNull((String)"name", (Object)name);
    }

    public static <T> SharedDataKey<T> of(String name, Class<? super T> type) {
        return new SharedDataKey<T>(type, name);
    }

    public static <T> SharedDataKey<T> of(Class<? super T> type) {
        return SharedDataKey.of(type.getName(), type);
    }

    public <R> Optional<T> cast(R obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (this.type.isInstance(obj)) {
            return Optional.of(this.type.cast(obj));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != SharedDataKey.class) {
            return false;
        }
        SharedDataKey k = (SharedDataKey)o;
        return k.type == this.type && this.name.equals(k.name);
    }

    public int hashCode() {
        return this.name.hashCode() + 3 * this.type.hashCode();
    }

    public String toString() {
        return this.name + "(" + this.type.getSimpleName() + ")";
    }
}

