/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.topologize;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.graph.IntGraph;
import com.mastfrog.graph.IntGraphBuilder;
import com.mastfrog.graph.ObjectGraph;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.graph.DependencyGraphBuilder;
import com.telenav.cactus.graph.DependencyGraphs;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.model.MavenArtifactCoordinates;
import com.telenav.cactus.maven.model.MavenCoordinates;
import com.telenav.cactus.maven.model.MavenIdentified;
import com.telenav.cactus.maven.model.MavenModule;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.resolver.Poms;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class Topologizer {
    final Poms poms;
    private final GitCheckout root;
    private final BuildLog log;
    private DependencyGraphs graphs;
    private ObjectGraph<MavenCoordinates> graph;
    private ObjectGraph<MavenCoordinates> mergedGraph;
    private ObjectGraph<MavenCoordinates> ownershipGraph;

    public Topologizer(GitCheckout someCheckout, BuildLog log) throws IOException {
        this.root = (GitCheckout)someCheckout.submoduleRoot().orElse((Object)someCheckout);
        this.poms = Poms.in((Path)someCheckout.checkoutRoot(), (Path[])new Path[0]);
        this.log = log.child("topology");
    }

    public Poms poms() {
        return this.poms;
    }

    public static void main(String[] args) throws IOException {
        GitCheckout checkout = (GitCheckout)GitCheckout.checkout((Path)Paths.get("/Users/timb/work/telenav/jonstuff", new String[0])).get();
        BuildLog bl = BuildLog.get();
        Topologizer topo = new Topologizer(checkout, bl);
        for (Pom p : topo.poms) {
            if (!p.isAggregator()) continue;
            List<String> sorted = topo.topologicallySortedModules(p);
            System.out.println("\n-------\nSORTED MODULES OF " + p.toArtifactIdentifiers());
            for (String s : sorted) {
                System.out.println("    <module>" + s + "</module>");
            }
        }
    }

    public <C extends MavenArtifactCoordinates> List<String> topologicallySortedModules(C coords) throws IOException {
        ThrowingOptional pomOpts = this.poms.get(coords.groupId(), coords.artifactId());
        if (!pomOpts.isPresent()) {
            return Collections.emptyList();
        }
        Pom pom = (Pom)pomOpts.get();
        HashSet<MavenCoordinates> modules = new HashSet<MavenCoordinates>();
        ObjectGraph<MavenCoordinates> cg = this.mergedGraph();
        HashSet<MavenCoordinates> inGraph = new HashSet<MavenCoordinates>();
        for (int i = 0; i < cg.size(); ++i) {
            inGraph.add((MavenCoordinates)cg.toNode(i));
        }
        for (MavenModule mod : pom.modules()) {
            Pom childPom = (Pom)mod.toPom().get();
            MavenCoordinates mc = childPom.coordinates();
            if (!inGraph.contains(mc)) continue;
            modules.add(mc);
        }
        List sorted = cg.topologicalSort(modules);
        ArrayList<String> result = new ArrayList<String>();
        for (MavenCoordinates mc : sorted) {
            Pom p = (Pom)this.poms.get((MavenIdentified)mc).get();
            result.add(p.projectFolder().getFileName().toString());
        }
        Collections.reverse(result);
        return result;
    }

    private ObjectGraph<MavenCoordinates> mergedGraph() throws IOException {
        if (this.mergedGraph != null) {
            return this.mergedGraph;
        }
        return (ObjectGraph)this.log.benchmark("Merged dependency graph creation", () -> {
            this.mergedGraph = this._mergedGraph();
            return this.mergedGraph;
        });
    }

    private ObjectGraph<MavenCoordinates> _mergedGraph() throws IOException {
        MavenCoordinates coords;
        int i;
        HashSet<MavenCoordinates> allNodes = new HashSet<MavenCoordinates>();
        ObjectGraph<MavenCoordinates> modulesGraph = this.ownershipGraph();
        ObjectGraph<MavenCoordinates> dependencyGraph = this.graph();
        this.log.debug(() -> "\n\nDEPENDENCY GRAPH:\n" + dependencyGraph);
        HashSet<MavenCoordinates> graphNodes = new HashSet<MavenCoordinates>();
        for (i = 0; i < dependencyGraph.size(); ++i) {
            coords = (MavenCoordinates)dependencyGraph.toNode(i);
            graphNodes.add(coords);
            allNodes.add(coords);
        }
        this.log.debug(() -> "\n\nOWNERSHIP GRAPH:\n" + modulesGraph);
        for (i = 0; i < modulesGraph.size(); ++i) {
            coords = (MavenCoordinates)modulesGraph.toNode(i);
            allNodes.add(coords);
        }
        ArrayList coords2 = new ArrayList(allNodes);
        IntGraphBuilder igb = IntGraph.builder((int)coords2.size());
        for (int i2 = 0; i2 < coords2.size(); ++i2) {
            int index = i2;
            MavenCoordinates c = (MavenCoordinates)coords2.get(i2);
            ThrowingOptional po = this.poms.get((MavenIdentified)c);
            if (!po.isPresent()) continue;
            Pom p = (Pom)po.get();
            p.parent().ifPresent(par -> this.poms.get((MavenIdentified)par).ifPresent(pp -> {
                int pix = coords2.indexOf(pp.coordinates());
                igb.addEdge(index, pix);
            }));
            p.modules().forEach(module -> module.toPom().ifPresent(modulePom -> {
                int moduleIx = coords2.indexOf(modulePom.coordinates());
                igb.addEdge(index, moduleIx);
            }));
            if (!graphNodes.contains(c)) continue;
            for (MavenCoordinates child : dependencyGraph.children((Object)c)) {
                int cix = coords2.indexOf(child);
                igb.addEdge(i2, cix);
                modulesGraph.parents((Object)child).forEach(parent -> {
                    if (modulesGraph.topLevelOrOrphanNodes().contains(parent)) {
                        return;
                    }
                    this.poms.get((MavenIdentified)parent).ifPresent(ancestorPom -> {
                        int ancestorIx = coords2.indexOf(ancestorPom.coordinates());
                        this.log.debug(() -> "Synthesize dependency " + p.artifactId() + " on " + parent.artifactId());
                        igb.addEdge(index, ancestorIx);
                    });
                });
            }
        }
        IntGraph mergedIntGraph = igb.build();
        this.mergedGraph = mergedIntGraph.toObjectGraph(coords2);
        this.log.debug(() -> "\n\nMERGED GRAPH\n" + this.mergedGraph);
        return this.mergedGraph;
    }

    private DependencyGraphs graphs() {
        return this.graphs == null ? (this.graphs = new DependencyGraphs(this.poms)) : this.graphs;
    }

    public ObjectGraph<MavenCoordinates> ownershipGraph() throws IOException {
        if (this.ownershipGraph != null) {
            return this.ownershipGraph;
        }
        this.ownershipGraph = (ObjectGraph)this.log.benchmark("Project Module Graph Creation", () -> this.graphs().ownership());
        return this.ownershipGraph;
    }

    public ObjectGraph<MavenCoordinates> graph() throws IOException {
        if (this.graph != null) {
            return this.graph;
        }
        HashSet groupIds = new HashSet();
        HashSet allCoords = new HashSet();
        this.poms.forEach(pom -> {
            groupIds.add(pom.groupId());
            allCoords.add(pom.coordinates());
        });
        this.graph = (ObjectGraph)this.log.benchmark("Dependency Graph Creation", () -> DependencyGraphBuilder.dependencyGraphBuilder().withPostFilter(coords -> groupIds.contains(coords.groupId()) && allCoords.contains(coords)).scanningFolder(this.root.checkoutRoot()).graphingAllJavaAndPomProjects().build());
        return this.graph;
    }
}

