/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.tree;

import com.mastfrog.function.optional.ThrowingOptional;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.log.BuildLog;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.tree.Inconsistency;
import com.telenav.cactus.maven.tree.ProjectTree;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.project.MavenProject;

public class ConsistencyChecker {
    public static final String ON_BRANCH = "on-branch";
    public static final String DETACHED = "detached";
    public static final String CLEAN = "clean";
    public static final String DIRTY = "dirty";
    private final Set<String> ignoreInBranchConsistencyCheck;
    private final Set<String> ignoreInVersionConsistencyCheck;
    private final String targetGroupId;
    private final boolean forbidDirty;

    public ConsistencyChecker(String ignoreInBranchConsistencyCheckCommaOrSpaceDelimitedList, String ignoreInVersionConsistencyCheckCommaOrSpaceDelimitedList, String targetGroupId, boolean forbidDirty) {
        this.ignoreInBranchConsistencyCheck = ConsistencyChecker.splitToSet(ignoreInBranchConsistencyCheckCommaOrSpaceDelimitedList);
        this.ignoreInVersionConsistencyCheck = ConsistencyChecker.splitToSet(ignoreInVersionConsistencyCheckCommaOrSpaceDelimitedList);
        this.targetGroupId = targetGroupId;
        this.forbidDirty = forbidDirty;
    }

    public ConsistencyChecker() {
        this(null, null, null, false);
    }

    public Set<Inconsistency<?>> checkBranchConsistency(ProjectTree tree, MavenProject project, BuildLog log) {
        HashSet branchInconsistencies = new HashSet();
        this.checkBranchConsistency(tree, project, log, branchInconsistencies);
        return branchInconsistencies;
    }

    public Set<Inconsistency<?>> checkConsistency(MavenProject project, BuildLog log) throws Exception {
        log = log.child("consistency");
        ThrowingOptional<ProjectTree> treeOpt = ProjectTree.from(project.getBasedir().toPath());
        return this.checkConsistency(project, log, treeOpt);
    }

    public Set<Inconsistency<?>> checkConsistency(MavenProject project, BuildLog log, ThrowingOptional<ProjectTree> treeOpt) throws Exception {
        if (!treeOpt.isPresent()) {
            log.child("checkConsistency").error("Could not find a project tree for " + project.getBasedir());
            return Collections.emptySet();
        }
        LinkedHashSet result = new LinkedHashSet();
        this.checkBranchConsistency((ProjectTree)treeOpt.get(), project, log.child("branch"), result);
        this.checkVersionConsistency((ProjectTree)treeOpt.get(), project, log.child("versions"), result);
        this.checkDirtyAndDetached((ProjectTree)treeOpt.get(), project, log.child(DIRTY), result, this.forbidDirty);
        return result;
    }

    public Set<Inconsistency<?>> checkDetached(ProjectTree tree, MavenProject project, BuildLog log) {
        HashSet result = new HashSet();
        this.checkDirtyAndDetached(tree, project, log, result, false);
        return result;
    }

    public ConsistencyChecker forbiddingDirty() {
        return new ConsistencyChecker(ConsistencyChecker.toString(this.ignoreInBranchConsistencyCheck), ConsistencyChecker.toString(this.ignoreInVersionConsistencyCheck), this.targetGroupId, true);
    }

    public ConsistencyChecker onlyCheckingGroupId(String targetGroupId) {
        if (this.targetGroupId != null) {
            throw new IllegalStateException("Target group id already set to " + this.targetGroupId + " - cannot set to " + targetGroupId);
        }
        return new ConsistencyChecker(ConsistencyChecker.toString(this.ignoreInBranchConsistencyCheck), ConsistencyChecker.toString(this.ignoreInVersionConsistencyCheck), targetGroupId, this.forbidDirty);
    }

    public ConsistencyChecker withIgnoreBranchConsistencySuffixes(String commaOrSpaceDelimitedList) {
        if (!this.ignoreInBranchConsistencyCheck.isEmpty()) {
            throw new IllegalStateException("Ignore in branches check is already set to " + this.ignoreInVersionConsistencyCheck + " - cannot set to " + commaOrSpaceDelimitedList);
        }
        return new ConsistencyChecker(commaOrSpaceDelimitedList, ConsistencyChecker.toString(this.ignoreInVersionConsistencyCheck), this.targetGroupId, this.forbidDirty);
    }

    public ConsistencyChecker withIgnoreVersionConsistencySuffixes(String commaOrSpaceDelimitedList) {
        if (!this.ignoreInVersionConsistencyCheck.isEmpty()) {
            throw new IllegalStateException("Ignore in versions check is already set to " + this.ignoreInVersionConsistencyCheck + " - cannot set to " + commaOrSpaceDelimitedList);
        }
        return new ConsistencyChecker(ConsistencyChecker.toString(this.ignoreInBranchConsistencyCheck), commaOrSpaceDelimitedList, this.targetGroupId, this.forbidDirty);
    }

    private static Set<String> splitToSet(String what) {
        if (what == null || what.isBlank()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String item : what.split("[,\\s]+")) {
            if (item.isEmpty()) continue;
            result.add(item.trim());
        }
        return result;
    }

    private static String toString(Set<String> what) {
        if (what.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : what) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private void checkBranchConsistency(ProjectTree tree, MavenProject project, BuildLog log, Set<Inconsistency<?>> into) {
        log.info("Checking consistency of branches" + (String)(this.targetGroupId == null ? "" : " for projects with the group id " + this.targetGroupId));
        Map<String, Map<String, Set<Pom>>> found = tree.projectsByBranchByGroupId(this::isVersionRequiredToBeConsistent);
        found.forEach((groupId, pomInfosForBranch) -> {
            if (pomInfosForBranch.size() > 1) {
                Inconsistency<Pom> issue = new Inconsistency<Pom>((Map<String, Set<Pom>>)pomInfosForBranch, Inconsistency.Kind.BRANCH, Pom::projectFolder);
                into.add(issue);
            }
        });
    }

    private void checkDirtyAndDetached(ProjectTree tree, MavenProject project, BuildLog log, Set<? super Inconsistency<?>> into, boolean forbidDirty) {
        log.info("Checking for detached-head checkouts" + (String)(this.targetGroupId == null ? "" : " for projects with the group id " + this.targetGroupId));
        log.info("Checking for dirty checkouts" + (String)(this.targetGroupId == null ? "" : " for projects with the group id " + this.targetGroupId));
        HashMap dirtyNotDirty = new HashMap();
        HashMap detachedNotDetached = new HashMap();
        for (GitCheckout checkout : tree.allCheckouts()) {
            if (!this.isRelevantCheckout(tree, checkout)) continue;
            if (forbidDirty) {
                String cleanDirtyKey = tree.isDirty(checkout) ? DIRTY : CLEAN;
                Set checkouts = dirtyNotDirty.computeIfAbsent(cleanDirtyKey, k -> new TreeSet());
                checkouts.add(checkout);
            }
            String detachedKey = checkout.isDetachedHead() ? DETACHED : ON_BRANCH;
            Set detachedCheckouts = detachedNotDetached.computeIfAbsent(detachedKey, k -> new TreeSet());
            detachedCheckouts.add(checkout);
        }
        if (dirtyNotDirty.containsKey(DIRTY)) {
            into.add(new Inconsistency<GitCheckout>(dirtyNotDirty, Inconsistency.Kind.CONTAINS_MODIFIED_SOURCES, GitCheckout::checkoutRoot));
        }
        if (detachedNotDetached.containsKey(DETACHED)) {
            into.add(new Inconsistency<GitCheckout>(detachedNotDetached, Inconsistency.Kind.NOT_ON_A_BRANCH, GitCheckout::checkoutRoot));
        }
    }

    private void checkVersionConsistency(ProjectTree tree, MavenProject project, BuildLog log, Set<? super Inconsistency<?>> into) {
        log.info("Checking consistency of versions" + (String)(this.targetGroupId == null ? "" : " for projects with the group id " + this.targetGroupId));
        Map projectsByVersion = tree.projectsByVersion(this::isVersionRequiredToBeConsistent);
        if (projectsByVersion.size() > 1) {
            into.add(new Inconsistency<Pom>(projectsByVersion, Inconsistency.Kind.VERSION, Pom::projectFolder));
        }
    }

    private boolean isRelevantCheckout(ProjectTree tree, GitCheckout checkout) {
        boolean result = this.isRelevantCheckout(checkout);
        if (result && this.targetGroupId != null) {
            boolean found = false;
            for (Pom pom : tree.allProjects()) {
                GitCheckout co = (GitCheckout)GitCheckout.checkout((Path)pom.path()).get();
                if (!co.equals((Object)checkout) || !pom.groupId().is(this.targetGroupId)) continue;
                found = true;
                break;
            }
            if (!found) {
                result = false;
            }
        }
        return result;
    }

    private boolean isRelevantCheckout(GitCheckout checkout) {
        Pom info;
        if (!Files.exists(checkout.checkoutRoot().resolve("pom.xml"), new LinkOption[0])) {
            return false;
        }
        if (this.targetGroupId != null && !this.targetGroupId.equals((info = (Pom)Pom.from((Path)checkout.checkoutRoot().resolve("pom.xml")).get()).groupId())) {
            return false;
        }
        HashSet<String> names = new HashSet<String>();
        names.add(checkout.checkoutRoot().getFileName().toString());
        names.addAll(checkout.remoteProjectNames());
        for (String name : names) {
            for (String suffix : this.ignoreInBranchConsistencyCheck) {
                if (!name.endsWith(suffix) && !name.equals(suffix)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isVersionRequiredToBeConsistent(Pom info) {
        if (this.targetGroupId != null && !this.targetGroupId.equals(info.groupId().text())) {
            return false;
        }
        return this.ignoreInVersionConsistencyCheck.contains(info.artifactId().text());
    }
}

