/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.tree;

import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.git.Branches;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenIdentified;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.VersionFlavor;
import com.telenav.cactus.maven.model.resolver.Poms;
import com.telenav.cactus.maven.refactoring.PomCategorizer;
import com.telenav.cactus.maven.refactoring.PomRole;
import com.telenav.cactus.maven.tree.ParentRelativePathChecker;
import com.telenav.cactus.maven.tree.Problem;
import com.telenav.cactus.maven.tree.Problems;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.scope.ProjectFamily;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ConsistencyChecker2 {
    private boolean checkRemoteModifications;
    private boolean checkFamilies;
    private boolean checkRoles;
    private boolean checkVersions;
    private boolean checkDetached;
    private boolean checkBranches;
    private boolean checkRelativePaths;
    private boolean checkLocalModifications;
    private VersionFlavor versionFlavor;
    private final Set<ProjectFamily> familiesToCheck = new HashSet<ProjectFamily>();
    private Predicate<GitCheckout> checkoutsFilter = _ignored -> true;
    private Consumer<String> activityLogger = System.out::println;
    private final Set<ProjectFamily> tolerateVersionInconsistenciesIn = new HashSet<ProjectFamily>();
    private String targetBranch;

    public ConsistencyChecker2 allChecks() {
        this.checkRemoteModifications = true;
        this.checkLocalModifications = true;
        this.checkRelativePaths = true;
        this.checkBranches = true;
        this.checkDetached = true;
        this.checkVersions = true;
        this.checkRelativePaths = true;
        this.checkFamilies = true;
        return this;
    }

    public ConsistencyChecker2 tolerateVersionInconsistenciesIn(ProjectFamily fam) {
        this.tolerateVersionInconsistenciesIn.add(fam);
        return this;
    }

    public ConsistencyChecker2 tolerateVersionInconsistenciesIn(Collection<? extends ProjectFamily> c) {
        this.tolerateVersionInconsistenciesIn.addAll(c);
        return this;
    }

    public ConsistencyChecker2 enforceVersionFlavor(VersionFlavor versionFlavor) {
        this.versionFlavor = versionFlavor;
        return this;
    }

    public ConsistencyChecker2 quiet() {
        this.activityLogger = s -> {};
        return this;
    }

    public ConsistencyChecker2 activityLogger(Consumer<String> log) {
        this.activityLogger = log;
        return this;
    }

    public ConsistencyChecker2 checkingRepositories(Collection<? extends GitCheckout> all) {
        HashSet<? extends GitCheckout> ch = new HashSet<GitCheckout>(all);
        this.checkoutsFilter = this.checkoutsFilter.and(ch::contains);
        return this;
    }

    public ConsistencyChecker2 checkingRepositories(Predicate<GitCheckout> test) {
        this.checkoutsFilter = this.checkoutsFilter.and((Predicate)Checks.notNull((String)"test", test));
        return this;
    }

    public ConsistencyChecker2 checkFamily(ProjectFamily family) {
        this.familiesToCheck.add((ProjectFamily)Checks.notNull((String)"family", (Object)family));
        return this;
    }

    public ConsistencyChecker2 checkFamilies(Iterable<? extends ProjectFamily> it) {
        ((Iterable)Checks.notNull((String)"it", it)).forEach(this::checkFamily);
        return this;
    }

    public ConsistencyChecker2 checkRemoteModifications() {
        this.checkRemoteModifications = true;
        return this;
    }

    public ConsistencyChecker2 checkLocalModifications() {
        this.checkLocalModifications = true;
        return this;
    }

    public ConsistencyChecker2 checkFamilies() {
        this.checkFamilies = true;
        return this;
    }

    public ConsistencyChecker2 checkRoles() {
        this.checkRoles = true;
        return this;
    }

    public ConsistencyChecker2 checkVersions() {
        this.checkVersions = true;
        return this;
    }

    public ConsistencyChecker2 checkDetached() {
        this.checkDetached = true;
        return this;
    }

    public ConsistencyChecker2 checkBranches() {
        this.checkBranches = true;
        return this;
    }

    public ConsistencyChecker2 checkRelativePaths() {
        this.checkRelativePaths = true;
        return this;
    }

    public Problems check(ProjectTree tree) {
        return new Checker(this.checkFamilies, this.checkRoles, this.checkVersions, this.checkDetached, this.checkBranches, this.checkRelativePaths, this.checkLocalModifications, this.checkRemoteModifications, this.familiesToCheck, this.checkoutsFilter, tree, this.activityLogger, this.targetBranch, this.tolerateVersionInconsistenciesIn, this.versionFlavor).check();
    }

    private Predicate<? super Pom> familyFilter() {
        Predicate<Pom> familyFilter;
        if (this.familiesToCheck.isEmpty()) {
            familyFilter = _ignored -> true;
        } else {
            HashSet<ProjectFamily> defensiveCopy = new HashSet<ProjectFamily>(this.familiesToCheck);
            familyFilter = pom -> {
                ProjectFamily fam = ProjectFamily.familyOf((MavenIdentified)pom);
                boolean result = defensiveCopy.contains(fam);
                if (!result) {
                    for (ProjectFamily projectFamily : defensiveCopy) {
                    }
                }
                return result;
            };
        }
        return familyFilter;
    }

    public ConsistencyChecker2 withTargetBranch(String targetBranch) {
        this.targetBranch = targetBranch;
        return this;
    }

    private static final class Checker {
        private final boolean checkFamilies;
        private final boolean checkRoles;
        private final boolean checkVersions;
        private final boolean checkDetached;
        private final boolean checkBranches;
        private final boolean checkRelativePaths;
        private final boolean checkLocalModifications;
        private final boolean checkRemoteModifications;
        private final Predicate<? super ProjectFamily> familiesToCheck;
        private final Predicate<? super GitCheckout> reposFilter;
        private final ProjectTree tree;
        private final Set<ProjectFamily> tolerateVersionInconsistenciesIn;
        private Poms poms;
        private PomCategorizer categorizer;
        private Map<ProjectFamily, PomVersion> versionsForFamilies;
        private final Consumer<String> log;
        private Set<GitCheckout> checkoutsContainingSuperpoms;
        private final String targetBranch;
        private final Set<ProjectFamily> includeFamilies;
        private final VersionFlavor versionFlavor;

        public Checker(boolean checkFamilies, boolean checkRoles, boolean checkVersions, boolean checkDetached, boolean checkBranches, boolean checkRelativePaths, boolean checkLocalModifications, boolean checkRemoteModifications, Set<ProjectFamily> includeFamilies, Predicate<? super GitCheckout> reposFilter, ProjectTree tree, Consumer<String> log, String targetBranch, Set<ProjectFamily> tolerateVersionInconsistenciesIn, VersionFlavor versionFlavor) {
            this.checkFamilies = checkFamilies;
            this.checkRoles = checkRoles;
            this.checkVersions = checkVersions;
            this.checkDetached = checkDetached;
            this.checkBranches = checkBranches;
            this.checkRelativePaths = checkRelativePaths;
            this.checkLocalModifications = checkLocalModifications;
            this.includeFamilies = new HashSet<ProjectFamily>(includeFamilies);
            this.reposFilter = reposFilter;
            this.checkRemoteModifications = checkRemoteModifications;
            this.tree = tree;
            this.log = log;
            this.targetBranch = targetBranch;
            this.tolerateVersionInconsistenciesIn = new HashSet<ProjectFamily>(tolerateVersionInconsistenciesIn);
            this.familiesToCheck = this.filter();
            this.versionFlavor = versionFlavor;
        }

        private Predicate<ProjectFamily> filter() {
            if (this.includeFamilies.isEmpty()) {
                return _ignored -> true;
            }
            return new Predicate<ProjectFamily>(){
                private final Set<ProjectFamily> parentFamilies = new HashSet<ProjectFamily>();

                synchronized Set<ProjectFamily> parentFamilies() {
                    if (this.parentFamilies.isEmpty()) {
                        tree.allProjects().forEach(pom -> {
                            if (includeFamilies.contains(ProjectFamily.familyOf((MavenIdentified)pom))) {
                                pom.groupId().parentGroupId().ifPresent(par -> this.parentFamilies.add(ProjectFamily.familyOf((GroupId)par)));
                            }
                        });
                    }
                    return this.parentFamilies;
                }

                @Override
                public boolean test(ProjectFamily t) {
                    if (includeFamilies.contains(t)) {
                        return true;
                    }
                    return this.parentFamilies().contains(t);
                }
            };
        }

        private void log(String what) {
            this.log.accept(what);
        }

        public Problems check() {
            Problems result = new Problems();
            if (this.checkRoles) {
                this.log("Checking roles");
                this.checkRoles(result);
            }
            if (this.checkVersions) {
                this.log("Checking versions");
                this.checkVersions(result);
            }
            if (this.checkRelativePaths) {
                this.log("Checking relative paths");
                ParentRelativePathChecker checker = new ParentRelativePathChecker();
                for (Pom pom : this.poms().poms()) {
                    checker.check(pom).ifPresent(result::add);
                }
            }
            if (this.checkFamilies) {
                this.log("Checking families within checkouts");
                this.checkFamilies(result);
            }
            if (this.checkLocalModifications) {
                this.log("Checking local modifications");
                this.checkLocalModifications(result);
            }
            if (this.checkDetached) {
                this.log("Checking detached head");
                this.checkDetachedHead(result);
            }
            if (this.checkBranches) {
                this.log("Checking branch consistency");
                this.checkBranches(result);
            }
            if (this.checkRemoteModifications) {
                this.log("Checking for un-pulled remote changes");
                this.checkRemoteModifications(result);
            }
            if (this.versionFlavor != null) {
                this.log("Checking that version flavor is " + this.versionFlavor);
                this.checkVersionFlavor(result);
            }
            return result;
        }

        private Set<GitCheckout> checkoutsContainingSuperpoms() {
            if (this.checkoutsContainingSuperpoms != null) {
                return this.checkoutsContainingSuperpoms;
            }
            PomCategorizer fullCat = new PomCategorizer(new Poms(this.tree.allProjects()));
            this.checkoutsContainingSuperpoms = new HashSet<GitCheckout>();
            block0: for (GitCheckout checkout : this.tree.allCheckouts()) {
                for (Pom p : this.tree.projectsWithin(checkout)) {
                    if (!fullCat.is(p, PomRole.CONFIG_ROOT)) continue;
                    this.checkoutsContainingSuperpoms.add(checkout);
                    continue block0;
                }
            }
            return this.checkoutsContainingSuperpoms;
        }

        private void checkRemoteModifications(Problems into) {
            TreeSet<GitCheckout> checkouts = new TreeSet<GitCheckout>();
            for (Pom pom : this.poms.poms()) {
                GitCheckout co = this.tree.checkoutFor(pom);
                if (co == null) continue;
                checkouts.add(co);
            }
            for (GitCheckout co : checkouts) {
                co.updateRemoteHeads();
                if (!co.needsPull()) continue;
                into.add("Remote changes exist for " + co.loggingName() + " which have not been pulled into " + co.checkoutRoot());
            }
        }

        private void checkBranches(Problems into) {
            HashSet<GitCheckout> seen = new HashSet<GitCheckout>();
            Set<GitCheckout> containingSuperpoms = this.checkoutsContainingSuperpoms();
            HashMap<ProjectFamily, Set> branchForCheckout = new HashMap<ProjectFamily, Set>();
            HashMap checkoutsForBranchName = new HashMap();
            for (Pom pom : this.poms().poms()) {
                GitCheckout co = this.tree.checkoutFor(pom);
                if (containingSuperpoms.contains(co) || !seen.add(co)) continue;
                this.tree.branches(co).currentBranch().ifPresent(branch -> {
                    ProjectFamily fam = ProjectFamily.familyOf((MavenIdentified)pom);
                    Set all = branchForCheckout.computeIfAbsent(fam, f -> new HashSet());
                    all.add(branch);
                    Set set = checkoutsForBranchName.computeIfAbsent(branch, b -> new TreeSet());
                    set.add(co);
                });
            }
            branchForCheckout.forEach((family, branches) -> {
                this.log("Branches for family " + family + ": " + branches);
                if (branches.size() > 1) {
                    StringBuilder sb = new StringBuilder("Family " + family + " has checkouts on heterogenous branches:");
                    for (Branches.Branch b : branches) {
                        boolean emitted = false;
                        for (GitCheckout co : (Set)checkoutsForBranchName.get(b)) {
                            if (!this.tree.checkoutsInProjectFamily((ProjectFamily)family).contains(co)) continue;
                            if (!emitted) {
                                sb.append("\n  * ").append(b);
                                emitted = true;
                            }
                            sb.append("\n    * ").append(co.loggingName());
                        }
                    }
                    into.add(sb.toString());
                } else if (this.targetBranch != null) {
                    for (Branches.Branch b : branches) {
                        if (b.name().equals(this.targetBranch)) continue;
                        StringBuilder sb = new StringBuilder("All checkouts in family ").append(family).append(" are not on the target branch '").append(this.targetBranch).append('\'');
                        for (GitCheckout co : (Set)checkoutsForBranchName.get(b)) {
                            sb.append("\n    * ").append(co.loggingName()).append(" is on branch ").append(b);
                        }
                        into.add(sb.toString());
                    }
                }
            });
        }

        private void checkFamilies(Problems into) {
            HashMap<GitCheckout, Set> familiesIn = new HashMap<GitCheckout, Set>();
            Set<GitCheckout> containingSuperpoms = this.checkoutsContainingSuperpoms();
            boolean haveProblems = false;
            for (Pom pom : this.poms.poms()) {
                GitCheckout co = this.tree.checkoutFor(pom);
                if (containingSuperpoms.contains(co)) continue;
                Set fams = familiesIn.computeIfAbsent(co, c -> new HashSet());
                fams.add(ProjectFamily.familyOf((MavenIdentified)pom));
                haveProblems |= fams.size() > 1;
            }
            if (haveProblems) {
                familiesIn.forEach((checkout, families) -> {
                    if (families.size() > 1) {
                        into.add("Checkout is not a superpom set, but contains more than one family: " + families + " in " + checkout.loggingName() + " @ " + checkout.checkoutRoot());
                    }
                });
            }
        }

        private void checkLocalModifications(Problems into) {
            HashSet<GitCheckout> seen = new HashSet<GitCheckout>();
            for (Pom pom : this.poms().poms()) {
                GitCheckout co = this.tree.checkoutFor(pom);
                if (co == null || !seen.add(co) || co.equals((Object)this.tree.root()) || !this.tree.isDirty(co)) continue;
                into.add("Have local modifications in " + co.loggingName() + ": " + co.checkoutRoot());
            }
        }

        private void checkDetachedHead(Problems into) {
            HashSet<GitCheckout> seen = new HashSet<GitCheckout>();
            for (Pom pom : this.poms().poms()) {
                GitCheckout co = this.tree.checkoutFor(pom);
                if (!seen.add(co) || this.tree.branches(co).currentBranch().isPresent()) continue;
                into.add("Have detached head state in " + co.loggingName() + ": " + co.checkoutRoot());
            }
        }

        private void checkVersions(Problems into) {
            Map<ProjectFamily, PomVersion> versForFamily = this.versionsForFamilies();
            versForFamily.forEach((f, v) -> this.log("Version for family " + f + ": " + v));
            HashMap<ProjectFamily, Map> inconsistencies = new HashMap<ProjectFamily, Map>();
            for (Pom pom : this.poms().poms()) {
                Set roles;
                PomVersion ver;
                ProjectFamily fam2;
                if (pom.projectFolder().equals(this.tree.root().checkoutRoot()) || !this.includeFamilies.contains(fam2 = ProjectFamily.familyOf((MavenIdentified)pom)) || Objects.equals(ver = versForFamily.get(fam2), pom.version()) || !(roles = this.categorizer().rolesFor(pom)).contains(PomRole.JAVA) && (roles.contains(PomRole.CONFIG) || roles.contains(PomRole.CONFIG_ROOT))) continue;
                Map ics2 = inconsistencies.computeIfAbsent(fam2, f -> new TreeMap());
                Set poms = ics2.computeIfAbsent(pom.version(), v -> new TreeSet());
                poms.add(pom);
            }
            if (!inconsistencies.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                inconsistencies.forEach((fam, ics) -> {
                    if (sb.length() > 0) {
                        sb.append("\n\n");
                    }
                    sb.append("Versions in family '").append(fam).append("' are inconsistent - expecting ").append(versForFamily.get(fam));
                    ics.forEach((ver, poms) -> {
                        sb.append("\n  * ").append(ver);
                        poms.forEach(pom -> {
                            Path relPath = this.tree.root().checkoutRoot().relativize(pom.path());
                            sb.append("\n    * ").append(pom.toArtifactIdentifiers()).append("\t").append(relPath);
                        });
                    });
                    Problem.Severity sev = this.tolerateVersionInconsistenciesIn.contains(fam) ? Problem.Severity.NOTE : Problem.Severity.FATAL;
                    into.add(sb.toString(), sev);
                    sb.setLength(0);
                });
            }
        }

        private Map<ProjectFamily, PomVersion> versionsForFamilies() {
            if (this.versionsForFamilies != null) {
                return this.versionsForFamilies;
            }
            this.log("Collecting versions for families");
            HashMap<ProjectFamily, PomVersion> result = new HashMap<ProjectFamily, PomVersion>();
            for (Pom pom : this.poms().poms()) {
                ProjectFamily fam = ProjectFamily.familyOf((MavenIdentified)pom);
                result.computeIfAbsent(fam, f -> f.probableFamilyVersion((Collection)this.poms.poms()).orElse(PomVersion.UNKNOWN));
            }
            this.versionsForFamilies = result;
            return this.versionsForFamilies;
        }

        private void checkRoles(Problems into) {
            this.categorizer().eachPomAndItsRoles((pom, roles) -> {
                if (roles.contains(PomRole.BILL_OF_MATERIALS) && roles.contains(PomRole.CONFIG) && !roles.contains(PomRole.CONFIG_ROOT) && roles.contains(PomRole.PARENT) && this.categorizer().parentOf(pom).isPresent()) {
                    into.add("Intermediate pom " + pom.toArtifactIdentifiers() + " is acting as a bill-of-materials and a parent to other poms, but it has a parent.  Shared configuration should not live in a bill-of-materials unless it is also the root pom for its family: " + pom.path());
                }
            });
        }

        private Poms poms() {
            if (this.poms == null) {
                this.log("Collecting pom files");
                Set allPoms = this.tree.allProjects().stream().filter(pom -> this.familiesToCheck.test((ProjectFamily)ProjectFamily.familyOf((MavenIdentified)pom))).filter(pom -> this.tree.checkoutFor((Pom)pom) != null && this.reposFilter.test((GitCheckout)this.tree.checkoutFor((Pom)pom))).collect(Collectors.toCollection(HashSet::new));
                this.log("Have " + allPoms.size() + " poms.");
                this.poms = new Poms((Collection)allPoms);
                return this.poms;
            }
            return this.poms;
        }

        private PomCategorizer categorizer() {
            if (this.categorizer == null) {
                this.log("Categorizing pom files");
                this.categorizer = new PomCategorizer(this.poms());
            }
            return this.categorizer;
        }

        private void checkVersionFlavor(Problems result) {
            EnumMap<VersionFlavor, Map> inconsistencies = new EnumMap<VersionFlavor, Map>(VersionFlavor.class);
            this.poms().poms().forEach(pom -> {
                if (!this.includeFamilies.contains(ProjectFamily.familyOf((MavenIdentified)pom))) {
                    return;
                }
                PomVersion ver = pom.version();
                if (!this.versionFlavor.equals((Object)ver.flavor())) {
                    Map inc = inconsistencies.computeIfAbsent(ver.flavor(), v -> new TreeMap());
                    Set set = inc.computeIfAbsent(ver, v -> new TreeSet());
                    set.add(pom);
                }
            });
            if (!inconsistencies.isEmpty()) {
                inconsistencies.forEach((flavor, pomsForVersion) -> {
                    StringBuilder sb = new StringBuilder("Not all projects have the version flavor '").append(this.versionFlavor).append('\'');
                    pomsForVersion.forEach((ver, poms) -> {
                        sb.append("\n  * ").append(ver);
                        poms.forEach(pom -> sb.append("\n    * ").append(pom.toArtifactIdentifiers()).append('\t').append(this.tree.root().checkoutRoot().relativize(pom.path())));
                    });
                    result.add(sb.toString());
                });
            }
        }
    }
}

