/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.tree;

import com.telenav.cactus.maven.tree.Problem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;

public class Inconsistency<T>
extends Problem {
    private final Map<String, Set<T>> partitions;
    private final Kind kind;
    private final Function<T, Path> pathConverter;

    Inconsistency(Map<String, Set<T>> partitions, Kind kind, Function<T, Path> pathConverter) {
        this.partitions = partitions;
        this.kind = kind;
        this.pathConverter = pathConverter;
    }

    public Kind kind() {
        return this.kind;
    }

    public Set<T> partition(String name) {
        return this.partitions.getOrDefault(name, Collections.emptySet());
    }

    public <R> Set<R> checkedPartition(String name, Class<R> type) {
        Set<T> contents = this.partition(name);
        HashSet<R> result = new HashSet<R>();
        for (T obj : contents) {
            result.add(type.cast(obj));
        }
        return result;
    }

    @Override
    protected String computeMessage() {
        StringBuilder sb = new StringBuilder(this.kind.toString()).append(':');
        this.partitions.forEach((name, partition) -> {
            sb.append("\n  * ").append((String)name).append('=');
            Inconsistency.writeCommaDelimited(partition, sb);
            sb.append('\n');
        });
        return sb.toString();
    }

    public Set<Path> outlierPaths() {
        HashSet<Path> result = new HashSet<Path>();
        Set<String> outliers = this.outlierPartitions();
        for (String outlier : outliers) {
            for (T partition : this.partitions.get(outlier)) {
                result.add(this.pathConverter.apply(partition));
            }
        }
        return result;
    }

    public Optional<String> commonalityPartition() {
        HashSet<String> all = new HashSet<String>(this.partitions.keySet());
        all.removeAll(this.outlierPartitions());
        return all.size() == 1 ? Optional.of((String)all.iterator().next()) : Optional.empty();
    }

    public Set<String> outlierPartitions() {
        if (this.partitions.size() < 2) {
            return this.partitions.keySet();
        }
        ArrayList<Map.Entry<String, Set<Map.Entry>>> entries = new ArrayList<Map.Entry<String, Set<Map.Entry>>>(this.partitions.entrySet());
        Collections.sort(entries, (a, b) -> Integer.compare(((Set)b.getValue()).size(), ((Set)a.getValue()).size()));
        entries.remove(0);
        TreeSet<String> result = new TreeSet<String>();
        entries.forEach(e -> result.add((String)e.getKey()));
        return result;
    }

    private static <T> void writeCommaDelimited(Set<T> set, StringBuilder into) {
        Iterator<T> iter = set.iterator();
        while (iter.hasNext()) {
            into.append(iter.next());
            if (!iter.hasNext()) continue;
            into.append(',');
        }
    }

    public static enum Kind {
        VERSION,
        BRANCH,
        CONTAINS_MODIFIED_SOURCES,
        NOT_ON_A_BRANCH;


        public String toString() {
            switch (this) {
                case VERSION: {
                    return "More than one version present";
                }
                case BRANCH: {
                    return "More than one branch present";
                }
                case CONTAINS_MODIFIED_SOURCES: {
                    return "Modified, uncommitted sources present";
                }
                case NOT_ON_A_BRANCH: {
                    return "Checkout is in detached head mode - not on a branch";
                }
            }
            throw new AssertionError((Object)this);
        }
    }
}

