/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.tree;

import com.mastfrog.function.optional.ThrowingOptional;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.model.ParentMavenCoordinates;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.tree.Problem;
import com.telenav.cactus.maven.tree.ProjectTree;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public final class ParentRelativePathChecker {
    public Set<Problem> checkTree(ProjectTree tree) {
        LinkedHashSet<Problem> problems = new LinkedHashSet<Problem>();
        tree.allProjects().forEach(pom -> this.check((Pom)pom).ifPresent(problems::add));
        return problems;
    }

    public ThrowingOptional<Problem> check(Pom pom) {
        return pom.parent().flatMapThrowing(parentCoords -> {
            if (parentCoords.relativePath.isNone()) {
                return ThrowingOptional.empty();
            }
            return parentCoords.relativePath.resolve(pom.projectFolder()).flatMapThrowing(relPath -> {
                if (!Files.exists(relPath, new LinkOption[0])) {
                    return ThrowingOptional.of((Object)new NonExistentParentProblem(pom, (ParentMavenCoordinates)parentCoords));
                }
                return ThrowingOptional.from((Optional)GitCheckout.checkout((Path)pom.path())).flatMapThrowing(pomOwningCheckout -> ThrowingOptional.from((Optional)GitCheckout.checkout((Path)relPath)).flatMapThrowing(parentCheckout -> {
                    if (!pomOwningCheckout.equals(parentCheckout)) {
                        return ThrowingOptional.of((Object)new ParentProblem(pom, (GitCheckout)pomOwningCheckout, (GitCheckout)parentCheckout, (ParentMavenCoordinates)parentCoords));
                    }
                    return ThrowingOptional.empty();
                }));
            });
        });
    }

    public static class NonExistentParentProblem
    extends Problem {
        private final Pom pom;
        private final ParentMavenCoordinates parentCoords;

        public NonExistentParentProblem(Pom pom, ParentMavenCoordinates parentCoords) {
            this.pom = pom;
            this.parentCoords = parentCoords;
        }

        public Pom pom() {
            return this.pom;
        }

        public ParentMavenCoordinates parentCoordinates() {
            return this.parentCoords;
        }

        @Override
        protected String computeMessage() {
            return "POM " + this.pom.coordinates() + " has a parent relative path pointing to " + this.parentCoords.relativePath.resolve(this.pom.projectFolder()) + " via the value  '" + this.parentCoords.relativePath.text() + "' which does not exist.\n" + this.pom.path();
        }
    }

    public static class ParentProblem
    extends Problem {
        private final Pom pom;
        private final ParentMavenCoordinates parentCoords;
        private final GitCheckout expectedCheckout;
        private final GitCheckout encounteredCheckout;

        public ParentProblem(Pom pom, GitCheckout expectedCheckout, GitCheckout encounteredCheckout, ParentMavenCoordinates parentCoords) {
            this.pom = pom;
            this.expectedCheckout = expectedCheckout;
            this.encounteredCheckout = encounteredCheckout;
            this.parentCoords = parentCoords;
        }

        public Pom pom() {
            return this.pom;
        }

        public ParentMavenCoordinates parentCoordinates() {
            return this.parentCoords;
        }

        public GitCheckout expectedCheckout() {
            return this.expectedCheckout;
        }

        public GitCheckout encounteredCheckout() {
            return this.encounteredCheckout;
        }

        @Override
        protected String computeMessage() {
            return "POM " + this.pom.coordinates() + " has a parent relative path '" + this.parentCoords.relativePath + (this.parentCoords.relativePath.isDefault() ? " (because <relativePath/> is not specified and the default is ../pom.xml)" : "") + " which points outside it's own git checkout in " + this.expectedCheckout.checkoutRoot() + " into the checkout in " + this.encounteredCheckout.checkoutRoot() + ". Such projects will not be buildable when checkout out individually.\n" + this.pom.path();
        }
    }
}

