/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.tree;

import com.mastfrog.util.preconditions.Checks;
import java.util.Optional;

public abstract class Problem {
    private String msg;

    public final String message() {
        if (this.msg != null) {
            return this.msg;
        }
        this.msg = this.computeMessage();
        return this.msg;
    }

    protected abstract String computeMessage();

    public final String toString() {
        return this.severity() + ": " + this.message();
    }

    public <T> Optional<T> as(Class<T> type) {
        if (this.getClass().isInstance(this)) {
            return Optional.of(type.cast(this));
        }
        return Optional.empty();
    }

    public Severity severity() {
        return Severity.FATAL;
    }

    public final boolean isFatal() {
        return this.severity() == Severity.FATAL;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Problem)) {
            return false;
        }
        Problem p = (Problem)o;
        return p.severity() == this.severity() && p.message().equals(this.message());
    }

    public final int hashCode() {
        return (this.severity().ordinal() + 1) * 41 * this.message().hashCode();
    }

    public Problem withSeverity(Severity sev) {
        if (sev == this.severity()) {
            return this;
        }
        return new Wrapper(this, sev);
    }

    public static enum Severity {
        NOTE,
        WARNING,
        FATAL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    private static final class Wrapper
    extends Problem {
        private final Problem delegate;
        private final Severity severity;

        public Wrapper(Problem delegate, Severity severity) {
            this.delegate = (Problem)Checks.notNull((String)"delegate", (Object)delegate);
            this.severity = severity;
        }

        @Override
        public Problem withSeverity(Severity sev) {
            if (sev == this.severity()) {
                return this;
            }
            if (sev == this.delegate.severity()) {
                return this.delegate;
            }
            return this.delegate.withSeverity(sev);
        }

        @Override
        public Severity severity() {
            return this.severity;
        }

        @Override
        public <T> Optional<T> as(Class<T> type) {
            return this.delegate.as(type).or(() -> super.as(type));
        }

        @Override
        protected String computeMessage() {
            return this.delegate.message();
        }
    }
}

