/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.tree;

import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.tree.Problem;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class Problems
implements Iterable<Problem> {
    private final Set<Problem> problems;

    public Problems() {
        this.problems = ConcurrentHashMap.newKeySet();
    }

    private Problems(Set<Problem> problems) {
        this.problems = problems;
    }

    public Problems filter(Predicate<Problem> test) {
        return new Problems(this.problems.stream().filter(test).collect(Collectors.toCollection(ConcurrentHashMap::newKeySet)));
    }

    public Problems filter(Function<Problem, Problem.Severity> transform) {
        ConcurrentHashMap.KeySetView result = ConcurrentHashMap.newKeySet();
        for (Problem p : this.problems) {
            Problem.Severity s = transform.apply(p);
            if (s == null || s == p.severity()) {
                result.add(p);
                continue;
            }
            result.add(p.withSeverity(s));
        }
        return new Problems(result);
    }

    public boolean hasFatal() {
        for (Problem p : this) {
            if (!p.isFatal()) continue;
            return true;
        }
        return false;
    }

    Problems add(Problem p) {
        this.problems.add((Problem)Checks.notNull((String)"p", (Object)p));
        return this;
    }

    Problems add(String msg, Problem.Severity sev) {
        return this.add(new SimpleProblem(msg, sev));
    }

    Problems add(String msg) {
        return this.add(new SimpleProblem(msg));
    }

    public boolean hasProblems() {
        return !this.problems.isEmpty();
    }

    public void ifProblems(ThrowingRunnable run) throws Exception {
        if (this.hasProblems()) {
            run.run();
        }
    }

    public <T extends Problem> Set<T> find(Class<T> type) {
        LinkedHashSet result = new LinkedHashSet();
        for (Problem p : this.problems) {
            p.as(type).ifPresent(result::add);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.problems.isEmpty()) {
            sb.append("-no-problems-");
        } else {
            for (Problem p : this) {
                if (sb.length() > 0) {
                    sb.append("\n\n");
                }
                sb.append(p);
            }
        }
        return sb.toString();
    }

    @Override
    public Iterator<Problem> iterator() {
        return Collections.unmodifiableSet(this.problems).iterator();
    }

    private static final class SimpleProblem
    extends Problem {
        private final String message;
        private final Problem.Severity severity;

        public SimpleProblem(String message) {
            this(message, Problem.Severity.FATAL);
        }

        public SimpleProblem(String message, Problem.Severity severity) {
            this.message = message;
            this.severity = severity;
        }

        @Override
        public Problem.Severity severity() {
            return this.severity;
        }

        @Override
        protected String computeMessage() {
            return this.message;
        }
    }
}

