/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.tree;

import com.mastfrog.function.optional.ThrowingOptional;
import com.telenav.cactus.git.Branches;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.git.Heads;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.tree.ProjectTreeCache;
import com.telenav.cactus.scope.ProjectFamily;
import com.telenav.cactus.scope.Scope;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.project.MavenProject;

public class ProjectTree {
    final GitCheckout root;
    private final AtomicBoolean upToDate = new AtomicBoolean();
    private final ProjectTreeCache cache = new ProjectTreeCache(this);

    ProjectTree(GitCheckout root) {
        this.root = root;
    }

    public boolean isSubmoduleRoot(GitCheckout co) {
        return this.root.equals((Object)co) && this.withCache(ProjectTreeCache::rootIsSubmoduleRoot) != false;
    }

    public GitCheckout root() {
        return this.root;
    }

    public static ThrowingOptional<ProjectTree> from(MavenProject project) {
        return ProjectTree.from(project.getBasedir().toPath());
    }

    public static ThrowingOptional<ProjectTree> from(Path fileOrFolder) {
        return ThrowingOptional.from((Optional)GitCheckout.checkout((Path)fileOrFolder)).flatMapThrowing(GitCheckout::submoduleRoot).map(ProjectTree::new);
    }

    public void invalidateCache() {
        if (this.upToDate.compareAndSet(true, false)) {
            this.cache.clear();
        }
    }

    private synchronized <T> T withCache(Function<ProjectTreeCache, T> func) {
        if (this.upToDate.compareAndSet(false, true)) {
            this.cache.populate();
        }
        return func.apply(this.cache);
    }

    public Optional<Pom> findProject(String groupId, String artifactId) {
        return this.withCache(c -> c.project(groupId, artifactId));
    }

    public boolean areVersionsConsistent() {
        return this.allVersions().size() <= 1;
    }

    public Set<String> allBranches(Predicate<GitCheckout> pred) {
        return this.allCheckouts().stream().filter(pred).map(co -> co.branch().orElse("")).filter(s -> !s.isEmpty()).collect(Collectors.toCollection(HashSet::new));
    }

    public Set<String> allBranches() {
        HashSet<String> branches = new HashSet<String>();
        this.allCheckouts().forEach(checkout -> checkout.branch().ifPresent(branches::add));
        return branches;
    }

    public Set<String> allVersions() {
        HashSet<String> result = new HashSet<String>();
        this.allProjects().forEach(pom -> result.add(pom.version().text()));
        return result;
    }

    public Set<String> allVersions(Predicate<Pom> test) {
        HashSet<String> result = new HashSet<String>();
        this.allProjects().forEach(pom -> {
            if (test.test((Pom)pom)) {
                result.add(pom.version().text());
            }
        });
        return result;
    }

    public Set<Pom> allProjects() {
        return this.withCache(ProjectTreeCache::allPoms);
    }

    public Set<Pom> projectsForGroupId(String groupId) {
        TreeSet<Pom> result = new TreeSet<Pom>();
        this.allProjects().forEach(project -> {
            if (groupId.equals(project.coordinates().groupId)) {
                result.add((Pom)project);
            }
        });
        return result;
    }

    public Set<Pom> projectsForFamily(ProjectFamily fam) {
        TreeSet<Pom> result = new TreeSet<Pom>();
        this.allProjects().forEach(project -> {
            if (fam.equals((Object)ProjectFamily.fromGroupId((String)project.groupId().text()))) {
                result.add((Pom)project);
            }
        });
        return result;
    }

    public Map<String, Set<String>> branchesByGroupId() {
        return this.withCache(c -> {
            TreeMap result = new TreeMap();
            c.allPoms().forEach(pom -> GitCheckout.checkout((Path)pom.path()).ifPresent(checkout -> {
                Set branches = result.computeIfAbsent(pom.groupId().text(), g -> new TreeSet());
                checkout.branches().localBranches().forEach(br -> branches.add(br.trackingName()));
                checkout.branches().remoteBranches().forEach(br -> branches.add(br.trackingName()));
            }));
            return result;
        });
    }

    public Map<String, Map<String, Set<Pom>>> projectsByBranchByGroupId(Predicate<Pom> filter) {
        return this.withCache(c -> {
            TreeMap<String, Map> result = new TreeMap<String, Map>();
            for (Pom pom : c.allPoms()) {
                if (!filter.test(pom)) continue;
                Map infosByBranch = result.computeIfAbsent(pom.groupId().text(), id -> new TreeMap());
                GitCheckout.checkout((Path)pom.path()).ifPresent(checkout -> c.branchFor((GitCheckout)checkout).ifPresent(branch -> {
                    Set set = infosByBranch.computeIfAbsent(branch, b -> new TreeSet());
                    set.add(pom);
                }));
            }
            return result;
        });
    }

    public Map<String, Map<String, Set<Pom>>> projectsByGroupIdAndVersion() {
        TreeMap<String, Map<String, Set<Pom>>> result = new TreeMap<String, Map<String, Set<Pom>>>();
        this.projectsByGroupId().forEach((gid, poms) -> {
            Map subMap = result.computeIfAbsent((String)gid, g -> new TreeMap());
            for (Pom info : poms) {
                Set pomSet = subMap.computeIfAbsent(info.version().text(), v -> new TreeSet());
                pomSet.add(info);
            }
        });
        return result;
    }

    public Set<String> groupIdsIn(GitCheckout checkout) {
        return this.withCache(c -> c.projectsWithin(checkout).stream().map(info -> info.groupId().toString()).collect(Collectors.toCollection(HashSet::new)));
    }

    public Map<String, Set<Pom>> projectsByGroupId() {
        TreeMap<String, Set<Pom>> result = new TreeMap<String, Set<Pom>>();
        this.allProjects().forEach(pom -> {
            Set set = result.computeIfAbsent(pom.groupId().text(), x -> new TreeSet());
            set.add(pom);
        });
        return result;
    }

    public Set<Path> allProjectFolders() {
        return this.withCache(c -> {
            HashSet result = new HashSet();
            c.allPoms().forEach(pom -> result.add(pom.projectFolder()));
            return result;
        });
    }

    public Map<String, Set<Pom>> projectsByVersion(Predicate<Pom> filter) {
        return this.withCache(c -> {
            TreeMap result = new TreeMap();
            c.allPoms().forEach(pom -> {
                if (filter.test((Pom)pom)) {
                    Set infos = result.computeIfAbsent(pom.version().text(), v -> new TreeSet());
                    infos.add(pom);
                }
            });
            return result;
        });
    }

    public Optional<Pom> projectOf(Path file) {
        this.withCache(c -> {
            Path realFile = Files.isDirectory(file, new LinkOption[0]) && Files.exists(file.resolve("pom.xml"), new LinkOption[0]) ? file.resolve("pom.xml") : file;
            if ("pom.xml".equals(realFile.getFileName())) {
                for (Pom pom : c.allPoms()) {
                    if (!pom.path().equals(realFile)) continue;
                    return Optional.of(pom);
                }
            }
            ArrayList paths = new ArrayList();
            HashMap candidateItems = new HashMap();
            c.projectFolders().forEach((dir, pomInfo) -> {
                if (realFile.startsWith((Path)dir)) {
                    candidateItems.put(dir, pomInfo);
                    paths.add(dir);
                }
            });
            if (paths.isEmpty()) {
                return Optional.empty();
            }
            Collections.sort(paths, (a, b) -> Integer.compare(b.getNameCount(), a.getNameCount()));
            return Optional.of((Pom)candidateItems.get(paths.get(0)));
        });
        return Optional.empty();
    }

    public GitCheckout checkoutFor(Pom info) {
        return this.withCache(c -> c.checkoutForPom.get(info));
    }

    public Set<GitCheckout> allCheckouts() {
        return this.withCache(ProjectTreeCache::allCheckouts);
    }

    public Optional<String> branchFor(GitCheckout checkout) {
        return this.withCache(c -> c.branchFor(checkout));
    }

    public boolean isDirty(GitCheckout checkout) {
        return this.withCache(c -> c.isDirty(checkout));
    }

    public boolean isDirtyIgnoringSubmoduleCommits(GitCheckout checkout) {
        return this.withCache(c -> c.isDirtyIgnoringSubmoduleCommits(checkout));
    }

    public Set<GitCheckout> checkoutsFor(Collection<? extends Pom> infos) {
        return this.withCache(c -> {
            TreeSet result = new TreeSet();
            infos.forEach(pom -> c.checkoutFor((Pom)pom).ifPresent(result::add));
            return result;
        });
    }

    public Branches branches(GitCheckout checkout) {
        return this.withCache(c -> c.branches(checkout));
    }

    public Optional<String> mostCommonBranchForGroupId(String groupId) {
        return this.withCache(c -> c.mostCommonBranchForGroupId(groupId));
    }

    public boolean isDetachedHead(GitCheckout checkout) {
        return this.withCache(c -> c.isDetachedHead(checkout));
    }

    public Set<Pom> projectsWithin(GitCheckout checkout) {
        return this.withCache(c -> c.projectsWithin(checkout));
    }

    public Set<GitCheckout> nonMavenCheckouts() {
        return this.withCache(ProjectTreeCache::nonMavenCheckouts);
    }

    public Set<GitCheckout> checkoutsContainingGroupId(String groupId) {
        return this.withCache(c -> c.checkoutsContainingGroupId(groupId));
    }

    public Set<GitCheckout> checkoutsInProjectFamily(Set<ProjectFamily> family) {
        return this.withCache(c -> c.checkoutsInProjectFamily(family));
    }

    public Set<GitCheckout> checkoutsInProjectFamilyOrChildProjectFamily(String gid, Set<ProjectFamily> family) {
        return this.withCache(c -> c.checkoutsInProjectFamilyOrChildProjectFamily(gid));
    }

    public Set<GitCheckout> checkoutsInProjectFamily(ProjectFamily family) {
        return this.withCache(c -> c.checkoutsInProjectFamily(family));
    }

    public Heads remoteHeads(GitCheckout checkout) {
        return this.withCache(c -> c.remoteHeads(checkout));
    }

    public Set<ProjectFamily> allProjectFamilies() {
        return this.withCache(ProjectTreeCache::allProjectFamilies);
    }

    public void invalidateBranches(GitCheckout co) {
        this.withCache(cache -> cache.invalidateBranches(co));
    }

    public List<GitCheckout> matchCheckouts(Scope scope, GitCheckout callingProjectsCheckout, boolean includeRoot, Set<ProjectFamily> family, String callingProjectsGroupId) {
        Set<GitCheckout> checkouts;
        switch (scope) {
            case FAMILY: {
                checkouts = this.checkoutsInProjectFamily(family);
                break;
            }
            case FAMILY_OR_CHILD_FAMILY: {
                checkouts = this.checkoutsInProjectFamilyOrChildProjectFamily(callingProjectsGroupId, family);
                break;
            }
            case SAME_GROUP_ID: {
                checkouts = this.checkoutsContainingGroupId(callingProjectsGroupId);
                break;
            }
            case JUST_THIS: {
                checkouts = new HashSet<GitCheckout>(Arrays.asList(callingProjectsCheckout));
                break;
            }
            case ALL_PROJECT_FAMILIES: {
                checkouts = new HashSet<GitCheckout>(this.allCheckouts());
                break;
            }
            case ALL: {
                checkouts = new HashSet<GitCheckout>(this.allCheckouts());
                checkouts.addAll(this.nonMavenCheckouts());
                break;
            }
            default: {
                throw new AssertionError(this);
            }
        }
        checkouts = new LinkedHashSet<GitCheckout>(checkouts);
        if (!includeRoot) {
            callingProjectsCheckout.submoduleRoot().ifPresent(checkouts::remove);
        } else if (!checkouts.isEmpty()) {
            callingProjectsCheckout.submoduleRoot().ifPresent(checkouts::add);
        }
        return GitCheckout.depthFirstSort(checkouts);
    }

    static {
        try {
            Class<?> clazz = ProjectTree.class.getClassLoader().loadClass("com.telenav.cactus.maven.tree.ProjectTree$1");
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace(System.out);
        }
    }
}

