/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.tree;

import com.mastfrog.util.preconditions.Exceptions;
import com.telenav.cactus.git.Branches;
import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.git.Heads;
import com.telenav.cactus.git.SubmoduleStatus;
import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenIdentified;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.tree.ProjectTree;
import com.telenav.cactus.scope.ProjectFamily;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class ProjectTreeCache {
    final Map<String, Map<String, Pom>> infoForGroupAndArtifact = new ConcurrentHashMap<String, Map<String, Pom>>();
    final Map<GitCheckout, Set<Pom>> projectsByRepository = new ConcurrentHashMap<GitCheckout, Set<Pom>>();
    final Map<Pom, GitCheckout> checkoutForPom = new ConcurrentHashMap<Pom, GitCheckout>();
    final Map<GitCheckout, Optional<String>> branches = new HashMap<GitCheckout, Optional<String>>();
    final Map<GitCheckout, Boolean> dirty = new ConcurrentHashMap<GitCheckout, Boolean>();
    final Map<GitCheckout, Boolean> dirtyIgnoring = new ConcurrentHashMap<GitCheckout, Boolean>();
    final Map<GitCheckout, Branches> allBranches = new ConcurrentHashMap<GitCheckout, Branches>();
    final Map<String, Optional<String>> branchByGroupId = new HashMap<String, Optional<String>>();
    final Map<GitCheckout, Boolean> detachedHeads = new ConcurrentHashMap<GitCheckout, Boolean>();
    final Set<GitCheckout> nonMavenCheckouts = new HashSet<GitCheckout>();
    final Map<GitCheckout, Heads> remoteHeads = new HashMap<GitCheckout, Heads>();
    final Map<ProjectFamily, Set<GitCheckout>> checkoutsForProjectFamily = new ConcurrentHashMap<ProjectFamily, Set<GitCheckout>>();
    final Set<ProjectFamily> families = new HashSet<ProjectFamily>();
    Boolean rootIsRoot;
    private final ProjectTree outer;
    private final Map<GitCheckout, GitCheckout> repoInternTable = new ConcurrentHashMap<GitCheckout, GitCheckout>();

    ProjectTreeCache(ProjectTree outer) {
        this.outer = outer;
    }

    public boolean rootIsSubmoduleRoot() {
        if (this.rootIsRoot == null) {
            this.rootIsRoot = this.outer.root.isSubmoduleRoot();
        }
        return this.rootIsRoot;
    }

    public Set<ProjectFamily> allProjectFamilies() {
        if (this.families.isEmpty()) {
            this.allPoms().forEach(pom -> this.families.add(ProjectFamily.familyOf((MavenIdentified)pom)));
        }
        return this.families;
    }

    public Heads remoteHeads(GitCheckout checkout) {
        return this.remoteHeads.computeIfAbsent(checkout, GitCheckout::remoteHeads);
    }

    public Set<GitCheckout> checkoutsContainingGroupId(String groupId) {
        HashSet<GitCheckout> all = new HashSet<GitCheckout>();
        this.projectsByRepository.forEach((repo, projectSet) -> {
            for (Pom project : projectSet) {
                if (!groupId.equals(project.coordinates().groupId)) continue;
                all.add((GitCheckout)repo);
                break;
            }
        });
        return all;
    }

    public Set<GitCheckout> checkoutsInProjectFamily(Set<ProjectFamily> family) {
        switch (family.size()) {
            case 0: {
                return new HashSet<GitCheckout>(this.allCheckouts());
            }
            case 1: {
                return this.checkoutsInProjectFamily(family.iterator().next());
            }
        }
        HashSet<GitCheckout> result = new HashSet<GitCheckout>();
        for (ProjectFamily f : family) {
            result.addAll(this.checkoutsInProjectFamily(f));
        }
        return result;
    }

    public Set<GitCheckout> checkoutsInProjectFamily(ProjectFamily family) {
        return this.checkoutsForProjectFamily.computeIfAbsent(family, key -> {
            HashSet all = new HashSet();
            this.projectsByRepository.forEach((repo, projectSet) -> {
                for (Pom project : projectSet) {
                    if (!family.equals((Object)ProjectFamily.fromGroupId((String)project.groupId().text()))) continue;
                    all.add(repo);
                    break;
                }
            });
            return all;
        });
    }

    private static boolean containsParentFamilyOf(GroupId groupId, Set<ProjectFamily> s) {
        for (ProjectFamily p : s) {
            if (!p.isParentFamilyOf(groupId)) continue;
            return true;
        }
        return false;
    }

    public Set<GitCheckout> checkoutsInProjectFamilyOrChildProjectFamily(String groupId) {
        ProjectFamily parent = ProjectFamily.fromGroupId((String)groupId);
        HashSet<GitCheckout> all = new HashSet<GitCheckout>();
        this.projectsByRepository.forEach((repo, projectSet) -> {
            for (Pom p : projectSet) {
                if (!ProjectFamily.familyOf((MavenIdentified)p).equals((Object)parent) && !parent.isParentFamilyOf(p.groupId())) continue;
                all.add((GitCheckout)repo);
                break;
            }
        });
        return all;
    }

    public Set<GitCheckout> checkoutsInProjectFamilyOrChildProjectFamily(Set<ProjectFamily> family) {
        HashSet<GitCheckout> all = new HashSet<GitCheckout>();
        this.projectsByRepository.forEach((repo, projectSet) -> {
            if (family.isEmpty()) {
                all.add((GitCheckout)repo);
                return;
            }
            for (Pom project : projectSet) {
                ProjectFamily pomFamily = ProjectFamily.familyOf((GroupId)project.groupId());
                if (!family.contains(pomFamily) && !ProjectTreeCache.containsParentFamilyOf(project.groupId(), family)) continue;
                all.add((GitCheckout)repo);
                break;
            }
        });
        return all;
    }

    public Set<GitCheckout> nonMavenCheckouts() {
        return Collections.unmodifiableSet(this.nonMavenCheckouts);
    }

    public boolean isDetachedHead(GitCheckout checkout) {
        return this.detachedHeads.computeIfAbsent(checkout, GitCheckout::isDetachedHead);
    }

    public Optional<String> mostCommonBranchForGroupId(String groupId) {
        return this.branchByGroupId.computeIfAbsent(groupId, this::_mostCommonBranchForGroupId);
    }

    private Optional<String> _mostCommonBranchForGroupId(String groupId) {
        HashMap branchNameCounts = new HashMap();
        HashSet seen = new HashSet();
        this.checkoutForPom.forEach((pom, checkout) -> {
            if (seen.contains(checkout) || !pom.groupId().is(groupId)) {
                return;
            }
            this.branchFor((GitCheckout)checkout).ifPresent(branch -> {
                seen.add(checkout);
                branchNameCounts.compute(branch, (b, old) -> {
                    if (old == null) {
                        return 1;
                    }
                    return old + 1;
                });
            });
        });
        if (branchNameCounts.isEmpty()) {
            return Optional.empty();
        }
        ArrayList entries = new ArrayList(branchNameCounts.entrySet());
        Collections.sort(entries, (a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()));
        return Optional.of((String)((Map.Entry)entries.get(0)).getKey());
    }

    public Set<Pom> projectsWithin(GitCheckout checkout) {
        Set<Pom> infos = this.projectsByRepository.get(checkout);
        return infos == null ? Collections.emptySet() : infos;
    }

    public Branches branches(GitCheckout checkout) {
        return this.allBranches.computeIfAbsent(checkout, GitCheckout::branches);
    }

    public Optional<GitCheckout> checkoutFor(Pom info) {
        return Optional.ofNullable(this.checkoutForPom.get(info));
    }

    public boolean isDirty(GitCheckout checkout) {
        return this.dirty.computeIfAbsent(checkout, GitCheckout::isDirty);
    }

    public boolean isDirtyIgnoringSubmoduleCommits(GitCheckout checkout) {
        return this.dirtyIgnoring.computeIfAbsent(checkout, GitCheckout::isDirtyIgnoringModifiedSubmodules);
    }

    public Set<GitCheckout> allCheckouts() {
        return Collections.unmodifiableSet(this.projectsByRepository.keySet());
    }

    public Optional<String> branchFor(GitCheckout checkout) {
        return this.branches.computeIfAbsent(checkout, GitCheckout::branch);
    }

    public Map<Path, Pom> projectFolders() {
        HashMap<Path, Pom> infos = new HashMap<Path, Pom>();
        this.allPoms().forEach(pom -> infos.put(pom.path().getParent(), (Pom)pom));
        return infos;
    }

    public Set<Pom> allPoms() {
        HashSet<Pom> set = new HashSet<Pom>();
        this.projectsByRepository.forEach((repo, infos) -> set.addAll((Collection<Pom>)infos));
        return set;
    }

    Optional<Pom> project(String groupId, String artifactId) {
        Map<String, Pom> map = this.infoForGroupAndArtifact.get(groupId);
        if (map == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(map.get(artifactId));
    }

    void clear() {
        this.infoForGroupAndArtifact.clear();
        this.projectsByRepository.clear();
        this.checkoutForPom.clear();
        this.dirtyIgnoring.clear();
        this.branches.clear();
        this.dirty.clear();
        this.allBranches.clear();
        this.branchByGroupId.clear();
        this.nonMavenCheckouts.clear();
        this.detachedHeads.clear();
        this.checkoutsForProjectFamily.clear();
        this.remoteHeads.clear();
        this.families.clear();
        this.rootIsRoot = null;
    }

    synchronized void populate() {
        try {
            this.outer.root.allPomFilesInSubtreeParallel(this::cacheOnePomFile);
            this.outer.root.submodules().ifPresent(statii -> {
                for (SubmoduleStatus stat : statii) {
                    stat.checkout().filter(GitCheckout::noPomInRoot).ifPresent(this.nonMavenCheckouts::add);
                }
            });
        }
        catch (IOException ex) {
            Exceptions.chuck((Throwable)ex);
        }
    }

    private GitCheckout intern(GitCheckout co) {
        GitCheckout result = this.repoInternTable.putIfAbsent(co, co);
        if (result == null) {
            result = co;
        }
        return result;
    }

    private void cacheOnePomFile(Path path) {
        Pom.from((Path)path).ifPresent(info -> {
            Map subcache = this.infoForGroupAndArtifact.computeIfAbsent(info.groupId().text(), id -> new ConcurrentHashMap());
            subcache.put(info.coordinates().artifactId.text(), info);
            GitCheckout.checkout((Path)info.path()).ifPresent(co -> {
                co = this.intern((GitCheckout)co);
                Set poms = this.projectsByRepository.computeIfAbsent((GitCheckout)co, c -> new HashSet());
                poms.add(info);
                this.checkoutForPom.put((Pom)info, (GitCheckout)co);
            });
        });
    }

    Void invalidateBranches(GitCheckout co) {
        this.allBranches.remove(co);
        this.dirtyIgnoring.remove(co);
        this.dirty.remove(co);
        this.detachedHeads.remove(co);
        this.branches.remove(co);
        return null;
    }
}

