/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.trigger;

import com.telenav.cactus.git.GitCheckout;
import com.telenav.cactus.maven.mojobase.BaseMojo;
import com.telenav.cactus.maven.mojobase.FamilyAware;
import com.telenav.cactus.maven.shared.SharedDataKey;
import com.telenav.cactus.maven.trigger.RunPolicy;
import com.telenav.cactus.scope.ProjectFamily;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;

public enum RunPolicies implements RunPolicy
{
    INITIAL,
    FIRST,
    EVERY,
    POM_PROJECT_ONLY,
    NON_POM_PROJECT_ONLY,
    FAMILY_ROOTS,
    LAST_CONTAINING_GOAL,
    LAST,
    LAST_IN_ALL_PROJECTS,
    LAST_IN_SESSION_PROJECTS;


    public String toString() {
        return this.name().replace('_', '-').toLowerCase();
    }

    @Override
    public boolean shouldRun(BaseMojo mojo, MavenProject invokedOn) {
        switch (this) {
            case INITIAL: {
                return mojo.session().getAllProjects().indexOf(invokedOn) == 0;
            }
            case FIRST: {
                return mojo.isFirstRunInThisSession();
            }
            case POM_PROJECT_ONLY: {
                return "pom".equals(invokedOn.getPackaging());
            }
            case NON_POM_PROJECT_ONLY: {
                return !"pom".equals(invokedOn.getPackaging());
            }
            case EVERY: {
                return true;
            }
            case FAMILY_ROOTS: {
                return RunPolicies.isFamilyRoot(mojo, invokedOn);
            }
            case LAST_CONTAINING_GOAL: {
                return RunPolicies.isLastProjectInSession(invokedOn, mojo.session()) || RunPolicies.isLastProjectInSessionContaingThisMojosGoal(mojo, invokedOn);
            }
            case LAST: {
                return RunPolicies.isLastProjectInSession(invokedOn, mojo.session());
            }
            case LAST_IN_ALL_PROJECTS: {
                List all = mojo.session().getAllProjects();
                return all.indexOf(invokedOn) == all.size() - 1;
            }
            case LAST_IN_SESSION_PROJECTS: {
                List all2 = mojo.session().getProjects();
                return all2.indexOf(invokedOn) == all2.size() - 1;
            }
        }
        throw new AssertionError(this);
    }

    private static boolean isLastProjectInSession(MavenProject invokedOn, MavenSession session) {
        boolean result = session.getExecutionRootDirectory().equalsIgnoreCase(invokedOn.getBasedir().toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFamilyRoot(BaseMojo invokedBy, MavenProject invokedOn) {
        Map<Path, Boolean> cache = RunPolicies.familyRootCache(invokedBy);
        try {
            if (!"pom".equals(invokedOn.getPackaging()) || invokedOn.getModules().isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = cache.computeIfAbsent(invokedOn.getBasedir().toPath(), p -> RunPolicies.computeIsFamilyRoot(invokedBy, p, invokedOn));
            return bl;
        }
        finally {
            if (RunPolicies.isLastProjectInSession(invokedOn, invokedBy.session())) {
                cache.clear();
            }
        }
    }

    private static SharedDataKey<Map<Path, Boolean>> familyRootCacheKey(BaseMojo mojo) {
        return SharedDataKey.of(((Object)((Object)mojo)).getClass().getName(), Map.class);
    }

    private static Map<Path, Boolean> familyRootCache(BaseMojo mojo) {
        return mojo.sharedData().computeIfAbsent(RunPolicies.familyRootCacheKey(mojo), ConcurrentHashMap::new);
    }

    private static boolean computeIsFamilyRoot(BaseMojo invokedBy, Path basedir, MavenProject prj) {
        Set<ProjectFamily> families;
        if (invokedBy instanceof FamilyAware && !(families = ((FamilyAware)((Object)invokedBy)).families()).isEmpty() && !families.contains(ProjectFamily.fromGroupId((String)prj.getGroupId()))) {
            return false;
        }
        return GitCheckout.checkout((Path)basedir).map(co -> {
            boolean result;
            if (!basedir.equals(co.checkoutRoot())) {
                return false;
            }
            if (co.isRoot()) {
                boolean result2 = !co.isSubmodule();
                return result2;
            }
            boolean bl = result = !co.isSubmoduleRoot();
            if (result) {
                result = !co.name().contains("/");
            }
            return result;
        }).orElse(false);
    }

    private static boolean isLastProjectInSessionContaingThisMojosGoal(BaseMojo mojo, MavenProject invokedOn) {
        int max;
        if (mojo.wasRunInThisSession()) {
            return false;
        }
        String goalName = mojo.goal();
        if (goalName.isEmpty()) {
            return false;
        }
        List projects = mojo.session().getAllProjects();
        for (int i = max = projects.size() - 1; i >= 0; --i) {
            MavenProject prj = (MavenProject)projects.get(i);
            boolean found = RunPolicies.usesGoal(prj, goalName);
            if (found && prj.getArtifactId().equals(invokedOn.getArtifactId()) && prj.getGroupId().equals(invokedOn.getGroupId())) {
                return true;
            }
            if (found) break;
        }
        return false;
    }

    private static boolean usesGoal(MavenProject p, String goal) {
        if (!RunPolicies.containsGoal((BuildBase)p.getBuild(), goal)) {
            for (Profile profile : p.getActiveProfiles()) {
                if (!RunPolicies.containsGoal(profile.getBuild(), goal)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean containsGoal(BuildBase bld, String goal) {
        if (bld == null) {
            return false;
        }
        for (Plugin pl : bld.getPlugins()) {
            if (!"cactus-maven-plugin".equals(pl.getArtifactId())) continue;
            for (PluginExecution exe : pl.getExecutions()) {
                if (!exe.getGoals().contains(goal)) continue;
                return true;
            }
        }
        return false;
    }
}

