/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.refactoring;

import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.VersionChange;

enum PropertyRole {
    FAMILY_VERSION,
    FAMILY_PREV_VERSION,
    PROJECT_VERSION,
    PROJECT_PREV_VERSION,
    OTHER;


    public String toString() {
        return this.name().replace('_', '-').toLowerCase();
    }

    boolean isFamily() {
        return this == FAMILY_PREV_VERSION || this == FAMILY_VERSION;
    }

    boolean isProject() {
        return this == PROJECT_PREV_VERSION || this == PROJECT_VERSION;
    }

    boolean isPrevious() {
        return this == PROJECT_PREV_VERSION || this == FAMILY_PREV_VERSION;
    }

    PomVersion value(VersionChange change) {
        if (this == OTHER) {
            throw new IllegalStateException("Not a version property");
        }
        if (this.isPrevious()) {
            return change.oldVersion();
        }
        return change.newVersion();
    }
}

