/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.refactoring;

import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.VersionChange;
import com.telenav.cactus.maven.model.VersionChangeMagnitude;
import com.telenav.cactus.maven.model.VersionFlavorChange;

public enum SuperpomBumpPolicy {
    IGNORE,
    BUMP_ACQUIRING_NEW_FAMILY_FLAVOR,
    BUMP_WITHOUT_CHANGING_FLAVOR;


    public VersionChangeMagnitude magnitudeFor(PomVersion ver) {
        if (this == IGNORE) {
            return VersionChangeMagnitude.NONE;
        }
        return VersionChangeMagnitude.DOT;
    }

    public VersionChangeMagnitude minimalMagnitudeFor(PomVersion ver) {
        if (this == IGNORE) {
            return VersionChangeMagnitude.NONE.notNone();
        }
        return VersionChangeMagnitude.DOT;
    }

    public VersionChangeMagnitude magnitudeFor(VersionChange newFamilyVersion) {
        switch (this) {
            case IGNORE: {
                return VersionChangeMagnitude.NONE;
            }
            case BUMP_ACQUIRING_NEW_FAMILY_FLAVOR: 
            case BUMP_WITHOUT_CHANGING_FLAVOR: {
                return newFamilyVersion.magnitudeChange().notNone();
            }
        }
        throw new AssertionError((Object)this);
    }

    public VersionFlavorChange changeFor(PomVersion newFamilyVersion) {
        switch (this) {
            case IGNORE: 
            case BUMP_WITHOUT_CHANGING_FLAVOR: {
                return VersionFlavorChange.UNCHANGED;
            }
            case BUMP_ACQUIRING_NEW_FAMILY_FLAVOR: {
                return newFamilyVersion.flavor().toThis();
            }
        }
        throw new AssertionError((Object)this);
    }

    public String toString() {
        return this.name().toLowerCase().replace('_', '-');
    }

    boolean isBumpVersion() {
        switch (this) {
            case BUMP_ACQUIRING_NEW_FAMILY_FLAVOR: 
            case BUMP_WITHOUT_CHANGING_FLAVOR: {
                return true;
            }
            case IGNORE: {
                return false;
            }
        }
        throw new AssertionError((Object)this);
    }
}

