/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.refactoring;

import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.model.MavenIdentified;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.VersionChange;
import com.telenav.cactus.maven.refactoring.PropertyChange;
import com.telenav.cactus.maven.refactoring.VersionUpdateFilter;
import com.telenav.cactus.scope.ProjectFamily;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class VersionChangeUpdatesCollector {
    private final Map<Pom, VersionChange> pomVersionChanges;
    private final Map<Pom, VersionChange> parentVersionChanges;
    private final Map<Pom, Set<PropertyChange<?, PomVersion>>> propertyChanges;
    private final Set<Pom> removeExplicitVersionFrom;
    private final Set<Pom> versionMismatches;
    private final VersionUpdateFilter filter;
    private boolean hasChanges;

    VersionChangeUpdatesCollector(Map<Pom, VersionChange> pomVersionChanges, Map<Pom, VersionChange> parentVersionChanges, Map<Pom, Set<PropertyChange<?, PomVersion>>> propertyChanges, Set<Pom> removeExplicitVersionFrom, Set<Pom> versionMismatches, VersionUpdateFilter filter) {
        this.pomVersionChanges = pomVersionChanges;
        this.parentVersionChanges = parentVersionChanges;
        this.propertyChanges = propertyChanges;
        this.removeExplicitVersionFrom = removeExplicitVersionFrom;
        this.versionMismatches = versionMismatches;
        this.filter = filter;
    }

    public boolean hasVersionUpdateFor(Pom pom) {
        return this.pomVersionChanges.containsKey(pom);
    }

    public boolean hasParentUpdateFor(Pom pom) {
        return this.parentVersionChanges.containsKey(pom);
    }

    Map<Pom, VersionChange> pomVersionChanges() {
        return Collections.unmodifiableMap(this.pomVersionChanges);
    }

    Map<Pom, VersionChange> parentVersionChanges() {
        return Collections.unmodifiableMap(this.parentVersionChanges);
    }

    Set<Pom> versionMismatches() {
        return Collections.unmodifiableSet(this.versionMismatches);
    }

    Set<Pom> allChangedPoms() {
        HashSet<Pom> result = new HashSet<Pom>(this.pomVersionChanges.keySet());
        result.addAll(this.parentVersionChanges.keySet());
        result.addAll(this.propertyChanges.keySet());
        return result;
    }

    Set<Pom> changedPomsInFamily(ProjectFamily family) {
        return this.allChangedPoms().stream().filter(pom -> family.is((MavenIdentified)pom)).collect(Collectors.toCollection(HashSet::new));
    }

    boolean hasChanges() {
        boolean result = this.hasChanges;
        this.hasChanges = false;
        return result;
    }

    void removeVersionMismatch(Pom pom) {
        this.hasChanges |= this.versionMismatches.remove(pom);
    }

    ChangeResult removeExplicitVersionFrom(Pom pom) {
        boolean result = this.removeExplicitVersionFrom.add(pom);
        this.hasChanges |= result;
        return ChangeResult.changeResult(result);
    }

    ChangeResult removePomVersionChange(Pom pom) {
        VersionChange oldChange = this.pomVersionChanges.remove(Checks.notNull((String)"pom", (Object)pom));
        boolean result = oldChange != null;
        this.hasChanges |= result;
        return ChangeResult.changeResult(result);
    }

    ChangeResult removeParentVersionChange(Pom pom) {
        VersionChange oldChange = this.parentVersionChanges.remove(Checks.notNull((String)"pom", (Object)pom));
        boolean result = oldChange != null;
        this.hasChanges |= result;
        return ChangeResult.changeResult(result);
    }

    ChangeResult changeProperty(Pom pom, PropertyChange<?, PomVersion> change) {
        if (!this.filter.shouldUpdateVersionProperty(pom, change.propertyName(), change.newValue(), change.oldValue())) {
            this.logFiltering(() -> "changeProperty blocked " + change.propertyName() + " in " + pom.toArtifactIdentifiers() + " with " + change);
            return ChangeResult.FILTERED;
        }
        Set changes = this.propertyChanges.computeIfAbsent(pom, p -> new HashSet());
        ChangeResult result = ChangeResult.changeResult(changes.add(change));
        return result;
    }

    ChangeResult removeAllPropertyChanges(Pom pom) {
        Set<PropertyChange<?, PomVersion>> changes = this.propertyChanges.remove(pom);
        return ChangeResult.changeResult(changes != null && !changes.isEmpty());
    }

    ChangeResult addVersionMismatch(Pom pom) {
        if (this.versionMismatches.add(pom)) {
            return ChangeResult.CHANGED;
        }
        return ChangeResult.ALREADY_PRESENT;
    }

    ChangeResult changePomVersion(Pom pom, VersionChange change) {
        boolean result;
        if (!this.filter.shouldUpdatePomVersion((Pom)Checks.notNull((String)"pom", (Object)pom), (VersionChange)Checks.notNull((String)"change", (Object)change))) {
            this.logFiltering(() -> "changeParentVersion blocked " + pom.toArtifactIdentifiers() + " with " + change);
            return ChangeResult.FILTERED;
        }
        VersionChange old = this.pomVersionChanges.put(pom, change);
        boolean was = this.hasChanges;
        boolean bl = result = !Objects.equals(old, change);
        if (result) {
            this.versionMismatches.remove(pom);
        }
        this.hasChanges |= result;
        return ChangeResult.changeResult(result);
    }

    ChangeResult changeParentVersion(Pom pom, Pom parentPom, VersionChange change) {
        boolean result;
        if (!this.filter.shouldUpdateParentVersion((Pom)Checks.notNull((String)"pom", (Object)pom), (Pom)Checks.notNull((String)"parentPom", (Object)parentPom), (VersionChange)Checks.notNull((String)"change", (Object)change))) {
            this.logFiltering(() -> "changeParentVersion blocked " + pom.toArtifactIdentifiers() + " parent " + parentPom.toArtifactIdentifiers() + " with " + change);
            return ChangeResult.FILTERED;
        }
        VersionChange old = this.parentVersionChanges.put(pom, change);
        boolean was = this.hasChanges;
        boolean bl = result = !Objects.equals(old, change);
        if (result) {
            this.versionMismatches.remove(pom);
        }
        this.hasChanges |= result;
        return ChangeResult.changeResult(result);
    }

    private void logFiltering(Supplier<String> msg) {
    }

    static enum ChangeResult {
        CHANGED,
        ALREADY_PRESENT,
        FILTERED;


        static ChangeResult changeResult(boolean val) {
            return val ? CHANGED : ALREADY_PRESENT;
        }

        boolean isChange() {
            return this == CHANGED;
        }

        boolean isFiltered() {
            return this == FILTERED;
        }
    }
}

