/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.refactoring;

import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenCoordinates;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.refactoring.PomCategorizer;
import com.telenav.cactus.maven.refactoring.PomRole;
import com.telenav.cactus.maven.refactoring.PropertyRole;
import com.telenav.cactus.maven.refactoring.VersionProperty;
import com.telenav.cactus.scope.ProjectFamily;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public final class VersionIndicatingProperties {
    private final Set<VersionProperty<ProjectFamily>> familyVersionChanges;
    private final Set<VersionProperty<ProjectFamily>> familyPrevVersionChanges;
    private final Set<VersionProperty<MavenCoordinates>> projectVersionChanges;
    private final Set<VersionProperty<MavenCoordinates>> projectPrevVersionChanges;

    VersionIndicatingProperties(Set<VersionProperty<ProjectFamily>> familyVersionChanges, Set<VersionProperty<ProjectFamily>> familyPrevVersionChanges, Set<VersionProperty<MavenCoordinates>> projectVersionChanges, Set<VersionProperty<MavenCoordinates>> projectPrevVersionChanges) {
        this.familyVersionChanges = familyVersionChanges;
        this.familyPrevVersionChanges = familyPrevVersionChanges;
        this.projectVersionChanges = projectVersionChanges;
        this.projectPrevVersionChanges = projectPrevVersionChanges;
    }

    public static VersionIndicatingProperties create(PomCategorizer categories) {
        HashMap<String, ProjectFamily> familyVersionKeys = new HashMap<String, ProjectFamily>();
        HashMap<String, ProjectFamily> familyPrevVersionKeys = new HashMap<String, ProjectFamily>();
        HashMap<String, MavenCoordinates> projectVersionKeys = new HashMap<String, MavenCoordinates>();
        HashMap<String, MavenCoordinates> projectPrevVersionKeys = new HashMap<String, MavenCoordinates>();
        VersionIndicatingProperties.buildFamilyMappings(categories, familyVersionKeys, familyPrevVersionKeys);
        VersionIndicatingProperties.buildVersionPropertyMappings(categories, projectVersionKeys, projectPrevVersionKeys);
        Set<VersionProperty<ProjectFamily>> familyVersionChanges = VersionIndicatingProperties.collectPropertyChanges(categories, PropertyRole.FAMILY_VERSION, familyVersionKeys);
        Set<VersionProperty<ProjectFamily>> familyPrevVersionChanges = VersionIndicatingProperties.collectPropertyChanges(categories, PropertyRole.FAMILY_PREV_VERSION, familyPrevVersionKeys);
        Set<VersionProperty<MavenCoordinates>> projectVersionChanges = VersionIndicatingProperties.collectPropertyChanges(categories, PropertyRole.PROJECT_VERSION, projectVersionKeys);
        Set<VersionProperty<MavenCoordinates>> projectPrevVersionChanges = VersionIndicatingProperties.collectPropertyChanges(categories, PropertyRole.PROJECT_PREV_VERSION, projectPrevVersionKeys);
        return new VersionIndicatingProperties(familyVersionChanges, familyPrevVersionChanges, projectVersionChanges, projectPrevVersionChanges);
    }

    public static void buildFamilyMappings(PomCategorizer categories, Map<String, ProjectFamily> familyVersionKeys, Map<String, ProjectFamily> familyPrevVersionKeys) {
        for (ProjectFamily fam : categories.pomsForFamily().keySet()) {
            VersionIndicatingProperties.putPermutations(fam, familyVersionKeys, ".version");
            VersionIndicatingProperties.putPermutations(fam, familyPrevVersionKeys, ".previous.version", ".published.version", ".prev.version");
        }
    }

    private static void putPermutations(ProjectFamily family, Map<String, ProjectFamily> into, String ... suffixen) {
        for (String s : suffixen) {
            into.put(family + s, family);
        }
    }

    public static void buildVersionPropertyMappings(PomCategorizer categories, Map<String, MavenCoordinates> projectVersionKeys, Map<String, MavenCoordinates> projectPrevVersionKeys) {
        for (MavenCoordinates coords : categories.allCoordinates()) {
            if (coords.artifactId().is(ProjectFamily.familyOf((GroupId)coords.groupId()).name())) continue;
            VersionIndicatingProperties.addVersionKeys(categories, false, coords, projectVersionKeys, ".version");
            VersionIndicatingProperties.addVersionKeys(categories, false, coords, projectPrevVersionKeys, ".previous.version", ".published.version");
        }
        for (MavenCoordinates coords : categories.allCoordinates()) {
            if (coords.artifactId().is(ProjectFamily.familyOf((GroupId)coords.groupId()).name())) continue;
            VersionIndicatingProperties.addVersionKeys(categories, true, coords, projectVersionKeys, ".version");
            VersionIndicatingProperties.addVersionKeys(categories, true, coords, projectPrevVersionKeys, ".previous.version", ".published.version");
        }
    }

    private static void addVersionKeys(PomCategorizer categories, boolean secondPass, MavenCoordinates coords, Map<String, MavenCoordinates> coordsMap, String ... suffixen) {
        String fam = ProjectFamily.familyOf((GroupId)coords.groupId()).name();
        String dashes = coords.artifactId().text();
        String dots = dashes.replace('-', '.');
        for (String suffix : suffixen) {
            if (secondPass) {
                if (coordsMap.containsKey(fam + suffix)) continue;
                System.out.println("FAMILY VERSION " + fam + suffix + " " + coords);
                coordsMap.put(fam + suffix, coords);
                continue;
            }
            categories.pomFor(coords).ifPresent(pom -> {
                if (categories.is((Pom)pom, PomRole.JAVA) && !coordsMap.containsKey(fam + suffix)) {
                    System.out.println("FAMILY VERSION " + fam + suffix + " " + coords);
                    coordsMap.put(fam + suffix, coords);
                }
            });
            if (!coordsMap.containsKey(dashes + suffix)) {
                System.out.println("PROJECT VERSION " + dashes + suffix + " " + coords);
                coordsMap.put(dashes + suffix, coords);
            }
            if (coordsMap.containsKey(dots + suffix)) continue;
            System.out.println("PROJECT VERSION " + dots + suffix + " " + coords);
            coordsMap.put(dots + suffix, coords);
        }
    }

    private static <T> Set<VersionProperty<T>> collectPropertyChanges(PomCategorizer categories, PropertyRole role, Map<String, T> props) {
        HashSet changes = new HashSet();
        props.forEach((property, target) -> {
            Map<String, Set<Pom>> valuesAndPoms = categories.pomsForValueOfProperty((String)property);
            valuesAndPoms.forEach((value, pomSet) -> pomSet.forEach(pom -> {
                VersionProperty<Object> change = new VersionProperty<Object>((String)property, (Pom)pom, target, (String)value);
                changes.add(change);
            }));
        });
        return changes;
    }

    Set<VersionProperty<?>> all() {
        HashSet result = new HashSet(this.familyVersionChanges);
        result.addAll(this.familyPrevVersionChanges);
        result.addAll(this.projectVersionChanges);
        result.addAll(this.projectPrevVersionChanges);
        return result;
    }

    public void collectMatches(Pom pom, BiConsumer<PropertyRole, ? super VersionProperty<?>> into) {
        Predicate<VersionProperty> test = prop -> prop.matches(pom);
        this.familyVersionChanges.stream().filter(test).forEach(prop -> into.accept(PropertyRole.FAMILY_VERSION, (VersionProperty<?>)prop));
        this.familyPrevVersionChanges.stream().filter(test).forEach(prop -> into.accept(PropertyRole.FAMILY_PREV_VERSION, (VersionProperty<?>)prop));
        this.projectVersionChanges.stream().filter(test).forEach(prop -> into.accept(PropertyRole.PROJECT_VERSION, (VersionProperty<?>)prop));
        this.projectPrevVersionChanges.stream().filter(test).forEach(prop -> into.accept(PropertyRole.PROJECT_PREV_VERSION, (VersionProperty<?>)prop));
    }

    public boolean isEmpty() {
        return this.familyVersionChanges.isEmpty() && this.familyPrevVersionChanges.isEmpty() && this.projectVersionChanges.isEmpty() && this.projectPrevVersionChanges.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendIfNotEmpty(PropertyRole.FAMILY_VERSION, this.familyVersionChanges, sb);
        this.appendIfNotEmpty(PropertyRole.FAMILY_PREV_VERSION, this.familyPrevVersionChanges, sb);
        this.appendIfNotEmpty(PropertyRole.PROJECT_VERSION, this.projectVersionChanges, sb);
        this.appendIfNotEmpty(PropertyRole.PROJECT_PREV_VERSION, this.projectPrevVersionChanges, sb);
        return sb.toString();
    }

    private void appendIfNotEmpty(PropertyRole heading, Set<? extends VersionProperty<?>> set, StringBuilder sb) {
        if (!set.isEmpty()) {
            sb.append("  ").append((Object)heading).append(":\n");
            set.forEach(change -> sb.append("   * ").append(change).append('\n'));
        }
    }
}

